/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.deployment;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.ui.deployment.beans.Component;
import org.wso2.carbon.ui.deployment.beans.Context;
import org.wso2.carbon.ui.deployment.beans.FileUploadExecutorConfig;
import org.wso2.carbon.ui.deployment.beans.Menu;
import org.wso2.carbon.ui.deployment.beans.Servlet;

public final class ComponentBuilder {
    private static Log log = LogFactory.getLog(ComponentBuilder.class);

    private ComponentBuilder() {
    }

    public static Component build(Bundle registeredBundle, BundleContext bundleContext) {
        Component component = null;
        Dictionary headers = registeredBundle.getHeaders();
        try {
            URL url = registeredBundle.getEntry("META-INF/component.xml");
            if (url != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found component.xml in bundle : " + registeredBundle.getSymbolicName()));
                }
                String bundleVersion = (String)headers.get("Bundle-Version");
                String bundleName = (String)headers.get("Bundle-Name");
                InputStream inputStream = url.openStream();
                component = ComponentBuilder.build(inputStream, bundleName, bundleVersion, bundleContext);
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot build component.xml for " + registeredBundle.getSymbolicName()), (Throwable)e);
        }
        return component;
    }

    public static Component build(InputStream componentIn, String componentName, String componentVersion, BundleContext bundleContext) throws CarbonException, XMLStreamException {
        XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(componentIn);
        StAXOMBuilder builder = new StAXOMBuilder(streamReader);
        OMElement document = builder.getDocumentElement();
        Component component = new Component();
        component.setName(componentName);
        component.setVersion(componentVersion);
        ComponentBuilder.processMenus(componentName, document, component);
        ComponentBuilder.processServlets(document, component);
        ComponentBuilder.processFileUploadConfigs(document, component);
        ComponentBuilder.processCustomUIs(document, component);
        ComponentBuilder.processOSGiServices(document, bundleContext);
        ComponentBuilder.processFrameworkConfiguration(document, component);
        ComponentBuilder.processContextConfiguration(componentName, document, component);
        return component;
    }

    private static void processOSGiServices(OMElement document, BundleContext bundleContext) throws CarbonException {
        OMElement osgiServiceEle = document.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "osgiServices"));
        if (osgiServiceEle == null) {
            return;
        }
        Iterator services = osgiServiceEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "service"));
        while (services.hasNext()) {
            Object obj;
            OMElement service = (OMElement)services.next();
            OMElement objectEle = service.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "object"));
            String objClazz = objectEle.getText().trim();
            try {
                Class<?> objectClazz = Class.forName(objClazz, true, ComponentBuilder.class.getClassLoader());
                obj = objectClazz.newInstance();
            }
            catch (Exception e) {
                String msg = "Cannot instantiate OSGi service class " + objClazz;
                log.error((Object)msg, (Throwable)e);
                throw new CarbonException(msg, (Throwable)e);
            }
            OMElement classesEle = service.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "classes"));
            ArrayList<String> classList = new ArrayList<String>();
            Iterator classes = classesEle.getChildElements();
            while (classes.hasNext()) {
                OMElement clazz = (OMElement)classes.next();
                classList.add(clazz.getText().trim());
            }
            OMElement propertiesEle = service.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "properties"));
            Hashtable<String, String> props = new Hashtable<String, String>();
            Iterator properties = propertiesEle.getChildElements();
            while (properties.hasNext()) {
                OMElement prop = (OMElement)properties.next();
                ((Dictionary)props).put(prop.getAttribute(new QName("name")).getAttributeValue().trim(), prop.getText().trim());
            }
            bundleContext.registerService(classList.toArray(new String[classList.size()]), obj, props);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Registered OSGi service " + objClazz));
        }
    }

    public static void processCustomUIs(OMElement document, Component component) {
        Iterator customUIElements = document.getChildrenWithName(new QName("http://products.wso2.org/carbon", "customUI"));
        while (customUIElements.hasNext()) {
            String msg;
            String uiPath;
            OMElement customUIElement = (OMElement)customUIElements.next();
            OMElement uiTypeElement = customUIElement.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "uiType"));
            String type = uiTypeElement != null ? uiTypeElement.getText() : "view";
            OMElement mediaTypeElement = customUIElement.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "mediaType"));
            String mediaType = mediaTypeElement != null ? mediaTypeElement.getText() : null;
            OMElement uiPathElement = customUIElement.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "uiPath"));
            String string = uiPath = uiPathElement != null ? uiPathElement.getText() : null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Read the custom UI configuration. Media type: " + mediaType + ", UI path: " + uiPath + ", Type: " + type));
            }
            if (mediaType != null && uiPath != null) {
                if ("view".equals(type)) {
                    component.addCustomViewUI(mediaType, uiPath);
                    continue;
                }
                if ("add".equals(type)) {
                    component.addCustomAddUI(mediaType, uiPath);
                    continue;
                }
                msg = "Unknown custom UI type for media type " + mediaType + " and UI path " + uiPath + ". This custom UI will not be enabled. Custom UI type should be 'view' or 'add'.";
                log.error((Object)msg);
                continue;
            }
            msg = "Required information missing in custom UI configuration. Media type and UI path should contain a valid value.";
            log.error((Object)msg);
        }
    }

    private static void processFileUploadConfigs(OMElement document, Component component) throws CarbonException {
        OMElement fileUploadConfigElement = document.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "FileUploadConfig"));
        if (fileUploadConfigElement != null) {
            Iterator iterator = fileUploadConfigElement.getChildElements();
            while (iterator.hasNext()) {
                OMElement mapppingElement = (OMElement)iterator.next();
                if (!mapppingElement.getLocalName().equalsIgnoreCase("Mapping")) continue;
                OMElement actionsElement = mapppingElement.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "Actions"));
                String confPath = System.getProperty("carbon.config.dir.path");
                if (actionsElement == null) {
                    String msg;
                    if (confPath == null) {
                        msg = "The mandatory FileUploadConfig/Actions entry does not exist or is empty in the CARBON_HOME/repository/conf/carbon.xml file. Please fix this error in the  carbon.xml file and restart.";
                    } else {
                        String relativeConfDirPath = Paths.get(System.getProperty("carbon.home"), new String[0]).relativize(Paths.get(confPath, new String[0])).toString();
                        msg = "The mandatory FileUploadConfig/Actions entry does not exist or is empty in the CARBON_HOME/" + relativeConfDirPath + "/carbon.xmlfile. Please fix this error in the  carbon.xml file and restart.";
                    }
                    log.error((Object)msg);
                    throw new CarbonException(msg);
                }
                Iterator actionElementIterator = actionsElement.getChildrenWithName(new QName("http://products.wso2.org/carbon", "Action"));
                if (!actionElementIterator.hasNext()) {
                    String msg;
                    if (confPath == null) {
                        msg = "A FileUploadConfig/Mapping entry in the CARBON_HOME/repository/conf/carbon.xml should have at least on Action defined. Please fix this error in the carbon.xml file and restart.";
                    } else {
                        String relativeConfDirPath = Paths.get(System.getProperty("carbon.home"), new String[0]).relativize(Paths.get(confPath, new String[0])).toString();
                        msg = "A FileUploadConfig/Mapping entry in the CARBON_HOME/" + relativeConfDirPath + "/carbon.xml should have at least on Action defined. Please fix this error in the carbon.xml file and restart.";
                    }
                    log.error((Object)msg);
                    throw new CarbonException(msg);
                }
                OMElement classElement = mapppingElement.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "Class"));
                if (classElement == null || classElement.getText() == null) {
                    String msg;
                    if (confPath == null) {
                        msg = "The mandatory FileUploadConfig/Mapping/Class entry does not exist or is empty in the CARBON_HOME/repository/conf/carbon.xml file. Please fix this error in the  carbon.xml file and restart.";
                    } else {
                        String relativeConfDirPath = Paths.get(System.getProperty("carbon.home"), new String[0]).relativize(Paths.get(confPath, new String[0])).toString();
                        msg = "The mandatory FileUploadConfig/Mapping/Class entry does not exist or is empty in the CARBON_HOME/" + relativeConfDirPath + "/carbon.xml file. Please fix this error in the  carbon.xml file and restart.";
                    }
                    log.error((Object)msg);
                    throw new CarbonException(msg);
                }
                FileUploadExecutorConfig executorConfig = new FileUploadExecutorConfig();
                String className = classElement.getText().trim();
                executorConfig.setFUploadExecClass(className);
                while (actionElementIterator.hasNext()) {
                    OMElement actionElement = (OMElement)actionElementIterator.next();
                    if (actionElement.getText() == null) {
                        String msg;
                        if (confPath == null) {
                            msg = "A FileUploadConfig/Mapping/Actions/Action element in the CARBON_HOME/repository/conf/carbon.xml file is empty. Please include the correct value in this file and restart.";
                        } else {
                            String relativeConfDirPath = Paths.get(System.getProperty("carbon.home"), new String[0]).relativize(Paths.get(confPath, new String[0])).toString();
                            msg = "A FileUploadConfig/Mapping/Actions/Action element in the CARBON_HOME/" + relativeConfDirPath + "/carbon.xml file is empty. Please include the correct value in this file and restart.";
                        }
                        log.error((Object)msg);
                        throw new CarbonException(msg);
                    }
                    executorConfig.addMappingAction(actionElement.getText().trim());
                }
                component.addFileUploadExecutorConfig(executorConfig);
            }
        }
    }

    private static void processServlets(OMElement document, Component component) {
        OMElement servletsEle = document.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "servlets"));
        if (servletsEle != null) {
            Iterator iterator = servletsEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "servlet"));
            while (iterator.hasNext()) {
                Iterator urlPatternEles;
                Iterator servletClassEles;
                Iterator displayNameEles;
                Iterator nameEles;
                OMElement servletEle = (OMElement)iterator.next();
                Servlet servlet = new Servlet();
                OMAttribute attrib = servletEle.getAttribute(new QName("id"));
                if (attrib != null) {
                    servlet.setId(attrib.getAttributeValue());
                }
                if ((nameEles = servletEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "servlet-name"))).hasNext()) {
                    OMElement nameEle = (OMElement)nameEles.next();
                    servlet.setName(nameEle.getText());
                }
                if ((displayNameEles = servletEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "display-name"))).hasNext()) {
                    OMElement displayNameEle = (OMElement)displayNameEles.next();
                    servlet.setDisplayName(displayNameEle.getText().trim());
                }
                if ((servletClassEles = servletEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "servlet-class"))).hasNext()) {
                    OMElement servletClassEle = (OMElement)servletClassEles.next();
                    servlet.setServletClass(servletClassEle.getText().trim());
                }
                if ((urlPatternEles = servletEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "url-pattern"))).hasNext()) {
                    OMElement urlPatternEle = (OMElement)urlPatternEles.next();
                    servlet.setUrlPatten(urlPatternEle.getText().trim());
                }
                component.addServlet(servlet);
            }
        }
    }

    private static void processFrameworkConfiguration(OMElement document, Component component) {
        OMElement bypassesEle = document.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "framework-configuration"));
        if (bypassesEle != null) {
            Iterator iterator = bypassesEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "bypass"));
            while (iterator.hasNext()) {
                Iterator requireSkipHttpUrlEles;
                Iterator requireSkipTilesEles;
                OMElement bypassEle = (OMElement)iterator.next();
                Iterator requireAuthenticationEles = bypassEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "authentication"));
                if (requireAuthenticationEles.hasNext()) {
                    OMElement skipAuthElement = (OMElement)requireAuthenticationEles.next();
                    Iterator skipLinkEles = skipAuthElement.getChildrenWithName(new QName("http://products.wso2.org/carbon", "link"));
                    while (skipLinkEles.hasNext()) {
                        OMElement skipLinkElement = (OMElement)skipLinkEles.next();
                        if (!skipLinkElement.getLocalName().equalsIgnoreCase("link") || skipLinkElement.getText() == null) continue;
                        component.addUnauthenticatedUrl(skipLinkElement.getText());
                    }
                }
                if ((requireSkipTilesEles = bypassEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "tiles"))).hasNext()) {
                    OMElement skipTilesElement = (OMElement)requireSkipTilesEles.next();
                    Iterator skipLinkEles = skipTilesElement.getChildrenWithName(new QName("http://products.wso2.org/carbon", "link"));
                    while (skipLinkEles.hasNext()) {
                        OMElement skipLinkElement = (OMElement)skipLinkEles.next();
                        if (!skipLinkElement.getLocalName().equalsIgnoreCase("link") || skipLinkElement.getText() == null) continue;
                        component.addSkipTilesUrl(skipLinkElement.getText());
                    }
                }
                if (!(requireSkipHttpUrlEles = bypassEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "httpUrls"))).hasNext()) continue;
                OMElement SkipHttpUrlElement = (OMElement)requireSkipHttpUrlEles.next();
                Iterator skipLinkEles = SkipHttpUrlElement.getChildrenWithName(new QName("http://products.wso2.org/carbon", "link"));
                while (skipLinkEles.hasNext()) {
                    OMElement skipLinkElement = (OMElement)skipLinkEles.next();
                    if (!skipLinkElement.getLocalName().equalsIgnoreCase("link") || skipLinkElement.getText() == null) continue;
                    component.addSkipHttpsUrlList(skipLinkElement.getText());
                }
            }
        }
    }

    private static void processContextConfiguration(String componentName, OMElement document, Component component) {
        OMElement contextsEle = document.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "contexts"));
        if (contextsEle != null) {
            Iterator iterator = contextsEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "context"));
            while (iterator.hasNext()) {
                OMElement contextEle = (OMElement)iterator.next();
                Context context = new Context();
                Iterator contextIdEles = contextEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "context-id"));
                if (contextIdEles.hasNext()) {
                    OMElement idEle = (OMElement)contextIdEles.next();
                    context.setContextId(idEle.getText());
                } else {
                    log.warn((Object)(componentName + " contains a component.xml with empty context id"));
                }
                Iterator contextNameEles = contextEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "context-name"));
                if (contextNameEles.hasNext()) {
                    OMElement nameEle = (OMElement)contextNameEles.next();
                    context.setContextName(nameEle.getText());
                } else {
                    log.warn((Object)(componentName + " contains a component.xml with empty context name"));
                }
                Iterator contextProtocolEles = contextEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "protocol"));
                if (contextProtocolEles.hasNext()) {
                    OMElement protocolEle = (OMElement)contextProtocolEles.next();
                    context.setProtocol(protocolEle.getText());
                } else {
                    log.warn((Object)(componentName + " contains a component.xml with empty protocol"));
                }
                Iterator contextDescEles = contextEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "description"));
                if (contextDescEles.hasNext()) {
                    OMElement descEle = (OMElement)contextDescEles.next();
                    context.setDescription(descEle.getText());
                } else {
                    log.warn((Object)(componentName + " contains a component.xml with empty context description"));
                }
                component.addContext(context);
            }
        }
    }

    public static void processMenus(String componentName, OMElement document, Component component) {
        OMElement menusEle = document.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "menus"));
        if (menusEle != null) {
            Iterator iterator = menusEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "menu"));
            while (iterator.hasNext()) {
                Iterator urlParamsEles;
                OMElement requireServiceModeEle;
                Iterator requireServiceModeEls;
                OMElement requireNotLoggedInEle;
                Iterator requireNotLoggedInEles;
                OMElement requireNotSuperTenantEle;
                Iterator requireNotSuperTenantEles;
                OMElement requireSuperTenantEle;
                Iterator requireAuthenticationEles;
                Iterator styleClassEles;
                Iterator orderEles;
                Iterator linkEles;
                Iterator iconEles;
                Iterator regionEles;
                Iterator parentMenuEles;
                Iterator i18nBundleEles;
                OMElement menuEle = (OMElement)iterator.next();
                Menu menu = new Menu();
                Iterator idEles = menuEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "id"));
                if (idEles.hasNext()) {
                    OMElement idEle = (OMElement)idEles.next();
                    menu.setId(idEle.getText());
                } else {
                    log.warn((Object)(componentName + " contains a component.xml with empty menu id"));
                }
                Iterator i18nKeyEles = menuEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "i18n-key"));
                if (i18nKeyEles.hasNext()) {
                    OMElement i18nKeyEle = (OMElement)i18nKeyEles.next();
                    menu.setI18nKey(i18nKeyEle.getText());
                }
                if ((i18nBundleEles = menuEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "i18n-bundle"))).hasNext()) {
                    OMElement i18nBundleEle = (OMElement)i18nBundleEles.next();
                    menu.setI18nBundle(i18nBundleEle.getText());
                }
                if ((parentMenuEles = menuEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "parent-menu"))).hasNext()) {
                    OMElement parentMenuEle = (OMElement)parentMenuEles.next();
                    menu.setParentMenu(parentMenuEle.getText());
                }
                if ((regionEles = menuEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "region"))).hasNext()) {
                    OMElement regionEle = (OMElement)regionEles.next();
                    menu.setRegion(regionEle.getText());
                }
                if ((iconEles = menuEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "icon"))).hasNext()) {
                    OMElement iconEle = (OMElement)iconEles.next();
                    menu.setIcon(iconEle.getText());
                }
                if ((linkEles = menuEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "link"))).hasNext()) {
                    OMElement linkEle = (OMElement)linkEles.next();
                    menu.setLink(linkEle.getText());
                }
                if ((orderEles = menuEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "order"))).hasNext()) {
                    OMElement orderEle = (OMElement)orderEles.next();
                    menu.setOrder(orderEle.getText());
                }
                if ((styleClassEles = menuEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "style-class"))).hasNext()) {
                    OMElement styleEle = (OMElement)styleClassEles.next();
                    menu.setStyleClass(styleEle.getText());
                }
                if ((requireAuthenticationEles = menuEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "skip-authentication"))).hasNext()) {
                    menu.setRequireAuthentication(false);
                    component.addUnauthenticatedUrl(menu.getLink());
                    OMElement skipAuthElement = (OMElement)requireAuthenticationEles.next();
                    Iterator skipLinkEles = skipAuthElement.getChildrenWithName(new QName("http://products.wso2.org/carbon", "skip-link"));
                    while (skipLinkEles.hasNext()) {
                        OMElement skipLinkElement = (OMElement)skipLinkEles.next();
                        if (!skipLinkElement.getLocalName().equalsIgnoreCase("skip-link") || skipLinkElement.getText() == null) continue;
                        component.addUnauthenticatedUrl(skipLinkElement.getText());
                    }
                }
                Iterator requirePermissionElements = menuEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "require-permission"));
                LinkedList<String> permissions = new LinkedList<String>();
                while (requirePermissionElements.hasNext()) {
                    OMElement permissionEle = (OMElement)requirePermissionElements.next();
                    permissions.add(permissionEle.getText());
                }
                if (permissions.size() > 0) {
                    menu.setRequirePermission(permissions.toArray(new String[permissions.size()]));
                } else {
                    Iterator permissionElements = menuEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "all"));
                    if (permissionElements.hasNext()) {
                        menu.setAllPermissionsRequired(true);
                    } else {
                        permissionElements = menuEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "at-least"));
                        if (permissionElements.hasNext()) {
                            menu.setAtLeastOnePermissionsRequired(true);
                        }
                    }
                    if (permissionElements.hasNext()) {
                        OMElement permissionsEle = (OMElement)permissionElements.next();
                        requirePermissionElements = permissionsEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "require-permission"));
                        while (requirePermissionElements.hasNext()) {
                            OMElement permissionEle = (OMElement)requirePermissionElements.next();
                            permissions.add(permissionEle.getText());
                        }
                        if (permissions.size() > 0) {
                            menu.setRequirePermission(permissions.toArray(new String[permissions.size()]));
                        }
                    }
                }
                Iterator requireSuperTenantEles = menuEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "require-super-tenant"));
                if (requireSuperTenantEles.hasNext() && "true".equalsIgnoreCase((requireSuperTenantEle = (OMElement)requireSuperTenantEles.next()).getText())) {
                    menu.setRequireSuperTenant(true);
                }
                if ((requireNotSuperTenantEles = menuEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "require-not-super-tenant"))).hasNext() && "true".equalsIgnoreCase((requireNotSuperTenantEle = (OMElement)requireNotSuperTenantEles.next()).getText())) {
                    menu.setRequireNotSuperTenant(true);
                }
                if ((requireNotLoggedInEles = menuEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "require-not-logged-in"))).hasNext() && "true".equalsIgnoreCase((requireNotLoggedInEle = (OMElement)requireNotLoggedInEles.next()).getText())) {
                    menu.setRequireNotLoggedIn(true);
                }
                if ((requireServiceModeEls = menuEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "require-cloud-deployment"))).hasNext() && "true".equalsIgnoreCase((requireServiceModeEle = (OMElement)requireServiceModeEls.next()).getText())) {
                    menu.setRequireCloudDeployment(true);
                }
                if ((urlParamsEles = menuEle.getChildrenWithName(new QName("http://products.wso2.org/carbon", "url-params"))).hasNext()) {
                    OMElement urlParamsEle = (OMElement)urlParamsEles.next();
                    menu.setUrlParameters(urlParamsEle.getText());
                }
                component.addMenu(menu);
            }
        }
    }
}

