/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.wso2.carbon.ui.BundleProxyClassLoader;
import org.wso2.carbon.ui.JSPContextFinder;
import org.wso2.carbon.ui.JspServlet;
import org.wso2.carbon.ui.internal.CarbonUIServiceComponent;

public class JspClassLoader
extends URLClassLoader {
    private static final Bundle JASPERBUNDLE = CarbonUIServiceComponent.getBundle(JspServlet.class);
    private static final ClassLoader PARENT = JspClassLoader.class.getClassLoader().getParent();
    private static final String JAVA_PACKAGE = "java.";
    protected ClassLoader system = null;
    private static final ClassLoader EMPTY_CLASSLOADER = new ClassLoader(null){

        @Override
        public URL getResource(String name) {
            return null;
        }

        public Enumeration findResources(String name) throws IOException {
            return new Enumeration(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                public Object nextElement() {
                    return null;
                }
            };
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException(name);
        }
    };
    private PermissionCollection permissions;
    private List<String> systemPackages;
    private Log log = LogFactory.getLog(JspClassLoader.class);

    public JspClassLoader(Bundle bundle, PermissionCollection permissions) {
        super(new URL[0], (ClassLoader)new BundleProxyClassLoader(bundle, (ClassLoader)new BundleProxyClassLoader(JASPERBUNDLE, (ClassLoader)new JSPContextFinder(EMPTY_CLASSLOADER))));
        this.permissions = permissions;
        this.addBundleClassPathJars(bundle);
        this.system = JspClassLoader.getSystemClassLoader();
        String configPath = System.getProperty("carbon.config.dir.path");
        String launchIniPath = configPath == null ? Paths.get(System.getProperty("carbon.home"), "repository", "conf", "etc", "launch.ini").toString() : Paths.get(configPath, "etc", "launch.ini").toString();
        this.readSystemPackagesList(launchIniPath);
    }

    private void addBundleClassPathJars(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String classPath = (String)headers.get("Bundle-ClassPath");
        if (classPath != null) {
            StringTokenizer tokenizer = new StringTokenizer(classPath, ",");
            while (tokenizer.hasMoreTokens()) {
                URL entry;
                String candidate = tokenizer.nextToken().trim();
                if (!candidate.endsWith(".jar") || (entry = bundle.getEntry(candidate)) == null) continue;
                try {
                    URL jarEntryURL = new URL("jar:" + entry.toString() + "!/");
                    super.addURL(jarEntryURL);
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (PARENT != null && name.startsWith(JAVA_PACKAGE)) {
            return PARENT.loadClass(name);
        }
        return super.loadClass(name, resolve);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        return this.permissions;
    }

    private boolean isSystemPackage(String resourceName) {
        String packageName = (resourceName = resourceName.replace(".class", "").replace("/", ".")).lastIndexOf(".") == -1 ? resourceName : resourceName.substring(0, resourceName.lastIndexOf("."));
        return this.systemPackages.contains(packageName);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        ClassLoader loader;
        InputStream stream = super.getResourceAsStream(name);
        if (stream != null) {
            return stream;
        }
        if (name.endsWith(".class") && this.isSystemPackage(name) && (stream = (loader = this.system).getResourceAsStream(name)) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"  --> Returning stream from system classloader");
            }
            return stream;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSystemPackagesList(String launchIniPath) {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(launchIniPath);
            properties.load(fileInputStream);
            String rawSystemPackages = properties.getProperty("org.osgi.framework.system.packages");
            String[] systemPackagesArray = rawSystemPackages.split("[ ]?,[ ]?");
            this.systemPackages = Arrays.asList(systemPackagesArray);
        }
        catch (IOException e) {
            this.log.warn((Object)"Error reading system packages list from launch.ini", (Throwable)e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

