/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.store.util;

import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.rahas.Token;
import org.apache.rahas.TrustException;
import org.wso2.carbon.identity.sts.store.SerializableToken;

public class STSStoreUtils {
    private STSStoreUtils() {
    }

    public static SerializableToken getSerializableToken(Token token) {
        SerializableToken serializableToken = new SerializableToken();
        serializableToken.setId(token.getId());
        serializableToken.setState(token.getState());
        serializableToken.setToken(token.getToken().toString());
        if (token.getPreviousToken() != null) {
            serializableToken.setPreviousToken(token.getPreviousToken().toString());
        }
        if (token.getAttachedReference() != null) {
            serializableToken.setAttachedReference(token.getAttachedReference().toString());
        }
        if (token.getUnattachedReference() != null) {
            serializableToken.setUnattachedReference(token.getUnattachedReference().toString());
        }
        if (token.getProperties() != null) {
            serializableToken.setProperties(token.getProperties());
        }
        serializableToken.setSecret(token.getSecret());
        serializableToken.setCreated(token.getCreated());
        serializableToken.setExpires(token.getExpires());
        serializableToken.setIssuerAddress(token.getIssuerAddress());
        serializableToken.setPersistenceEnabled(token.isPersistenceEnabled());
        serializableToken.setChanged(token.isChanged());
        return serializableToken;
    }

    public static Token getToken(SerializableToken serializableToken) throws TrustException, XMLStreamException {
        Token token1 = new Token(serializableToken.getId(), AXIOMUtil.stringToOM((String)serializableToken.getToken()), serializableToken.getCreated(), serializableToken.getExpires());
        token1.setState(serializableToken.getState());
        if (serializableToken.getPreviousToken() != null) {
            token1.setPreviousToken(AXIOMUtil.stringToOM((String)serializableToken.getPreviousToken()));
        }
        if (serializableToken.getAttachedReference() != null) {
            token1.setAttachedReference(AXIOMUtil.stringToOM((String)serializableToken.getAttachedReference()));
        }
        if (serializableToken.getUnattachedReference() != null) {
            token1.setUnattachedReference(AXIOMUtil.stringToOM((String)serializableToken.getUnattachedReference()));
        }
        token1.setProperties(serializableToken.getProperties());
        token1.setSecret(serializableToken.getSecret());
        token1.setIssuerAddress(serializableToken.getIssuerAddress());
        token1.setPersistenceEnabled(serializableToken.isPersistenceEnabled());
        token1.setChanged(serializableToken.isChanged());
        return token1;
    }
}

