/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.store.dao;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.Token;
import org.apache.rahas.TrustException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;

public class DBStsDAO {
    private static final Log log = LogFactory.getLog(DBStsDAO.class);

    public void addToken(Token token) throws TrustException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String query = "INSERT INTO IDN_STS_STORE (TOKEN_ID, TOKEN_CONTENT,CREATE_DATE, EXPIRE_DATE,STATE)  VALUES (?,?,?,?,?)";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, token.getId());
            byte[] tokenByteContainer = this.getTokenContent(token);
            ByteArrayInputStream tokenInputStream = new ByteArrayInputStream(tokenByteContainer);
            prepStmt.setBinaryStream(2, (InputStream)tokenInputStream, tokenByteContainer.length);
            prepStmt.setTimestamp(3, new Timestamp(token.getCreated().getTime()));
            prepStmt.setTimestamp(4, new Timestamp(token.getExpires().getTime()));
            prepStmt.setInt(5, token.getState());
            prepStmt.execute();
            connection.commit();
        }
        catch (Exception e) {
            IdentityDatabaseUtil.rollBack((Connection)connection);
            String msg = "Failed to add token";
            throw new TrustException(msg, (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, (PreparedStatement)prepStmt);
        }
    }

    public void updateToken(Token token) throws TrustException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String query = "UPDATE  IDN_STS_STORE SET TOKEN_CONTENT = ? ,CREATE_DATE = ?,EXPIRE_DATE = ?, STATE = ?  WHERE TOKEN_ID = ?";
        try {
            prepStmt = connection.prepareStatement(query);
            byte[] tokenByteContainer = this.getTokenContent(token);
            ByteArrayInputStream tokenInputStream = new ByteArrayInputStream(tokenByteContainer);
            prepStmt.setBinaryStream(1, (InputStream)tokenInputStream, tokenByteContainer.length);
            prepStmt.setTimestamp(2, new Timestamp(token.getCreated().getTime()));
            prepStmt.setTimestamp(3, new Timestamp(token.getExpires().getTime()));
            prepStmt.setInt(4, token.getState());
            prepStmt.setString(5, token.getId());
            prepStmt.executeUpdate();
            connection.commit();
        }
        catch (Exception e) {
            IdentityDatabaseUtil.rollBack((Connection)connection);
            String msg = "Failed to update token ";
            throw new TrustException(msg, (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, (PreparedStatement)prepStmt);
        }
    }

    public void removeToken(String tokenId) throws TrustException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String query = "DELETE FROM  IDN_STS_STORE WHERE TOKEN_ID = ?";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, tokenId);
            prepStmt.executeUpdate();
        }
        catch (Exception e) {
            String msg = "Failed to remove token";
            throw new TrustException(msg, (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, (PreparedStatement)prepStmt);
        }
    }

    public String[] getAllTokenKeys() throws TrustException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String[] keys = new String[]{};
        String query = "SELECT TOKEN_ID  FROM  IDN_STS_STORE";
        try {
            prepStmt = connection.prepareStatement(query);
            rs = prepStmt.executeQuery();
            ArrayList<String> keyList = new ArrayList<String>();
            if (rs != null) {
                while (rs.next()) {
                    keyList.add(rs.getString("TOKEN_ID"));
                }
            }
            if (!keyList.isEmpty()) {
                keys = keyList.toArray(new String[keyList.size()]);
            }
        }
        catch (Exception e) {
            try {
                String msg = "Failed to get all tokens";
                throw new TrustException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, (PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)prepStmt);
        return keys;
    }

    public Token getToken(String tokenId) throws TrustException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        Token token = null;
        String query = "SELECT TOKEN_CONTENT  FROM  IDN_STS_STORE  WHERE TOKEN_ID = ?";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, tokenId);
            rs = prepStmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    Blob tokenContent = rs.getBlob("TOKEN_CONTENT");
                    byte[] tokenContentBytes = tokenContent.getBytes(1L, (int)tokenContent.length());
                    token = this.getToken(tokenContentBytes);
                }
            }
        }
        catch (Exception e) {
            try {
                String msg = "Failed to get token";
                throw new TrustException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, (PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)prepStmt);
        return token;
    }

    private Token getToken(byte[] tokenContentBytes) throws TrustException {
        Token token;
        try {
            ByteArrayInputStream tokenContentByteArray = new ByteArrayInputStream(tokenContentBytes);
            ObjectInputStream tokenContentObject = new ObjectInputStream(tokenContentByteArray);
            Object tokenObj = tokenContentObject.readObject();
            token = (Token)tokenObj;
        }
        catch (Exception e) {
            String msg = "Failed to convert blob content to Token object ";
            throw new TrustException(msg, (Throwable)e);
        }
        return token;
    }

    public List<Token> getTokens() throws TrustException {
        ArrayList<Token> arrayList;
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<Token> tokens = new ArrayList<Token>();
        String query = "SELECT *  FROM  IDN_STS_STORE";
        try {
            prepStmt = connection.prepareStatement(query);
            rs = prepStmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    tokens.add(this.getToken((byte[])rs.getObject("TOKEN_CONTENT")));
                }
            }
            arrayList = tokens;
        }
        catch (Exception e) {
            try {
                String msg = "Failed to get all  tokens";
                throw new TrustException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, (PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)prepStmt);
        return arrayList;
    }

    public Token[] getValidTokens(int[] status) throws TrustException {
        Token token;
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<Token> tokens = new ArrayList<Token>();
        String query = "SELECT *  FROM  IDN_STS_STORE WHERE STATE =? OR STATE =?";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setInt(1, 1);
            prepStmt.setInt(2, 4);
            rs = prepStmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    token = this.getToken((byte[])rs.getObject("TOKEN_CONTENT"));
                    tokens.add(token);
                }
            }
            token = tokens.toArray(new Token[tokens.size()]);
        }
        catch (Exception e) {
            try {
                String msg = "Failed to get valid tokens";
                throw new TrustException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, (PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)prepStmt);
        return token;
    }

    public Token[] getExpiredTokens(int status) throws TrustException {
        return this.getTokens(status);
    }

    public Token[] getRenewedTokens(int status) throws TrustException {
        return this.getTokens(status);
    }

    public Token[] getCancelledTokens(int status) throws TrustException {
        return this.getTokens(status);
    }

    private Token[] getTokens(int status) throws TrustException {
        Token token;
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<Token> tokens = new ArrayList<Token>();
        String query = "SELECT *  FROM  IDN_STS_STORE WHERE STATE = ?";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setInt(1, status);
            rs = prepStmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    token = this.getToken((byte[])rs.getObject("TOKEN_CONTENT"));
                    tokens.add(token);
                }
            }
            token = tokens.toArray(new Token[tokens.size()]);
        }
        catch (Exception e) {
            try {
                String msg = "Failed to get token";
                log.error((Object)msg, (Throwable)e);
                throw new TrustException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, (PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)prepStmt);
        return token;
    }

    public boolean isTokensExist() throws TrustException {
        boolean tokenExist;
        ResultSet rs;
        PreparedStatement prepStmt;
        Connection connection;
        block4: {
            boolean bl;
            connection = IdentityDatabaseUtil.getDBConnection();
            prepStmt = null;
            rs = null;
            tokenExist = false;
            String query = "SELECT 1  FROM  IDN_STS_STORE";
            try {
                prepStmt = connection.prepareStatement(query);
                rs = prepStmt.executeQuery();
                if (rs == null || !rs.next()) break block4;
                bl = true;
            }
            catch (Exception e) {
                try {
                    String msg = "Failed to check token exist";
                    log.error((Object)msg, (Throwable)e);
                    throw new TrustException(msg, (Throwable)e);
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, (PreparedStatement)prepStmt);
                    throw throwable;
                }
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)prepStmt);
            return bl;
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)prepStmt);
        return tokenExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getTokenContent(Token token) throws IOException {
        ByteArrayOutputStream tokenArrayStream = new ByteArrayOutputStream();
        byte[] tokenBytes = null;
        try (ObjectOutputStream tokenObjectStream = null;){
            tokenObjectStream = new ObjectOutputStream(tokenArrayStream);
            tokenObjectStream.writeObject(token);
            tokenObjectStream.flush();
            tokenBytes = tokenArrayStream.toByteArray();
        }
        return tokenBytes;
    }
}

