/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.store;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.Token;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.wso2.carbon.identity.sts.store.SerializableToken;
import org.wso2.carbon.identity.sts.store.dao.DBStsDAO;
import org.wso2.carbon.identity.sts.store.util.STSStoreUtils;

public class JDBCTokenStore
implements TokenStorage {
    private static final Log log = LogFactory.getLog(JDBCTokenStore.class);
    private static int poolSize = 100;
    private static ExecutorService executorService = Executors.newFixedThreadPool(poolSize);
    private DBStsDAO dbStsDAO;

    public static ExecutorService getExecutorService() {
        return executorService;
    }

    public static Cache<String, SerializableToken> getTokenCache() {
        CacheManager manager = Caching.getCacheManagerFactory().getCacheManager("STS_TOKEN_CACHE_MANAGER");
        return manager.getCache("STS_TOKEN_CACHE");
    }

    private String getTokenId(Token token) {
        if (token == null) {
            return "";
        }
        String tokenId = token.getId();
        if (tokenId != null && tokenId.startsWith("#")) {
            tokenId = tokenId.substring(1);
        }
        return tokenId;
    }

    private String getTokenId(String tokenId) {
        String tokenIdVal = tokenId;
        if (tokenId != null && tokenId.startsWith("#")) {
            tokenIdVal = tokenIdVal.substring(1);
        }
        return tokenIdVal;
    }

    public void add(Token token) throws TrustException {
        Cache<String, SerializableToken> tokenCache = JDBCTokenStore.getTokenCache();
        if (tokenCache != null) {
            tokenCache.put((Object)this.getTokenId(token), (Object)STSStoreUtils.getSerializableToken(token));
            executorService.submit(new TokenPersisterTask(token));
        }
    }

    public void update(Token token) throws TrustException {
        this.initDao();
        this.dbStsDAO.updateToken(token);
        Cache<String, SerializableToken> tokenCache = JDBCTokenStore.getTokenCache();
        if (tokenCache != null && tokenCache.containsKey((Object)this.getTokenId(token))) {
            tokenCache.put((Object)this.getTokenId(token), (Object)STSStoreUtils.getSerializableToken(token));
        }
    }

    public String[] getTokenIdentifiers() throws TrustException {
        this.initDao();
        return this.dbStsDAO.getAllTokenKeys();
    }

    public Token[] getExpiredTokens() throws TrustException {
        this.initDao();
        return this.dbStsDAO.getExpiredTokens(2);
    }

    public Token[] getValidTokens() throws TrustException {
        this.initDao();
        return this.dbStsDAO.getValidTokens(new int[]{1, 4});
    }

    public Token[] getRenewedTokens() throws TrustException {
        this.initDao();
        return this.dbStsDAO.getRenewedTokens(4);
    }

    public Token[] getCancelledTokens() throws TrustException {
        this.initDao();
        return this.dbStsDAO.getCancelledTokens(3);
    }

    public Token getToken(String id) throws TrustException {
        String tokenId = this.getTokenId(id);
        Cache<String, SerializableToken> tokenCache = JDBCTokenStore.getTokenCache();
        if (tokenCache != null && tokenCache.containsKey((Object)tokenId)) {
            try {
                return STSStoreUtils.getToken((SerializableToken)tokenCache.get((Object)tokenId));
            }
            catch (XMLStreamException e) {
                throw new TrustException("Failed to get Token from cache", (Throwable)e);
            }
        }
        this.initDao();
        Token token = this.dbStsDAO.getToken(tokenId);
        if (token == null) {
            log.debug((Object)"Token is not present in cache or database");
        }
        if (tokenCache != null && token != null) {
            tokenCache.put((Object)tokenId, (Object)STSStoreUtils.getSerializableToken(token));
        }
        return token;
    }

    public void removeToken(String id) throws TrustException {
        String tokenId = this.getTokenId(id);
        this.initDao();
        this.dbStsDAO.removeToken(tokenId);
        Cache<String, SerializableToken> tokenCache = JDBCTokenStore.getTokenCache();
        if (tokenCache != null && tokenCache.containsKey((Object)tokenId)) {
            tokenCache.remove((Object)tokenId);
        }
    }

    public List<Token> getStorageTokens() throws TrustException {
        this.initDao();
        return this.dbStsDAO.getTokens();
    }

    public void handlePersistence(List<?> persistingTokens) throws TrustException {
    }

    public void handlePersistenceOnShutdown() throws TrustException {
    }

    private void initDao() {
        if (this.dbStsDAO == null) {
            this.dbStsDAO = new DBStsDAO();
        }
    }

    protected static class TokenPersisterTask
    implements Runnable {
        private Token token;

        public TokenPersisterTask(Token token) {
            this.token = token;
        }

        @Override
        public void run() {
            try {
                this.persist();
            }
            catch (TrustException e) {
                log.error((Object)"Failed to persist token", (Throwable)e);
            }
        }

        private synchronized void persist() throws TrustException {
            try {
                new DBStsDAO().addToken(this.token);
            }
            catch (TrustException e) {
                throw new TrustException("Failed to persist token", (Throwable)e);
            }
        }
    }
}

