/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.store;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rahas.Token;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;

public class DBTokenStore
implements TokenStorage {
    private static Map<String, Token> tokenMap = new ConcurrentHashMap<String, Token>();

    private String getTokenId(Token token) {
        if (token == null) {
            return "";
        }
        String tokenId = token.getId();
        if (tokenId != null && tokenId.startsWith("#")) {
            tokenId = tokenId.substring(1);
        }
        return tokenId;
    }

    private String getTokenId(String tokenId) {
        String tokenIdVal = tokenId;
        if (tokenId != null && tokenId.startsWith("#")) {
            tokenIdVal = tokenIdVal.substring(1);
        }
        return tokenIdVal;
    }

    public void add(Token token) throws TrustException {
        tokenMap.put(this.getTokenId(token), token);
    }

    public void update(Token token) throws TrustException {
        tokenMap.put(this.getTokenId(token), token);
    }

    public String[] getTokenIdentifiers() throws TrustException {
        ArrayList<String> tokenIds = new ArrayList<String>();
        for (Map.Entry<String, Token> entry : tokenMap.entrySet()) {
            tokenIds.add(entry.getKey());
        }
        return tokenIds.toArray(new String[tokenIds.size()]);
    }

    public Token[] getExpiredTokens() throws TrustException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        Date now = new Date();
        for (Map.Entry<String, Token> entry : tokenMap.entrySet()) {
            Token tok = tokenMap.get(entry.getKey());
            if (tok.getExpires().getTime() >= now.getTime()) continue;
            tokens.add(tok);
        }
        return tokens.toArray(new Token[tokens.size()]);
    }

    public Token[] getValidTokens() throws TrustException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        Date now = new Date();
        for (Map.Entry<String, Token> entry : tokenMap.entrySet()) {
            Token tok = tokenMap.get(entry.getKey());
            if (tok.getExpires().getTime() <= now.getTime()) continue;
            tokens.add(tok);
        }
        return tokens.toArray(new Token[tokens.size()]);
    }

    public Token[] getRenewedTokens() throws TrustException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (Map.Entry<String, Token> entry : tokenMap.entrySet()) {
            Token tok = tokenMap.get(entry.getKey());
            if (4 != tok.getState()) continue;
            tokens.add(tok);
        }
        return tokens.toArray(new Token[tokens.size()]);
    }

    public Token[] getCancelledTokens() throws TrustException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (Map.Entry<String, Token> entry : tokenMap.entrySet()) {
            Token tok = tokenMap.get(entry.getKey());
            if (3 != tok.getState()) continue;
            tokens.add(tok);
        }
        return tokens.toArray(new Token[tokens.size()]);
    }

    public Token getToken(String id) throws TrustException {
        return tokenMap.get(this.getTokenId(id));
    }

    public void removeToken(String id) throws TrustException {
        tokenMap.remove(this.getTokenId(id));
    }

    public List<Token> getStorageTokens() throws TrustException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (Map.Entry<String, Token> entry : tokenMap.entrySet()) {
            Token tok = tokenMap.get(entry.getKey());
            tokens.add(tok);
        }
        return tokens;
    }

    public void handlePersistence(List<?> persistingTokens) throws TrustException {
    }

    public void handlePersistenceOnShutdown() throws TrustException {
    }
}

