/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.message.processor.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.MessageProcessorFactory;
import org.apache.synapse.config.xml.MessageProcessorSerializer;
import org.apache.synapse.message.MessageConsumer;
import org.apache.synapse.message.MessageProducer;
import org.apache.synapse.message.processor.MessageProcessor;
import org.apache.synapse.message.processor.impl.ScheduledMessageProcessor;
import org.apache.synapse.message.processor.impl.failover.FailoverMessageForwardingProcessorView;
import org.apache.synapse.message.processor.impl.failover.FailoverScheduledMessageForwardingProcessor;
import org.apache.synapse.message.processor.impl.forwarder.MessageForwardingProcessorView;
import org.apache.synapse.message.processor.impl.forwarder.ScheduledMessageForwardingProcessor;
import org.apache.synapse.message.processor.impl.sampler.SamplingProcessor;
import org.apache.synapse.message.processor.impl.sampler.SamplingProcessorView;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.message.processor.service.MessageProcessorMetaData;

public class MessageProcessorAdminService
extends AbstractServiceBusAdmin {
    public static final int MSGS_PER_PAGE = 10;
    public static final String DEFAULT_AXIS2_XML;
    private static Log log;
    private static String CONF_LOCATION;

    public void addMessageProcessor(String xml) throws AxisFault {
        try {
            OMElement msElem = this.createElement(xml);
            MessageProcessor messageProcessor = MessageProcessorFactory.createMessageProcessor((OMElement)msElem);
            if (messageProcessor != null && messageProcessor.getName() != null) {
                SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
                String fileName = ServiceBusUtils.generateFileName((String)messageProcessor.getName());
                messageProcessor.init(this.getSynapseEnvironment());
                messageProcessor.setFileName(fileName);
                synapseConfiguration.addMessageProcessor(messageProcessor.getName(), messageProcessor);
                if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                    MediationPersistenceManager mp = this.getMediationPersistenceManager();
                    mp.saveItem(messageProcessor.getName(), 11);
                }
            } else {
                String message = "Unable to create Message Processor ";
                this.handleException(log, message, null);
            }
        }
        catch (XMLStreamException e) {
            String message = "Unable to create Message Processor ";
            this.handleException(log, message, e);
        }
    }

    public void modifyMessageProcessor(String xml) throws AxisFault {
        try {
            OMElement msElem = this.createElement(xml);
            MessageProcessor messageProcessor = MessageProcessorFactory.createMessageProcessor((OMElement)msElem);
            if (messageProcessor != null && messageProcessor.getName() != null) {
                SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
                MessageProcessor removedProcessor = synapseConfiguration.removeMessageProcessor(messageProcessor.getName());
                if (removedProcessor != null) {
                    removedProcessor.destroy();
                }
                messageProcessor.init(this.getSynapseEnvironment());
                String fileName = ServiceBusUtils.generateFileName((String)messageProcessor.getName());
                messageProcessor.setFileName(fileName);
                synapseConfiguration.addMessageProcessor(messageProcessor.getName(), messageProcessor);
                if (removedProcessor.getArtifactContainerName() != null) {
                    messageProcessor.setArtifactContainerName(removedProcessor.getArtifactContainerName());
                    messageProcessor.setIsEdited(true);
                } else if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                    MediationPersistenceManager mp = this.getMediationPersistenceManager();
                    mp.saveItem(messageProcessor.getName(), 11);
                }
            } else {
                String message = "Unable to Update Message Processor ";
                this.handleException(log, message, null);
            }
        }
        catch (XMLStreamException e) {
            String message = "Unable to Modify Message Processor ";
            this.handleException(log, message, e);
        }
    }

    public String getMessageProcessor(String name) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        MessageProcessor processor = (MessageProcessor)configuration.getMessageProcessors().get(name);
        String xml = null;
        if (processor != null) {
            xml = MessageProcessorSerializer.serializeMessageProcessor(null, (MessageProcessor)processor).toString();
        } else {
            this.handleException(log, "Message Processor " + name + " does not exist", null);
        }
        return xml;
    }

    public void deleteMessageProcessor(String name) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        if (configuration.getMessageProcessors().containsKey(name)) {
            MessageProcessor processor = configuration.removeMessageProcessor(name);
            String fileName = processor.getFileName();
            if (processor != null) {
                processor.destroy();
            }
            if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                MediationPersistenceManager pm = this.getMediationPersistenceManager();
                pm.deleteItem(processor.getName(), fileName, 11);
            }
        } else {
            this.handleException(log, "Message Store " + name + " does not exist", null);
        }
    }

    public String[] getMessageProcessorNames() throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        Set names = configuration.getMessageProcessors().keySet();
        return names.toArray(new String[names.size()]);
    }

    public String[] getMessageIds(String processorName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        String[] messageIds = null;
        try {
            MessageProcessor processor;
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName) && (processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName)) instanceof ScheduledMessageProcessor) {
                MessageForwardingProcessorView view = ((ScheduledMessageForwardingProcessor)processor).getView();
                if (!view.isActive()) {
                    List msgList = view.messageIdList();
                    messageIds = msgList.toArray(new String[msgList.size()]);
                } else {
                    log.warn((Object)"Can't access Scheduled Message Forwarding Processor - Processor is active");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
        return messageIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProcessorMetaData[] getMessageProcessorDataList() throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration configuration = this.getSynapseConfiguration();
            Set names = configuration.getMessageProcessors().keySet();
            ArrayList<MessageProcessorMetaData> messageProcessorDataList = new ArrayList<MessageProcessorMetaData>();
            if (names != null && !names.isEmpty()) {
                for (String name : names) {
                    MessageProcessor messageProcessor = (MessageProcessor)configuration.getMessageProcessors().get(name);
                    MessageProcessorMetaData data = new MessageProcessorMetaData();
                    data.setName(name);
                    if (messageProcessor.getArtifactContainerName() != null) {
                        data.setArtifactContainerName(messageProcessor.getArtifactContainerName());
                    }
                    if (messageProcessor.isEdited()) {
                        data.setIsEdited(true);
                    }
                    messageProcessorDataList.add(data);
                }
            }
            MessageProcessorMetaData[] messageProcessorMetaDataArray = messageProcessorDataList.toArray(new MessageProcessorMetaData[messageProcessorDataList.size()]);
            return messageProcessorMetaDataArray;
        }
        finally {
            lock.unlock();
        }
    }

    public String getEnvelope(String processorName, String messageId) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        String message = null;
        try {
            MessageProcessor processor;
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName) && (processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName)) instanceof ScheduledMessageProcessor) {
                MessageForwardingProcessorView view = ((ScheduledMessageForwardingProcessor)processor).getView();
                if (!view.isActive()) {
                    message = view.getEnvelope(messageId);
                } else {
                    log.warn((Object)"Can't access Scheduled Message Forwarding Processor - Processor is active");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
        return message;
    }

    public void deleteMessage(String processorName, String messageId) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        try {
            MessageProcessor processor;
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName) && (processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName)) instanceof ScheduledMessageProcessor) {
                MessageForwardingProcessorView view = ((ScheduledMessageForwardingProcessor)processor).getView();
                if (!view.isActive()) {
                    view.delete(messageId);
                } else {
                    log.warn((Object)"Can't access Scheduled Message Forwarding Processor - Processor is active");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
    }

    public void deleteFirstMessages(String processorName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        throw new AxisFault("Unsupported operation.");
    }

    public void deleteAllMessages(String processorName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        try {
            MessageProcessor processor;
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName) && (processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName)) instanceof ScheduledMessageProcessor) {
                MessageForwardingProcessorView view = ((ScheduledMessageForwardingProcessor)processor).getView();
                if (!view.isActive()) {
                    view.deleteAll();
                } else {
                    log.warn((Object)"Can't access Scheduled Message Forwarding Processor - Processor is active");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
    }

    public void resend(String processorName, String messageId) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        try {
            MessageProcessor processor;
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName) && (processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName)) instanceof ScheduledMessageProcessor) {
                MessageForwardingProcessorView view = ((ScheduledMessageForwardingProcessor)processor).getView();
                if (!view.isActive()) {
                    view.resend(messageId);
                } else {
                    log.warn((Object)"Can't access Scheduled Message Forwarding Processor - Processor is active");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
    }

    public void resendFirstMessage(String processorName, String messageId) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        throw new AxisFault("Unsupported operation.");
    }

    public void resendAll(String processorName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        try {
            MessageProcessor processor;
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName) && (processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName)) instanceof ScheduledMessageProcessor) {
                MessageForwardingProcessorView view = ((ScheduledMessageForwardingProcessor)processor).getView();
                if (!view.isActive()) {
                    view.resendAll();
                } else {
                    log.warn((Object)"Can't access Scheduled Message Forwarding Processor - Processor is active");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
    }

    public int getSize(String processorName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        int size = 0;
        try {
            MessageProcessor processor;
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName) && (processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName)) instanceof ScheduledMessageProcessor) {
                MessageForwardingProcessorView view = ((ScheduledMessageForwardingProcessor)processor).getView();
                if (!view.isActive()) {
                    size = view.getSize();
                } else {
                    log.warn((Object)"Can't access Scheduled Message Forwarding Processor - Processor is active");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
        return size;
    }

    public boolean isActive(String processorName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        boolean active = false;
        try {
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName)) {
                FailoverMessageForwardingProcessorView view;
                MessageProcessor processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName);
                if (processor instanceof ScheduledMessageForwardingProcessor) {
                    MessageForwardingProcessorView view2 = ((ScheduledMessageForwardingProcessor)processor).getView();
                    if (view2 != null) {
                        active = view2.isActive();
                    }
                } else if (processor instanceof SamplingProcessor) {
                    SamplingProcessorView view3 = ((SamplingProcessor)processor).getView();
                    if (view3 != null) {
                        active = view3.isActive();
                    }
                } else if (processor instanceof FailoverScheduledMessageForwardingProcessor && (view = ((FailoverScheduledMessageForwardingProcessor)processor).getView()) != null) {
                    active = view.isActive();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
        return active;
    }

    public void activate(String processorName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        try {
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName)) {
                MessageProcessor processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName);
                if (processor instanceof ScheduledMessageForwardingProcessor) {
                    MessageForwardingProcessorView view = ((ScheduledMessageForwardingProcessor)processor).getView();
                    if (!view.isActive()) {
                        view.activate();
                        if (processor.getArtifactContainerName() == null && !Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                            this.getMediationPersistenceManager().saveItem(processor.getName(), 11);
                        }
                    } else {
                        log.warn((Object)"Scheduled Message Forwarding Processor is already active");
                    }
                } else if (processor instanceof FailoverScheduledMessageForwardingProcessor) {
                    FailoverMessageForwardingProcessorView view = ((FailoverScheduledMessageForwardingProcessor)processor).getView();
                    if (!view.isActive()) {
                        view.activate();
                    } else {
                        log.warn((Object)"Scheduled Failover Message Forwarding Processor is already active");
                    }
                } else if (processor instanceof SamplingProcessor) {
                    SamplingProcessorView view = ((SamplingProcessor)processor).getView();
                    if (!view.isActive()) {
                        view.activate();
                        if (processor.getArtifactContainerName() == null && !Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                            this.getMediationPersistenceManager().saveItem(processor.getName(), 11);
                        }
                    } else {
                        log.warn((Object)"Sampling Processor is already active");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
    }

    public void deactivate(String processorName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        try {
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName)) {
                MessageProcessor processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName);
                if (processor instanceof ScheduledMessageForwardingProcessor) {
                    MessageForwardingProcessorView view = ((ScheduledMessageForwardingProcessor)processor).getView();
                    if (view.isActive()) {
                        view.deactivate();
                    } else {
                        log.warn((Object)"Scheduled Message Forwarding Processor - already deActive");
                    }
                } else if (processor instanceof FailoverScheduledMessageForwardingProcessor) {
                    FailoverMessageForwardingProcessorView view = ((FailoverScheduledMessageForwardingProcessor)processor).getView();
                    if (view.isActive()) {
                        view.deactivate();
                    } else {
                        log.warn((Object)"Scheduled Failover Message Forwarding Processor - already deActive");
                    }
                } else if (processor instanceof SamplingProcessor) {
                    SamplingProcessorView view = ((SamplingProcessor)processor).getView();
                    if (view.isActive()) {
                        view.deactivate();
                        if (processor.getArtifactContainerName() == null && !Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                            this.getMediationPersistenceManager().saveItem(processor.getName(), 11);
                        }
                    } else {
                        log.warn((Object)"Sampling Message Processor - already in the deactivated state");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
    }

    public String getClassName(String name) throws AxisFault {
        MessageProcessor processorImpl = this.getMessageProcessorImpl(name);
        if (processorImpl != null) {
            return processorImpl.getClass().getName();
        }
        this.handleException(log, "Message Processor " + name + " does not exist !!!", null);
        return null;
    }

    private void handleException(Log log, String message, Exception e) throws AxisFault {
        if (e == null) {
            AxisFault exception = new AxisFault(message);
            log.error((Object)message, (Throwable)exception);
            throw exception;
        }
        message = message + " :: " + e.getMessage();
        log.error((Object)message, (Throwable)e);
        throw new AxisFault(message, (Throwable)e);
    }

    private MessageProcessor getMessageProcessorImpl(String name) {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        return (MessageProcessor)configuration.getMessageProcessors().get(name);
    }

    private OMElement createElement(String str) throws XMLStreamException {
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes());
        return new StAXOMBuilder((InputStream)in).getDocumentElement();
    }

    public String[] getDefinedEndpoints() throws AxisFault {
        String[] endpoints = null;
        try {
            SynapseConfiguration configuration = this.getSynapseConfiguration();
            Set endpointsSet = configuration.getDefinedEndpoints().keySet();
            endpoints = endpointsSet.toArray(new String[endpointsSet.size()]);
        }
        catch (Exception e) {
            log.error((Object)"Error while getting the defined endpoints");
            this.handleException(log, "Error while getting the defined endpoints", e);
        }
        return endpoints;
    }

    public boolean validateAxis2ClientRepo(String input) throws AxisFault {
        try {
            ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)input, (String)DEFAULT_AXIS2_XML);
            return true;
        }
        catch (AxisFault e) {
            this.handleException(log, "Error while validating the Axis2 Client Repository", (Exception)((Object)e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String browseMessage(String processorName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        MessageConsumer messageConsumer = this.getMessageConsumer(configuration, processorName);
        String message = null;
        try {
            message = this.getMessageAsString(messageConsumer);
        }
        catch (AxisFault e) {
            this.handleException(log, "Failed to get message from the queue :", (Exception)((Object)e));
        }
        finally {
            messageConsumer.cleanup();
        }
        return message;
    }

    private String getMessageAsString(MessageConsumer messageConsumer) throws AxisFault {
        String message = null;
        if (messageConsumer.isAlive()) {
            try {
                MessageContext messageContext = messageConsumer.receive();
                if (messageContext != null) {
                    message = messageContext.getEnvelope().toString();
                }
            }
            catch (SynapseException e) {
                this.handleException(log, "MessageConsumer failed to receive message from queue :", (Exception)((Object)e));
            }
        }
        return message;
    }

    public boolean popMessage(String processorName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        MessageConsumer messageConsumer = this.getMessageConsumer(configuration, processorName);
        try {
            boolean bl = this.popMessageFromQueue(messageConsumer);
            return bl;
        }
        catch (SynapseException e) {
            throw this.createAxisFaultException(log, "Failed to pop the message from the queue", (Exception)((Object)e));
        }
        finally {
            messageConsumer.cleanup();
        }
    }

    private boolean popMessageFromQueue(MessageConsumer messageConsumer) throws AxisFault {
        try {
            if (messageConsumer.receive() != null) {
                return messageConsumer.ack();
            }
        }
        catch (SynapseException e) {
            this.handleException(log, "MessageConsumer failed to receive or acknowledge the message :", (Exception)((Object)e));
        }
        return false;
    }

    public boolean popAndRedirectMessage(String processorName, String storeName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        MessageConsumer messageConsumer = this.getMessageConsumer(configuration, processorName);
        MessageProducer messageProducer = configuration.getMessageStore(storeName).getProducer();
        try {
            boolean bl = this.popAndRedirectMessageToStore(messageProducer, messageConsumer);
            return bl;
        }
        catch (AxisFault e) {
            throw this.createAxisFaultException(log, "Failed to redirect message to " + storeName, (Exception)((Object)e));
        }
        finally {
            messageConsumer.cleanup();
        }
    }

    private boolean popAndRedirectMessageToStore(MessageProducer messageProducer, MessageConsumer messageConsumer) throws AxisFault {
        try {
            MessageContext messageContext = messageConsumer.receive();
            if (messageContext != null) {
                messageProducer.storeMessage(messageContext);
                return messageConsumer.ack();
            }
        }
        catch (SynapseException e) {
            this.handleException(log, "Failed to redirect message. ", (Exception)((Object)e));
        }
        return false;
    }

    private MessageConsumer getMessageConsumer(SynapseConfiguration configuration, String processorName) {
        MessageProcessor processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName);
        String messageStoreName = processor.getMessageStoreName();
        return configuration.getMessageStore(messageStoreName).getConsumer();
    }

    private AxisFault createAxisFaultException(Log log, String message, Exception e) throws AxisFault {
        message = message + "::" + e.getMessage();
        log.error((Object)message, (Throwable)e);
        return new AxisFault(message, (Throwable)e);
    }

    static {
        log = LogFactory.getLog(MessageProcessorAdminService.class);
        CONF_LOCATION = "conf.location";
        String confPath = System.getProperty(CONF_LOCATION);
        if (confPath == null) {
            confPath = Paths.get("repository", "conf").toString();
        }
        DEFAULT_AXIS2_XML = Paths.get(confPath, "axis2", "axis2_blocking_client.xml").toString();
    }
}

