/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.ui;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.captcha.mgt.beans.xsd.CaptchaInfoBean;
import org.wso2.carbon.identity.mgt.stub.UserInformationRecoveryServiceStub;
import org.wso2.carbon.identity.mgt.stub.beans.VerificationBean;
import org.wso2.carbon.identity.mgt.stub.dto.ChallengeQuestionDTO;

public class UserInformationRecoveryClient {
    protected static final Log log = LogFactory.getLog(UserInformationRecoveryClient.class);
    protected UserInformationRecoveryServiceStub stub;

    public UserInformationRecoveryClient(String url, ConfigurationContext configContext) throws AxisFault {
        try {
            this.stub = new UserInformationRecoveryServiceStub(configContext, url + "UserInformationRecoveryService");
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public UserInformationRecoveryClient(String cookie, String url, ConfigurationContext configContext) throws AxisFault {
        try {
            this.stub = new UserInformationRecoveryServiceStub(configContext, url + "UserInformationRecoveryService");
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public CaptchaInfoBean generateRandomCaptcha() throws AxisFault {
        try {
            return this.stub.getCaptcha();
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public VerificationBean verifyUser(String username, CaptchaInfoBean captcha) throws AxisFault {
        try {
            return this.stub.verifyUser(username, captcha);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    private String[] handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    public ChallengeQuestionDTO[] getChallengeQuestions() throws AxisFault {
        try {
            return this.stub.getAllChallengeQuestions();
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new ChallengeQuestionDTO[0];
        }
    }
}

