/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.ui;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.captcha.mgt.beans.xsd.CaptchaInfoBean;
import org.wso2.carbon.identity.mgt.stub.UserIdentityManagementServiceStub;
import org.wso2.carbon.identity.mgt.stub.beans.VerificationBean;
import org.wso2.carbon.identity.mgt.stub.dto.UserChallengesDTO;

public class IdentityManagementClient {
    public static final String USER_CHALLENGE_QUESTION = "user.challenge.question";
    protected static final Log log = LogFactory.getLog(IdentityManagementClient.class);
    protected UserIdentityManagementServiceStub stub = null;

    public IdentityManagementClient(String url, ConfigurationContext configContext) throws Exception {
        try {
            this.stub = new UserIdentityManagementServiceStub(configContext, url + "UserIdentityManagementService");
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public IdentityManagementClient(String cookie, String url, ConfigurationContext configContext) throws Exception {
        try {
            this.stub = new UserIdentityManagementServiceStub(configContext, url + "UserIdentityManagementService");
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public boolean processPasswordRecoveryLink(String userId, String userKey) throws AxisFault {
        try {
            return this.stub.processPasswordRecovery(userId, userKey, "EMAIL");
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return false;
        }
    }

    public UserChallengesDTO[] getChallengeQuestionsOfUser(String userId, String userKey) throws AxisFault {
        try {
            return this.stub.getChallengeQuestionsForUser(userId, userKey);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new UserChallengesDTO[0];
        }
    }

    public VerificationBean verifyChallengeQuestion(String userId, String userKey, String question, String answer) throws AxisFault {
        try {
            UserChallengesDTO dto = new UserChallengesDTO();
            dto.setQuestion(question);
            dto.setAnswer(answer);
            return this.stub.verifyChallengeQuestion(userId, userKey, new UserChallengesDTO[]{dto});
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public VerificationBean confirmLink(String confirmationKey) throws AxisFault {
        try {
            return this.stub.confirmUserAccount(confirmationKey);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public boolean updateCredential(String userId, String userKey, String password, CaptchaInfoBean captchaInfoBean) throws AxisFault {
        try {
            VerificationBean bean = this.stub.updateCredential(userId, userKey, password, captchaInfoBean);
            return bean.getVerified();
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return false;
        }
    }

    public boolean unlockUserAccount(String userId, String userKey) {
        return false;
    }

    public boolean processAccountRecovery() throws AxisFault {
        return false;
    }

    private String[] handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

