/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.ui;

import java.util.HashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.mgt.stub.AccountCredentialMgtConfigServiceStub;
import org.wso2.carbon.identity.mgt.stub.dto.EmailTemplateDTO;
import org.wso2.carbon.identity.mgt.ui.EmailConfigDTO;

public class AccountCredentialMgtConfigClient {
    protected static final Log log = LogFactory.getLog(AccountCredentialMgtConfigClient.class);
    protected AccountCredentialMgtConfigServiceStub stub;

    public AccountCredentialMgtConfigClient(String url, ConfigurationContext configContext) throws AxisFault {
        try {
            this.stub = new AccountCredentialMgtConfigServiceStub(configContext, url + "AccountCredentialMgtConfigService");
        }
        catch (AxisFault e) {
            this.handleException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public AccountCredentialMgtConfigClient(String cookie, String url, ConfigurationContext configContext) throws AxisFault {
        try {
            this.stub = new AccountCredentialMgtConfigServiceStub(configContext, url + "AccountCredentialMgtConfigService");
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault e) {
            this.handleException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private String[] handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    public void saveEmailConfig(EmailConfigDTO emailConfig) throws AxisFault {
        try {
            EmailTemplateDTO[] emailTemplates = emailConfig.getTemplates();
            this.stub.saveEmailConfig(emailTemplates);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public EmailConfigDTO loadEmailConfig() throws AxisFault {
        EmailTemplateDTO[] emailTemplates = null;
        EmailConfigDTO emailConfig = new EmailConfigDTO();
        try {
            emailTemplates = this.stub.getEmailConfig();
            HashMap<String, String> emailTypes = new HashMap<String, String>();
            for (int i = 0; i < emailTemplates.length; ++i) {
                emailTypes.put(emailTemplates[i].getName(), emailTemplates[i].getDisplayName());
            }
            emailConfig.setEmailTypes(emailTypes);
            emailConfig.setTemplates(emailTemplates);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
        return emailConfig;
    }
}

