/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authz.valve.internal;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.authz.service.AuthorizationManager;
import org.wso2.carbon.identity.authz.valve.internal.AuthorizationValveServiceHolder;
import org.wso2.carbon.identity.core.handler.HandlerComparator;

@Component(name="org.wso2.carbon.identity.authz.valve", immediate=true)
public class AuthorizationValveServiceComponent {
    private static final Log log = LogFactory.getLog(AuthorizationValveServiceComponent.class);

    @Activate
    protected void activate(ComponentContext cxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"AuthorizationValveServiceComponent is activated");
        }
    }

    @Reference(name="org.wso2.carbon.identity.authz.service.manager.consume", service=AuthorizationManager.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unsetAuthorizationManager")
    protected void setAuthorizationManager(AuthorizationManager authorizationManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"AuthorizationManager acquired");
        }
        List<AuthorizationManager> authorizationManagerList = AuthorizationValveServiceHolder.getInstance().getAuthorizationManagerList();
        authorizationManagerList.add(authorizationManager);
        Collections.sort(authorizationManagerList, new HandlerComparator());
    }

    protected void unsetAuthorizationManager(AuthorizationManager authorizationManager) {
        List<AuthorizationManager> authorizationManagerList = AuthorizationValveServiceHolder.getInstance().getAuthorizationManagerList();
        authorizationManagerList.remove(authorizationManager);
    }
}

