/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authz.valve;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.auth.service.AuthenticationContext;
import org.wso2.carbon.identity.auth.service.handler.HandlerManager;
import org.wso2.carbon.identity.auth.service.module.ResourceConfig;
import org.wso2.carbon.identity.authz.service.AuthorizationContext;
import org.wso2.carbon.identity.authz.service.AuthorizationManager;
import org.wso2.carbon.identity.authz.service.AuthorizationResult;
import org.wso2.carbon.identity.authz.service.AuthorizationStatus;
import org.wso2.carbon.identity.authz.service.exception.AuthzServiceServerException;
import org.wso2.carbon.identity.authz.valve.internal.AuthorizationValveServiceHolder;
import org.wso2.carbon.identity.authz.valve.util.Utils;

public class AuthorizationValve
extends ValveBase {
    private static final String AUTH_HEADER_NAME = "WWW-Authenticate";
    private static final String AUTH_CONTEXT = "auth-context";
    private static final Log log = LogFactory.getLog(AuthorizationValve.class);

    public void invoke(Request request, Response response) throws IOException, ServletException {
        block10: {
            AuthenticationContext authenticationContext = (AuthenticationContext)request.getAttribute(AUTH_CONTEXT);
            if (authenticationContext != null && authenticationContext.getUser() != null && StringUtils.isNotEmpty((String)authenticationContext.getUser().getUserName())) {
                ResourceConfig resourceConfig = authenticationContext.getResourceConfig();
                String contextPath = request.getContextPath();
                String httpMethod = request.getMethod();
                AuthorizationContext authorizationContext = new AuthorizationContext();
                if (resourceConfig != null) {
                    authorizationContext.setIsCrossTenantAllowed(resourceConfig.isCrossTenantAllowed());
                }
                if (!this.isRequestValidForTenant(authenticationContext, authorizationContext, request)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Authorization to " + request.getRequestURI() + " is denied because the authenticated user belongs to different tenant domain: " + authenticationContext.getUser().getTenantDomain() + " and cross-domain access is disabled."));
                    }
                    this.handleErrorResponse(authenticationContext, response, 401);
                    return;
                }
                if (resourceConfig != null && StringUtils.isNotEmpty((String)resourceConfig.getPermissions())) {
                    authorizationContext.setPermissionString(resourceConfig.getPermissions());
                }
                if (resourceConfig != null && CollectionUtils.isNotEmpty((Collection)resourceConfig.getScopes())) {
                    authorizationContext.setRequiredScopes(resourceConfig.getScopes());
                }
                authorizationContext.setContext(contextPath);
                authorizationContext.setHttpMethods(httpMethod);
                authorizationContext.setUser(authenticationContext.getUser());
                authorizationContext.addParameter((Object)"oauth2-allowed-scopes", authenticationContext.getParameter((Object)"oauth2-allowed-scopes"));
                authorizationContext.addParameter((Object)"oauth2-validate-scopes", authenticationContext.getParameter((Object)"oauth2-validate-scopes"));
                String tenantDomainFromURLMapping = Utils.getTenantDomainFromURLMapping(request);
                authorizationContext.setTenantDomainFromURLMapping(tenantDomainFromURLMapping);
                List<AuthorizationManager> authorizationManagerList = AuthorizationValveServiceHolder.getInstance().getAuthorizationManagerList();
                AuthorizationManager authorizationManager = (AuthorizationManager)HandlerManager.getInstance().getFirstPriorityHandler(authorizationManagerList, true);
                try {
                    AuthorizationResult authorizationResult = authorizationManager.authorize(authorizationContext);
                    if (authorizationResult.getAuthorizationStatus().equals((Object)AuthorizationStatus.GRANT)) {
                        this.getNext().invoke(request, response);
                        break block10;
                    }
                    this.handleErrorResponse(authenticationContext, response, 403);
                }
                catch (AuthzServiceServerException e) {
                    this.handleErrorResponse(authenticationContext, response, 400);
                }
            } else {
                this.getNext().invoke(request, response);
            }
        }
    }

    private void handleErrorResponse(AuthenticationContext authenticationContext, Response response, int error) throws IOException {
        StringBuilder value = new StringBuilder(16);
        value.append("realm user=\"");
        if (authenticationContext.getUser() != null) {
            value.append(authenticationContext.getUser().getUserName());
        }
        value.append('\"');
        response.setHeader(AUTH_HEADER_NAME, value.toString());
        response.sendError(error);
    }

    private boolean isRequestValidForTenant(AuthenticationContext authenticationContext, AuthorizationContext authorizationContext, Request request) {
        return Utils.isUserBelongsToRequestedTenant(authenticationContext, request) || authorizationContext.isCrossTenantAllowed();
    }
}

