/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.config.mapper.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Set;
import org.wso2.config.mapper.ConfigParserException;

public class FileUtils {
    private FileUtils() {
    }

    public static String readFile(File file) throws ConfigParserException {
        if (file.exists() && file.isFile()) {
            StringBuilder stringBuilder = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                String s;
                while ((s = br.readLine()) != null) {
                    stringBuilder.append(s).append("\n");
                }
            }
            catch (IOException e) {
                throw new ConfigParserException("Error reading file " + file.getName(), e);
            }
            return stringBuilder.toString();
        }
        throw new ConfigParserException(file.getName() + " does not exist or is not a file");
    }

    private static void writeFile(File file, String input) throws ConfigParserException {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new ConfigParserException("Error while creating new directory " + file.getAbsolutePath());
        }
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            bufferedWriter.write(input);
            bufferedWriter.flush();
        }
        catch (IOException e) {
            throw new ConfigParserException("Error while writing file into " + file.getAbsolutePath(), e);
        }
    }

    private static void writeDirectory(File configurations, File backupFile) throws ConfigParserException {
        backupFile = Paths.get(backupFile.getParent(), configurations.getName()).toFile();
        if (configurations.isDirectory()) {
            boolean status = backupFile.mkdirs();
            if (!status) {
                throw new ConfigParserException("Error while creating directory " + configurations.getName());
            }
            File[] files = configurations.listFiles();
            if (files != null) {
                for (File file : files) {
                    FileUtils.writeDirectory(file, backupFile);
                }
            }
        } else {
            String configuration = FileUtils.readFile(configurations);
            FileUtils.writeFile(backupFile, configuration);
        }
    }

    public static void deleteDirectory(File file) throws ConfigParserException {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    boolean status;
                    if (files.length > 0) {
                        for (File file1 : files) {
                            FileUtils.deleteDirectory(file1);
                        }
                    }
                    if (!(status = file.delete())) {
                        throw new ConfigParserException("Error while deleting " + file.getName());
                    }
                }
            } else {
                boolean status = file.delete();
                if (!status) {
                    throw new ConfigParserException("Error while deleting " + file.getName());
                }
            }
        }
    }

    public static void writeDirectory(String configurations, String backupPath, Set<String> fileSet) throws ConfigParserException {
        for (String file : fileSet) {
            File configFile = Paths.get(configurations, file).toFile();
            File backupFile = Paths.get(backupPath, file).toFile();
            if (!configFile.exists()) continue;
            FileUtils.writeDirectory(configFile, backupFile);
        }
    }
}

