/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.config.mapper;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.consensys.cava.toml.Toml;
import net.consensys.cava.toml.TomlArray;
import net.consensys.cava.toml.TomlParseResult;
import net.consensys.cava.toml.TomlTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.config.mapper.ConfigParser;
import org.wso2.config.mapper.ConfigParserException;
import org.wso2.config.mapper.model.Context;

class TomlParser {
    private static final Log log = LogFactory.getLog(TomlParser.class);

    private TomlParser() {
    }

    private static Map<String, Object> parseToml(TomlParseResult result) {
        LinkedHashMap<String, Object> templateContext = new LinkedHashMap<String, Object>();
        Set dottedKeySet = result.dottedKeySet();
        for (String dottedKey : dottedKeySet) {
            dottedKey = dottedKey.replaceAll("\"", "'");
            templateContext.put(dottedKey, TomlParser.getValue(result.get(dottedKey)));
        }
        return templateContext;
    }

    private static Object getValue(Object value) {
        Object returnValue = value instanceof TomlArray ? TomlParser.processTomlArray((TomlArray)value) : (value instanceof TomlTable ? TomlParser.processTomlMap((TomlTable)value) : value);
        return returnValue;
    }

    private static Map<String, Object> processTomlMap(TomlTable tomlTable) {
        LinkedHashMap<String, Object> finalMap = new LinkedHashMap<String, Object>();
        Set dottedKeySet = tomlTable.dottedKeySet();
        for (String key : dottedKeySet) {
            Object value = tomlTable.get(key = key.replaceAll("\"", "'"));
            if (value instanceof TomlArray) {
                finalMap.put(key, TomlParser.processTomlArray((TomlArray)value));
                continue;
            }
            finalMap.put(key, tomlTable.get(key));
        }
        return finalMap;
    }

    private static List<Object> processTomlArray(TomlArray value) {
        ArrayList<Object> finalList = new ArrayList<Object>();
        List tomlList = value.toList();
        for (Object obj : tomlList) {
            if (obj instanceof TomlArray) {
                finalList.add(TomlParser.processTomlArray((TomlArray)obj));
                continue;
            }
            if (obj instanceof TomlTable) {
                finalList.add(TomlParser.processTomlMap((TomlTable)obj));
                continue;
            }
            finalList.add(obj);
        }
        return finalList;
    }

    private static Map<String, String> processSecrets(TomlParseResult result) {
        LinkedHashMap<String, String> context = new LinkedHashMap<String, String>();
        TomlTable table = result.getTable("secrets");
        TomlTable runtimeSecretsConfig = result.getTable("runtime_secrets");
        if (table != null) {
            table.dottedKeySet().forEach(key -> context.put((String)key, table.getString(key)));
        }
        if (runtimeSecretsConfig != null) {
            runtimeSecretsConfig.dottedKeySet().forEach(key -> context.put((String)key, runtimeSecretsConfig.getString(key)));
        }
        return context;
    }

    static Context parse(Context context) throws ConfigParserException {
        try {
            TomlParseResult parseResult = Toml.parse((Path)Paths.get(ConfigParser.ConfigPaths.getConfigFilePath(), new String[0]));
            if (parseResult.hasErrors()) {
                parseResult.errors().forEach(error -> log.error((Object)error.toString()));
                throw new ConfigParserException("Error parsing deployment configuration");
            }
            context.getTemplateData().putAll(TomlParser.parseToml(parseResult));
            context.getSecrets().putAll(TomlParser.processSecrets(parseResult));
        }
        catch (IOException e) {
            throw new ConfigParserException("Error parsing file " + ConfigParser.ConfigPaths.getConfigFilePath(), e);
        }
        return context;
    }
}

