/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.config.mapper;

import com.google.gson.Gson;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.wso2.config.mapper.ConfigParserException;
import org.wso2.config.mapper.model.Context;

class DefaultParser {
    private DefaultParser() {
    }

    static Context addDefaultValues(Context enrichedContext, String defaultValueFilePath) throws ConfigParserException {
        try {
            Map defaultValueMap = DefaultParser.readConfiguration(defaultValueFilePath);
            for (Map.Entry entry : defaultValueMap.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (!enrichedContext.getTemplateData().containsKey(key)) {
                    enrichedContext.getTemplateData().put(key, value);
                    continue;
                }
                Object retrievedEnrichedContext = enrichedContext.getTemplateData().get(key);
                enrichedContext.getTemplateData().put(key, retrievedEnrichedContext);
            }
        }
        catch (IOException e) {
            throw new ConfigParserException("Error while default values with file" + defaultValueFilePath, e);
        }
        return enrichedContext;
    }

    private static Map readConfiguration(String defaultValueFilePath) throws IOException {
        Gson gson = new Gson();
        try (FileInputStream fileInputStream = new FileInputStream(defaultValueFilePath);){
            InputStreamReader input = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
            Map map = (Map)gson.fromJson((Reader)input, Map.class);
            return map;
        }
    }
}

