/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.TracerProvider;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.eventhubs.EventHubConsumerAsyncClient;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.messaging.eventhubs.EventHubProperties;
import com.azure.messaging.eventhubs.PartitionProperties;
import com.azure.messaging.eventhubs.implementation.EventHubConnectionProcessor;
import com.azure.messaging.eventhubs.implementation.EventHubManagementNode;
import java.io.Closeable;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

class EventHubAsyncClient
implements Closeable {
    private final ClientLogger logger = new ClientLogger(EventHubAsyncClient.class);
    private final MessageSerializer messageSerializer;
    private final EventHubConnectionProcessor connectionProcessor;
    private final Scheduler scheduler;
    private final boolean isSharedConnection;
    private final Runnable onClientClose;
    private final TracerProvider tracerProvider;

    EventHubAsyncClient(EventHubConnectionProcessor connectionProcessor, TracerProvider tracerProvider, MessageSerializer messageSerializer, Scheduler scheduler, boolean isSharedConnection, Runnable onClientClose) {
        this.tracerProvider = Objects.requireNonNull(tracerProvider, "'tracerProvider' cannot be null.");
        this.messageSerializer = Objects.requireNonNull(messageSerializer, "'messageSerializer' cannot be null.");
        this.connectionProcessor = Objects.requireNonNull(connectionProcessor, "'connectionProcessor' cannot be null.");
        this.scheduler = Objects.requireNonNull(scheduler, "'scheduler' cannot be null");
        this.onClientClose = Objects.requireNonNull(onClientClose, "'onClientClose' cannot be null.");
        this.isSharedConnection = isSharedConnection;
    }

    String getFullyQualifiedNamespace() {
        return this.connectionProcessor.getFullyQualifiedNamespace();
    }

    String getEventHubName() {
        return this.connectionProcessor.getEventHubName();
    }

    Mono<EventHubProperties> getProperties() {
        return this.connectionProcessor.flatMap(connection -> connection.getManagementNode()).flatMap(EventHubManagementNode::getEventHubProperties);
    }

    Flux<String> getPartitionIds() {
        return this.getProperties().flatMapMany(properties -> Flux.fromIterable(properties.getPartitionIds()));
    }

    Mono<PartitionProperties> getPartitionProperties(String partitionId) {
        return this.connectionProcessor.flatMap(connection -> connection.getManagementNode()).flatMap(node -> node.getPartitionProperties(partitionId));
    }

    EventHubProducerAsyncClient createProducer() {
        return new EventHubProducerAsyncClient(this.connectionProcessor.getFullyQualifiedNamespace(), this.getEventHubName(), this.connectionProcessor, this.connectionProcessor.getRetryOptions(), this.tracerProvider, this.messageSerializer, this.scheduler, this.isSharedConnection, this.onClientClose);
    }

    EventHubConsumerAsyncClient createConsumer(String consumerGroup, int prefetchCount) {
        Objects.requireNonNull(consumerGroup, "'consumerGroup' cannot be null.");
        if (consumerGroup.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'consumerGroup' cannot be an empty string."));
        }
        return new EventHubConsumerAsyncClient(this.connectionProcessor.getFullyQualifiedNamespace(), this.getEventHubName(), this.connectionProcessor, this.messageSerializer, consumerGroup, prefetchCount, this.scheduler, this.isSharedConnection, this.onClientClose);
    }

    @Override
    public void close() {
        this.connectionProcessor.dispose();
    }
}

