/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.SOAPMessageFormatter;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.TargetRequest;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.transport.passthru.config.TargetConfiguration;
import org.apache.synapse.transport.passthru.util.PassThroughTransportUtils;
import org.apache.synapse.transport.passthru.util.RelayUtils;

public class TargetRequestFactory {
    private static Log log = LogFactory.getLog(TargetRequestFactory.class);

    public static TargetRequest create(MessageContext msgContext, HttpRoute route, TargetConfiguration configuration) throws AxisFault {
        try {
            String excessProp;
            Map excessHeaders;
            String fullUrl;
            String noKeepAlive;
            String forceHttp10;
            String cType;
            Map headersMap;
            Object headers;
            String httpMethod = (String)msgContext.getProperty("HTTP_METHOD");
            if (httpMethod == null) {
                httpMethod = "POST";
            }
            Boolean noEntityBody = (Boolean)msgContext.getProperty("NO_ENTITY_BODY");
            if (msgContext.getEnvelope().getBody().getFirstElement() != null) {
                noEntityBody = false;
            }
            EndpointReference epr = PassThroughTransportUtils.getDestinationEPR(msgContext);
            URL url = new URL(epr.getAddress());
            TargetRequest request = new TargetRequest(configuration, route, url, httpMethod, noEntityBody == null || noEntityBody == false);
            if (msgContext.getProperty("REQUEST_HOST_HEADER") != null && (headers = msgContext.getProperty("TRANSPORT_HEADERS")) != null && !(headersMap = (Map)headers).containsKey("Host")) {
                headersMap.put("Host", msgContext.getProperty("REQUEST_HOST_HEADER"));
            }
            PassThroughTransportUtils.removeUnwantedHeaders(msgContext, configuration);
            Object o = msgContext.getProperty("TRANSPORT_HEADERS");
            if (o != null && o instanceof Map) {
                Map headers2 = (Map)o;
                for (Map.Entry entryObj : headers2.entrySet()) {
                    Map.Entry entry = entryObj;
                    if (entry.getValue() == null || !(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                    if ("Host".equalsIgnoreCase((String)entry.getKey()) && !configuration.isPreserveHttpHeader("Host")) {
                        if (msgContext.getProperty("REQUEST_HOST_HEADER") == null) continue;
                        request.addHeader((String)entry.getKey(), (String)msgContext.getProperty("REQUEST_HOST_HEADER"));
                        continue;
                    }
                    request.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if ((cType = TargetRequestFactory.getContentType(msgContext, configuration.isPreserveHttpHeader("Content-Type"))) != null && !httpMethod.equals("GET") && RelayUtils.shouldOverwriteContentType(msgContext, request)) {
                String messageType = (String)msgContext.getProperty("messageType");
                if (messageType != null) {
                    boolean builderInvoked = false;
                    Pipe pipe = (Pipe)msgContext.getProperty("pass-through.pipe");
                    if (pipe != null) {
                        builderInvoked = Boolean.TRUE.equals(msgContext.getProperty("message.builder.invoked"));
                    }
                    if (messageType.indexOf("multipart/related") == -1 && messageType.indexOf("multipart/form-data") == -1) {
                        Map msgCtxheaders = (Map)o;
                        if (msgCtxheaders != null && !cType.isEmpty()) {
                            msgCtxheaders.put("Content-Type", cType);
                        }
                        request.addHeader("Content-Type", cType);
                    }
                    if (builderInvoked && (messageType.indexOf("multipart/related") != -1 || messageType.indexOf("multipart/form-data") != -1)) {
                        request.addHeader("Content-Type", cType);
                    }
                } else {
                    request.addHeader("Content-Type", cType);
                }
            }
            if ("true".equals(forceHttp10 = (String)msgContext.getProperty("FORCE_HTTP_1.0"))) {
                request.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
            }
            if ("true".equals(noKeepAlive = (String)msgContext.getProperty("NO_KEEPALIVE")) || PassThroughConfiguration.getInstance().isKeepAliveDisabled()) {
                request.setKeepAlive(false);
            }
            int port = url.getPort();
            request.setPort(port);
            String disableChunking = (String)msgContext.getProperty("DISABLE_CHUNKING");
            if ("true".equals(disableChunking)) {
                request.setChunk(false);
            }
            if ("true".equals(fullUrl = (String)msgContext.getProperty("FULL_URI"))) {
                request.setFullUrl(true);
            }
            if ((excessHeaders = (Map)msgContext.getProperty(excessProp = "EXCESS_TRANSPORT_HEADERS")) != null) {
                for (String key : excessHeaders.keySet()) {
                    for (String excessVal : (Collection)excessHeaders.get(key)) {
                        request.addHeader(key, excessVal);
                    }
                }
            }
            return request;
        }
        catch (MalformedURLException e) {
            TargetRequestFactory.handleException("Invalid to address" + msgContext.getTo().getAddress(), e);
            return null;
        }
    }

    private static String getContentType(MessageContext msgCtx, boolean isContentTypePreservedHeader) throws AxisFault {
        Object trpHeaders = msgCtx.getProperty("TRANSPORT_HEADERS");
        String setEncoding = (String)msgCtx.getProperty("setCharacterEncoding");
        if (trpHeaders != null && trpHeaders instanceof Map && ((Map)trpHeaders).get("Content-Type") != null && (isContentTypePreservedHeader || "false".equals(setEncoding)) && !TargetRequestFactory.isMultipartContent(((Map)trpHeaders).get("Content-Type").toString())) {
            if (msgCtx.getProperty("ContentType") != null) {
                return (String)msgCtx.getProperty("ContentType");
            }
            if (msgCtx.getProperty("messageType") != null) {
                return (String)msgCtx.getProperty("messageType");
            }
        }
        MessageFormatter formatter = MessageProcessorSelector.getMessageFormatter((MessageContext)msgCtx);
        OMOutputFormat format = PassThroughTransportUtils.getOMOutputFormat(msgCtx);
        if (formatter != null) {
            String contentType = formatter.getContentType(msgCtx, format, msgCtx.getSoapAction());
            return contentType;
        }
        String contentType = (String)msgCtx.getProperty("ContentType");
        if (contentType != null) {
            return contentType;
        }
        return new SOAPMessageFormatter().getContentType(msgCtx, format, msgCtx.getSoapAction());
    }

    private static void handleException(String s, Exception e) throws AxisFault {
        log.error((Object)s, (Throwable)e);
        throw new AxisFault(s, (Throwable)e);
    }

    public static boolean isMultipartContent(String contentType) {
        return contentType.contains("multipart/form-data") || contentType.contains("multipart/related");
    }
}

