/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.util.MiscellaneousUtil;
import org.apache.synapse.commons.util.PropertyHelper;
import org.apache.synapse.transport.passthru.StreamInterceptor;

public class StreamInterceptorsLoader {
    private static Log log = LogFactory.getLog(StreamInterceptorsLoader.class);
    private static final QName ROOT_Q = new QName("interceptors");
    private static final QName INTERCEPTOR_Q = new QName("interceptor");
    private static final QName CLASS_Q = new QName("class");
    private static final QName NAME_ATT = new QName("name");
    private static final QName PARAM_Q = new QName("parameter");
    private static final QName VALUE_ATT = new QName("value");
    private static List<StreamInterceptor> interceptors = new ArrayList<StreamInterceptor>();
    private static boolean isLoadedAlready = false;
    private static Lock lock = new ReentrantLock();

    StreamInterceptorsLoader() {
    }

    public static List<StreamInterceptor> getInterceptors() {
        if (!isLoadedAlready) {
            try {
                lock.lock();
                if (!isLoadedAlready) {
                    StreamInterceptorsLoader.loadInterceptors();
                    isLoadedAlready = true;
                }
            }
            finally {
                lock.unlock();
            }
        }
        return Collections.unmodifiableList(interceptors);
    }

    private static void loadInterceptors() {
        OMElement interceptorsConfig = MiscellaneousUtil.loadXMLConfig((String)"stream-interceptors.xml", (boolean)false);
        if (interceptorsConfig != null) {
            if (!ROOT_Q.equals(interceptorsConfig.getQName())) {
                StreamInterceptorsLoader.handleException("Invalid interceptor configuration file");
            }
            Iterator iterator = interceptorsConfig.getChildrenWithName(INTERCEPTOR_Q);
            while (iterator.hasNext()) {
                OMElement interceptorElem = (OMElement)iterator.next();
                if (interceptorElem.getAttribute(CLASS_Q) != null) {
                    String className = interceptorElem.getAttributeValue(CLASS_Q);
                    if (!"".equals(className)) {
                        StreamInterceptor interceptor = StreamInterceptorsLoader.createInterceptor(className);
                        interceptors.add(interceptor);
                        StreamInterceptorsLoader.populateParameters(interceptorElem, interceptor);
                        continue;
                    }
                    StreamInterceptorsLoader.handleException("Class name is one or more interceptor");
                    continue;
                }
                StreamInterceptorsLoader.handleException("Class name is one or more interceptor");
            }
        }
    }

    private static StreamInterceptor createInterceptor(String classFQName) {
        Object obj = null;
        try {
            obj = Class.forName(classFQName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            StreamInterceptorsLoader.handleException("Error creating Interceptor for class name : " + classFQName, e);
        }
        if (obj instanceof StreamInterceptor) {
            return obj;
        }
        StreamInterceptorsLoader.handleException("Error creating StreamInterceptor. The Interceptor should be of type org.apache.synapse.transport.passthru.StreamInterceptor");
        return null;
    }

    private static void populateParameters(OMElement handlerElem, StreamInterceptor interceptor) {
        Iterator it = handlerElem.getChildrenWithName(PARAM_Q);
        while (it.hasNext()) {
            OMElement child = (OMElement)it.next();
            String propName = child.getAttribute(NAME_ATT).getAttributeValue();
            if (propName == null) {
                StreamInterceptorsLoader.handleException("StreamInterceptor parameter must contain the name attribute");
                continue;
            }
            if (child.getAttribute(VALUE_ATT) != null) {
                String value = child.getAttribute(VALUE_ATT).getAttributeValue();
                interceptor.addProperty(propName, value);
                PropertyHelper.setInstanceProperty((String)propName, (Object)value, (Object)interceptor);
                continue;
            }
            OMElement omElt = child.getFirstElement();
            if (omElt != null) {
                interceptor.addProperty(propName, omElt);
                PropertyHelper.setInstanceProperty((String)propName, (Object)omElt, (Object)interceptor);
                continue;
            }
            StreamInterceptorsLoader.handleException("StreamInterceptor parameter must contain name and value attributes, or a name and a child XML fragment");
        }
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new RuntimeException(msg);
    }

    private static void handleException(String msg, Exception ex) {
        log.error((Object)msg, (Throwable)ex);
        throw new RuntimeException(msg, ex);
    }
}

