/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.nhttp.util.MessageFormatterDecoratorFactory;
import org.apache.synapse.transport.nhttp.util.NhttpUtil;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.SourceRequest;
import org.apache.synapse.transport.passthru.SourceResponse;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.apache.synapse.transport.passthru.util.PassThroughTransportUtils;

public class SourceResponseFactory {
    private static Log log = LogFactory.getLog(SourceResponseFactory.class);

    public static SourceResponse create(MessageContext msgContext, SourceRequest sourceRequest, SourceConfiguration sourceConfiguration) {
        String requestMethod;
        String noKeepAlive;
        int statusCode = PassThroughTransportUtils.determineHttpStatusCode(msgContext);
        String statusLine = PassThroughTransportUtils.determineHttpStatusLine(msgContext);
        SourceResponse sourceResponse = msgContext.getProperty("ORIGINAL_STATUS_CODE") != null && statusCode == (Integer)msgContext.getProperty("ORIGINAL_STATUS_CODE") ? new SourceResponse(sourceConfiguration, statusCode, statusLine, sourceRequest) : (msgContext.getProperty("HTTP_REASON_PHRASE") != null && statusLine.equals(msgContext.getProperty("HTTP_REASON_PHRASE")) ? new SourceResponse(sourceConfiguration, statusCode, sourceRequest) : new SourceResponse(sourceConfiguration, statusCode, statusLine, sourceRequest));
        HashMap<String, Object> transportHeaders = (HashMap<String, Object>)msgContext.getProperty("TRANSPORT_HEADERS");
        boolean forceContentLength = msgContext.isPropertyTrue("FORCE_HTTP_CONTENT_LENGTH");
        boolean forceContentLengthCopy = msgContext.isPropertyTrue("COPY_CONTENT_LENGTH_FROM_INCOMING");
        if (forceContentLength && forceContentLengthCopy && msgContext.getProperty("ORGINAL_CONTEN_LENGTH") != null && !sourceConfiguration.isPreserveHttpHeader("Content-Length")) {
            sourceResponse.addHeader("Content-Length", (String)msgContext.getProperty("ORGINAL_CONTEN_LENGTH"));
        }
        if (sourceRequest != null && "HEAD".equalsIgnoreCase(sourceRequest.getRequest().getRequestLine().getMethod()) && msgContext.getProperty("ORGINAL_CONTEN_LENGTH") != null && !sourceConfiguration.isPreserveHttpHeader("ORGINAL_CONTEN_LENGTH")) {
            sourceResponse.addHeader("ORGINAL_CONTEN_LENGTH", (String)msgContext.getProperty("ORGINAL_CONTEN_LENGTH"));
        }
        if (transportHeaders != null && msgContext.getProperty("messageType") != null) {
            if (msgContext.getProperty("ContentType") != null && msgContext.getProperty("ContentType").toString().contains("multipart/related") && !sourceConfiguration.isPreserveHttpHeader("messageType")) {
                transportHeaders.put("messageType", "multipart/related");
            } else {
                Pipe pipe = (Pipe)msgContext.getProperty("pass-through.pipe");
                if (pipe != null && !Boolean.TRUE.equals(msgContext.getProperty("message.builder.invoked")) && !sourceConfiguration.isPreserveHttpHeader("Content-Type")) {
                    transportHeaders.put("Content-Type", msgContext.getProperty("ContentType"));
                }
            }
        }
        if (transportHeaders != null) {
            SourceResponseFactory.addResponseHeader(sourceResponse, transportHeaders);
        } else {
            Boolean noEntityBody = (Boolean)msgContext.getProperty("NO_ENTITY_BODY");
            if (noEntityBody == null || Boolean.FALSE == noEntityBody) {
                OMOutputFormat format = NhttpUtil.getOMOutputFormat(msgContext);
                transportHeaders = new HashMap<String, Object>();
                MessageFormatter messageFormatter = MessageFormatterDecoratorFactory.createMessageFormatterDecorator(msgContext);
                if (msgContext.getProperty("messageType") == null && !sourceConfiguration.isPreserveHttpHeader("Content-Type")) {
                    transportHeaders.put("Content-Type", messageFormatter.getContentType(msgContext, format, msgContext.getSoapAction()));
                }
                SourceResponseFactory.addResponseHeader(sourceResponse, transportHeaders);
            }
        }
        String excessProp = "EXCESS_TRANSPORT_HEADERS";
        Map excessHeaders = (Map)msgContext.getProperty(excessProp);
        if (excessHeaders != null) {
            for (String key : excessHeaders.keySet()) {
                for (String excessVal : (Collection)excessHeaders.get(key)) {
                    sourceResponse.addHeader(key, excessVal);
                }
            }
        }
        if ("true".equals(noKeepAlive = (String)msgContext.getProperty("NO_KEEPALIVE")) || PassThroughConfiguration.getInstance().isKeepAliveDisabled()) {
            sourceResponse.setKeepAlive(false);
        } else if (sourceRequest != null && (requestMethod = sourceRequest.getRequest().getRequestLine().getMethod()) != null && SourceResponseFactory.isPayloadOptionalMethod(requestMethod.toUpperCase()) && (sourceRequest.getHeaders().containsKey("Content-Length") || sourceRequest.getHeaders().containsKey("Transfer-Encoding"))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Disable keep-alive in the client connection : Content-length/Transfer-encoding headers present for GET/HEAD/DELETE request");
            }
            sourceResponse.setKeepAlive(false);
        }
        return sourceResponse;
    }

    private static void addResponseHeader(SourceResponse sourceResponse, Map transportHeaders) {
        for (Map.Entry entryObj : transportHeaders.entrySet()) {
            Map.Entry entry = entryObj;
            if (entry.getValue() == null || !(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            sourceResponse.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static boolean isPayloadOptionalMethod(String httpMethod) {
        return "GET".equals(httpMethod) || "HEAD".equals(httpMethod) || "DELETE".equals(httpMethod);
    }
}

