/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.transport.http.HTTPConstants;

public class SessionContextUtil {
    public static SessionContext createSessionContext(MessageContext messageContext) {
        HttpServletRequest request = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (request == null) {
            return null;
        }
        SessionContext sessionContext = null;
        HttpSession httpSession = request.getSession(true);
        if (httpSession != null) {
            sessionContext = (SessionContext)httpSession.getAttribute("SessionContext");
            if (sessionContext == null) {
                String cookieValueString = httpSession.getId();
                sessionContext = new SessionContext(null);
                sessionContext.setParent((AbstractContext)messageContext.getConfigurationContext());
                sessionContext.setCookieID(cookieValueString);
                httpSession.setAttribute("SessionContext", (Object)sessionContext);
                messageContext.setSessionContext(sessionContext);
                messageContext.setProperty("SessionId", (Object)cookieValueString);
            } else if (sessionContext.getParent() != messageContext.getConfigurationContext()) {
                httpSession.removeAttribute("SessionContext");
                sessionContext = new SessionContext(null);
                sessionContext.setParent((AbstractContext)messageContext.getConfigurationContext());
                String cookieValueString = httpSession.getId();
                sessionContext.setCookieID(cookieValueString);
                messageContext.setProperty("SessionId", (Object)cookieValueString);
                httpSession.setAttribute("SessionContext", (Object)sessionContext);
            }
        }
        return sessionContext;
    }
}

