/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.util;

import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.ServerWorker;
import org.apache.synapse.transport.passthru.TargetRequest;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.transport.passthru.util.DeferredMessageBuilder;

public class RelayUtils {
    private static final Log log = LogFactory.getLog(RelayUtils.class);
    private static final DeferredMessageBuilder messageBuilder = new DeferredMessageBuilder();
    private static volatile Handler addressingInHandler = null;
    private static boolean noAddressingHandler = false;
    private static Boolean forcePTBuild = null;
    private static boolean forceXmlValidation = false;
    private static boolean forceJSONValidation = false;

    public static void buildMessage(MessageContext msgCtx) throws IOException, XMLStreamException {
        RelayUtils.buildMessage(msgCtx, false);
    }

    public static void buildMessage(MessageContext messageContext, boolean earlyBuild) throws IOException, XMLStreamException {
        Pipe pipe = (Pipe)messageContext.getProperty("pass-through.pipe");
        if (messageContext.getProperty("ContentType") != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Content Type is " + messageContext.getProperty("ContentType")));
            }
            if (pipe != null && !Boolean.TRUE.equals(messageContext.getProperty("message.builder.invoked")) && forcePTBuild.booleanValue()) {
                InputStream in = pipe.getInputStream();
                Object http_sc = messageContext.getProperty("HTTP_SC");
                if (http_sc != null && http_sc instanceof Integer && http_sc.equals(202) && in != null) {
                    ReadOnlyBIS bis = new ReadOnlyBIS(in);
                    int c = ((InputStream)bis).read();
                    if (c == -1) {
                        messageContext.setProperty("message.builder.invoked", (Object)Boolean.TRUE);
                        messageContext.setProperty("NO_ENTITY_BODY", (Object)Boolean.TRUE);
                        return;
                    }
                    ((InputStream)bis).reset();
                    in = bis;
                }
                RelayUtils.buildMessage(messageContext, earlyBuild, in);
                return;
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Content Type is null and the message is not build");
            }
            messageContext.setProperty("message.builder.invoked", (Object)Boolean.TRUE);
            return;
        }
    }

    public static void buildMessage(MessageContext messageContext, boolean earlyBuild, InputStream in) throws IOException, AxisFault {
        block14: {
            BufferedInputStream bufferedInputStream;
            ByteArrayOutputStream byteArrayOutputStream = null;
            if (forceXmlValidation || forceJSONValidation) {
                byteArrayOutputStream = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)in, (OutputStream)byteArrayOutputStream);
                byteArrayOutputStream.flush();
                in = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
            if ((bufferedInputStream = (BufferedInputStream)messageContext.getProperty("bufferedInputStream")) != null) {
                try {
                    bufferedInputStream.reset();
                    bufferedInputStream.mark(0);
                }
                catch (Exception exception) {}
            } else {
                bufferedInputStream = new BufferedInputStream(in);
                bufferedInputStream.mark(131072);
                messageContext.setProperty("bufferedInputStream", (Object)bufferedInputStream);
            }
            OMElement element = null;
            try {
                element = messageBuilder.getDocument(messageContext, bufferedInputStream != null ? bufferedInputStream : in);
                if (element == null) break block14;
                messageContext.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)element));
                messageContext.setProperty("__RELAY_FORMATTERS_MAP", messageBuilder.getFormatters());
                messageContext.setProperty("message.builder.invoked", (Object)Boolean.TRUE);
                boolean bl = earlyBuild = messageContext.getProperty("relay_early_build") != null ? (Boolean)messageContext.getProperty("relay_early_build") : earlyBuild;
                if (!earlyBuild) {
                    RelayUtils.processAddressing(messageContext);
                }
                if (!forceXmlValidation && !forceJSONValidation) break block14;
                String rawData = null;
                try {
                    String contentType = (String)messageContext.getProperty("ContentType");
                    if ("application/json".equals(RelayUtils.getMIMEContentType(contentType)) && forceJSONValidation) {
                        rawData = byteArrayOutputStream.toString();
                        JsonParser jsonParser = new JsonParser();
                        jsonParser.parse(rawData);
                    } else {
                        messageContext.getEnvelope().buildWithAttachments();
                        if (messageContext.getEnvelope().getBody().getFirstElement() != null) {
                            messageContext.getEnvelope().getBody().getFirstElement().buildNext();
                        }
                    }
                }
                catch (Exception e) {
                    if (rawData == null) {
                        rawData = byteArrayOutputStream.toString();
                    }
                    log.error((Object)("Error while building the message.\n" + rawData));
                    messageContext.setProperty("RAW_PAYLOAD", (Object)rawData);
                    throw e;
                }
            }
            catch (Exception e) {
                RelayUtils.discardRequestMessage(messageContext);
                messageContext.setProperty("message.builder.invoked", (Object)Boolean.TRUE);
                RelayUtils.handleException("Error while building Passthrough stream", e);
            }
        }
    }

    public static String getMIMEContentType(String contentType) {
        int commaIndex;
        int index = contentType.indexOf(59);
        String type = index > 0 ? contentType.substring(0, index) : ((commaIndex = contentType.indexOf(44)) > 0 ? contentType.substring(0, commaIndex) : contentType);
        return type;
    }

    public static boolean isDeleteRequestWithoutPayload(MessageContext msgContext) {
        if ("DELETE".equals(msgContext.getProperty("HTTP_METHOD"))) {
            return Boolean.TRUE.equals(msgContext.getProperty("message.builder.invoked")) && Boolean.TRUE.equals(msgContext.getProperty("NO_ENTITY_BODY"));
        }
        return false;
    }

    public static boolean shouldOverwriteContentType(MessageContext msgContext, TargetRequest request) {
        boolean builderInvoked = Boolean.TRUE.equals(msgContext.getProperty("message.builder.invoked"));
        boolean noEntityBodySet = Boolean.TRUE.equals(msgContext.getProperty("NO_ENTITY_BODY"));
        Map<String, LinkedHashSet<String>> headers = request.getHeaders();
        boolean contentTypeInRequest = false;
        if (headers.size() != 0 && (headers.get("Content-Type") != null || headers.get("content-type") != null)) {
            contentTypeInRequest = true;
        }
        boolean isDefaultContentTypeEnabled = false;
        ConfigurationContext configurationContex = msgContext.getConfigurationContext();
        if (configurationContex != null && configurationContex.getAxisConfiguration().getParameter("DEFAULT_REQUEST_CONTENT_TYPE") != null) {
            isDefaultContentTypeEnabled = true;
        }
        return builderInvoked && !noEntityBodySet || contentTypeInRequest || isDefaultContentTypeEnabled;
    }

    public static boolean isEmptyPayloadStream(InputStream inputStream) throws IOException {
        boolean isEmptyPayload = true;
        if (inputStream != null) {
            ReadOnlyBIS readOnlyStream = new ReadOnlyBIS(inputStream);
            int c = readOnlyStream.read();
            while (c != -1) {
                if (c != 32) {
                    isEmptyPayload = false;
                    break;
                }
                c = readOnlyStream.read();
            }
            readOnlyStream.reset();
            inputStream.reset();
        }
        return isEmptyPayload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processAddressing(MessageContext messageContext) throws AxisFault {
        Boolean disableAck;
        Object requestResponseTransport;
        if (noAddressingHandler) {
            return;
        }
        if (addressingInHandler == null) {
            DeferredMessageBuilder deferredMessageBuilder = messageBuilder;
            synchronized (deferredMessageBuilder) {
                if (addressingInHandler == null) {
                    AxisConfiguration axisConfig = messageContext.getConfigurationContext().getAxisConfiguration();
                    List phases = axisConfig.getInFlowPhases();
                    boolean handlerFound = false;
                    block3: for (Phase phase : phases) {
                        if (!"Addressing".equals(phase.getName())) continue;
                        List handlers = phase.getHandlers();
                        for (Handler handler : handlers) {
                            if (!"AddressingInHandler".equals(handler.getName())) continue;
                            addressingInHandler = handler;
                            handlerFound = true;
                            break block3;
                        }
                    }
                    if (!handlerFound) {
                        noAddressingHandler = true;
                        return;
                    }
                }
            }
        }
        if (messageContext.getProperty("disableAddressingForInMessages") == null) {
            messageContext.setProperty("disableAddressingForInMessages", (Object)"false");
        }
        Object disableAddressingForOutGoing = null;
        if (messageContext.getProperty("disableAddressingForOutMessages") != null) {
            disableAddressingForOutGoing = messageContext.getProperty("disableAddressingForOutMessages");
        }
        addressingInHandler.invoke(messageContext);
        if (disableAddressingForOutGoing != null) {
            messageContext.setProperty("disableAddressingForOutMessages", disableAddressingForOutGoing);
        }
        if (messageContext.getAxisOperation() == null) {
            return;
        }
        String mepString = messageContext.getAxisOperation().getMessageExchangePattern();
        if (RelayUtils.isOneWay(mepString)) {
            Boolean disableAck2;
            requestResponseTransport = messageContext.getProperty("RequestResponseTransportControl");
            if (!(requestResponseTransport == null || (disableAck2 = RelayUtils.getDisableAck(messageContext)) != null && disableAck2.booleanValue())) {
                ((RequestResponseTransport)requestResponseTransport).acknowledgeMessage(messageContext);
            }
        } else if (AddressingHelper.isReplyRedirected((MessageContext)messageContext) && AddressingHelper.isFaultRedirected((MessageContext)messageContext) && (mepString.equals("http://www.w3.org/ns/wsdl/in-out") || mepString.equals("http://www.w3.org/ns/wsdl/in-out") || mepString.equals("http://www.w3.org/ns/wsdl/in-out")) && (requestResponseTransport = messageContext.getProperty("RequestResponseTransportControl")) != null && ((disableAck = RelayUtils.getDisableAck(messageContext)) == null || !disableAck.booleanValue())) {
            ((RequestResponseTransport)requestResponseTransport).acknowledgeMessage(messageContext);
        }
    }

    private static Boolean getDisableAck(MessageContext msgContext) throws AxisFault {
        Boolean disableAck = (Boolean)msgContext.getProperty("DisableResponseAck");
        if (disableAck == null) {
            disableAck = (Boolean)(msgContext.getAxisService() != null ? msgContext.getAxisService().getParameterValue("DisableResponseAck") : null);
        }
        return disableAck;
    }

    private static boolean isOneWay(String mepString) {
        return mepString.equals("http://www.w3.org/ns/wsdl/in-only") || mepString.equals("http://www.w3.org/ns/wsdl/in-only") || mepString.equals("http://www.w3.org/ns/wsdl/in-only");
    }

    private static void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    private static void consume(Pipe pipe) throws AxisFault {
        InputStream in = pipe.getInputStream();
        if (in != null) {
            try {
                if (pipe.isConsumeRequired()) {
                    IOUtils.copy((InputStream)in, (OutputStream)new NullOutputStream());
                }
            }
            catch (IOException exception) {
                RelayUtils.handleException("Error when consuming the input stream to discard", exception);
            }
        }
    }

    @Deprecated
    public static void consumeAndDiscardMessage(MessageContext msgContext) throws AxisFault {
        RelayUtils.discardRequestMessage(msgContext);
    }

    public static void discardMessage(MessageContext msgContext) throws AxisFault {
        Pipe pipe = (Pipe)msgContext.getProperty("pass-through.pipe");
        if (pipe != null && pipe.hasHttpProducer()) {
            try {
                while (!pipe.isProducerCompleted() || pipe.isConsumeRequired()) {
                    RelayUtils.consume(pipe);
                    if (!pipe.isProducerError() && !pipe.isDiscardable()) continue;
                    break;
                }
            }
            catch (IOException exception) {
                RelayUtils.handleException("Error when consuming the input stream to discard", exception);
            }
        }
    }

    public static void discardRequestMessage(MessageContext msgContext) throws AxisFault {
        MessageContext requestContext = msgContext;
        Object outTransportInfo = msgContext.getProperty("OutTransportInfo");
        if (outTransportInfo instanceof ServerWorker) {
            requestContext = ((ServerWorker)outTransportInfo).getRequestContext();
        }
        RelayUtils.discardMessage(requestContext);
    }

    static {
        if (forcePTBuild == null && (forcePTBuild = PassThroughConfiguration.getInstance().getBooleanProperty("force.passthrough.builder")) == null) {
            forcePTBuild = true;
        }
        forceXmlValidation = PassThroughConfiguration.getInstance().isForcedXmlMessageValidationEnabled();
        forceJSONValidation = PassThroughConfiguration.getInstance().isForcedJSONMessageValidationEnabled();
    }

    private static class ReadOnlyBIS
    extends BufferedInputStream {
        private static final String LOG_STREAM = "org.apache.synapse.transport.passthru.util.ReadOnlyStream";
        private static final Log logger = LogFactory.getLog((String)"org.apache.synapse.transport.passthru.util.ReadOnlyStream");

        public ReadOnlyBIS(InputStream inputStream) {
            super(inputStream);
            super.mark(Integer.MAX_VALUE);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"<init>");
            }
        }

        @Override
        public void close() throws IOException {
            super.reset();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"#close");
            }
        }

        @Override
        public void mark(int readlimit) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"#mark");
            }
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public long skip(long n) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"#skip");
            }
            return 0L;
        }
    }
}

