/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.util;

import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.util.RelayUtils;

public class RelaySecuirtyMessageBuilderDispatchandler
extends AbstractDispatcher {
    private static final Log log = LogFactory.getLog(RelaySecuirtyMessageBuilderDispatchandler.class);
    private static final String APPLICATION_XML = "application/xml";
    private static final String WSSE = "wsse";
    private static final String WSS_WSSECURITY_SECEXT_1_0_XSD = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final String PROXY = "proxy";
    private static final String SERVICE_TYPE = "serviceType";
    public static final String NAME = "RelaySecuirtyMessageBuilderDispatchandler";

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        Handler.InvocationResponse invocationResponse = super.invoke(messageContext);
        EndpointReference toEPR = messageContext.getTo();
        Pipe pipe = (Pipe)messageContext.getProperty("pass-through.pipe");
        if (pipe != null) {
            if (toEPR != null) {
                ConfigurationContext configurationContext = messageContext.getConfigurationContext();
                AxisConfiguration registry = configurationContext.getAxisConfiguration();
                String filePart = toEPR.getAddress();
                if (filePart != null) {
                    String serviceOpPart = Utils.getServiceAndOperationPart((String)filePart, (String)messageContext.getConfigurationContext().getServiceContextPath());
                    AxisService axisService = null;
                    if (messageContext.getConfigurationContext().getServiceContextPath() != null && serviceOpPart != null && (axisService = registry.getService(serviceOpPart)) != null) {
                        Parameter parameter = axisService.getParameter(SERVICE_TYPE);
                        if (parameter != null) {
                            if (!parameter.getValue().equals(PROXY)) {
                                this.build(messageContext);
                            }
                        } else {
                            this.build(messageContext);
                        }
                    }
                }
            }
            if (messageContext.isEngaged("rampart")) {
                SOAPHeader header = null;
                if (messageContext.getEnvelope().getHeader() != null) {
                    header = messageContext.getEnvelope().getHeader();
                }
                this.build(messageContext);
                this.handlePOXRequests(messageContext, header);
            }
        }
        return invocationResponse;
    }

    private void handlePOXRequests(MessageContext messageContext, SOAPHeader header) {
        int j;
        String contentType;
        String _contentType = contentType = (String)messageContext.getProperty("ContentType");
        if (contentType != null && (j = contentType.indexOf(";")) > 0) {
            _contentType = contentType.substring(0, j);
        }
        boolean isSOAPWithBasicAuth = false;
        Object o = messageContext.getProperty("TRANSPORT_HEADERS");
        if (o != null && o instanceof Map) {
            Map httpHeaders = (Map)o;
            for (Object httpHeader : httpHeaders.keySet()) {
                Object value = httpHeaders.get(httpHeader);
                if (!(httpHeader instanceof String) || value == null || !(value instanceof String) || !"Authorization".equalsIgnoreCase((String)httpHeader) || !((String)value).startsWith("Basic")) continue;
                isSOAPWithBasicAuth = true;
                break;
            }
        }
        if (_contentType != null && _contentType.equals(APPLICATION_XML) && header != null && header.getChildElements() != null && messageContext.isDoingREST() && isSOAPWithBasicAuth) {
            try {
                OMElement poxSecurityHeader = AXIOMUtil.stringToOM((String)header.toString()).getFirstElement();
                if (poxSecurityHeader != null) {
                    OMNamespace omNamespace = OMAbstractFactory.getOMFactory().createOMNamespace(WSS_WSSECURITY_SECEXT_1_0_XSD, WSSE);
                    Iterator headerIterator = messageContext.getEnvelope().getHeader().examineAllHeaderBlocks();
                    boolean existingWSSecurityHeaderFound = false;
                    while (headerIterator.hasNext()) {
                        OMElement headerElement = (OMElement)headerIterator.next();
                        if (!headerElement.getQName().equals(new QName(WSS_WSSECURITY_SECEXT_1_0_XSD, "Security"))) continue;
                        while (poxSecurityHeader.getChildElements().hasNext()) {
                            headerElement.addChild((OMNode)poxSecurityHeader.getChildElements().next());
                        }
                        existingWSSecurityHeaderFound = true;
                        break;
                    }
                    if (!existingWSSecurityHeaderFound) {
                        SOAPHeaderBlock soapBloackingHeader = OMAbstractFactory.getSOAP12Factory().createSOAPHeaderBlock("Security", omNamespace);
                        while (poxSecurityHeader.getChildElements().hasNext()) {
                            soapBloackingHeader.addChild((OMNode)poxSecurityHeader.getChildElements().next());
                        }
                        messageContext.getEnvelope().getHeader().addChild((OMNode)soapBloackingHeader);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Error while executing the message at relaySecurity handler", (Throwable)e);
            }
        }
    }

    private void build(MessageContext messageContext) {
        try {
            RelayUtils.buildMessage(messageContext, false);
            if (messageContext.getEnvelope().getHeader() == null) {
                SOAPFactory fac = messageContext.isSOAP11() ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
                fac.createSOAPHeader(messageContext.getEnvelope());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while executing the message at relaySecurity handler", (Throwable)e);
        }
    }

    public AxisOperation findOperation(AxisService arg0, MessageContext arg1) throws AxisFault {
        return null;
    }

    public AxisService findService(MessageContext arg0) throws AxisFault {
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }
}

