/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.passthru.config.TargetConfiguration;

public class PassThroughTransportUtils {
    private static Log log = LogFactory.getLog(PassThroughTransportUtils.class);

    public static String getHostName(InetAddress address) {
        String hostAddress = address.getHostAddress();
        String inetAddr = address.toString();
        int index1 = inetAddr.lastIndexOf(47);
        int index2 = inetAddr.indexOf(hostAddress);
        String result = index2 == index1 + 1 ? (index1 == 0 ? hostAddress : inetAddr.substring(0, index1)) : hostAddress;
        return result;
    }

    public static EndpointReference getDestinationEPR(MessageContext msgContext) {
        String transportURL = (String)msgContext.getProperty("TransportURL");
        if (transportURL != null) {
            return new EndpointReference(transportURL);
        }
        if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
            return msgContext.getTo();
        }
        return null;
    }

    public static void removeUnwantedHeaders(MessageContext msgContext, TargetConfiguration targetConfiguration) {
        Map transportHeaders = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        Map excessHeaders = (Map)msgContext.getProperty("EXCESS_TRANSPORT_HEADERS");
        if (transportHeaders != null && !transportHeaders.isEmpty()) {
            if (transportHeaders.get("Content-Length") != null) {
                msgContext.setProperty("ORGINAL_CONTEN_LENGTH", transportHeaders.get("Content-Length"));
            }
            PassThroughTransportUtils.removeUnwantedHeadersFromHeaderMap(transportHeaders, targetConfiguration);
        }
        if (excessHeaders != null && !excessHeaders.isEmpty()) {
            PassThroughTransportUtils.removeUnwantedHeadersFromHeaderMap(excessHeaders, targetConfiguration);
        }
    }

    private static void removeUnwantedHeadersFromHeaderMap(Map headers, TargetConfiguration targetConfiguration) {
        Iterator iter = headers.keySet().iterator();
        while (iter.hasNext()) {
            String headerName = (String)iter.next();
            if ("Transfer-Encoding".equalsIgnoreCase(headerName)) {
                iter.remove();
            }
            if ("Connection".equalsIgnoreCase(headerName) && !targetConfiguration.isPreserveHttpHeader("Connection")) {
                iter.remove();
            }
            if ("Keep-Alive".equalsIgnoreCase(headerName) && !targetConfiguration.isPreserveHttpHeader("Keep-Alive")) {
                iter.remove();
            }
            if ("Content-Length".equalsIgnoreCase(headerName) && !targetConfiguration.isPreserveHttpHeader("Content-Length")) {
                iter.remove();
            }
            if ("Date".equalsIgnoreCase(headerName) && !targetConfiguration.isPreserveHttpHeader("Date")) {
                iter.remove();
            }
            if ("Server".equalsIgnoreCase(headerName) && !targetConfiguration.isPreserveHttpHeader("Server")) {
                iter.remove();
            }
            if (!"User-Agent".equalsIgnoreCase(headerName) || targetConfiguration.isPreserveHttpHeader("User-Agent")) continue;
            iter.remove();
        }
    }

    public static int determineHttpStatusCode(MessageContext msgContext) {
        int httpStatus = 200;
        if (msgContext.isPropertyTrue("SC_ACCEPTED")) {
            httpStatus = 202;
        } else {
            Object statusCode;
            boolean handleFault = msgContext.getEnvelope() != null ? msgContext.getEnvelope().getBody().hasFault() || msgContext.isProcessingFault() : false;
            boolean faultsAsHttp200 = false;
            if (msgContext.getProperty("FAULTS_AS_HTTP_200") != null) {
                faultsAsHttp200 = "TRUE".equals(msgContext.getProperty("FAULTS_AS_HTTP_200").toString().toUpperCase());
            }
            if (handleFault && !faultsAsHttp200) {
                httpStatus = 500;
            }
            if ((statusCode = msgContext.getProperty("HTTP_SC")) != null) {
                try {
                    httpStatus = Integer.parseInt(msgContext.getProperty("HTTP_SC").toString());
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Unable to set the HTTP status code from the property HTTP_SC with value: " + statusCode));
                }
            }
        }
        return httpStatus;
    }

    public static String determineHttpStatusLine(MessageContext msgContext) {
        Object statusLine = msgContext.getProperty("HTTP_SC_DESC");
        if (statusLine != null) {
            return (String)statusLine;
        }
        return null;
    }

    public static String getIpAddress() throws SocketException {
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        String address = "127.0.0.1";
        while (e.hasMoreElements()) {
            NetworkInterface netface = e.nextElement();
            Enumeration<InetAddress> addresses = netface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress ip = addresses.nextElement();
                if (ip.isLoopbackAddress() || !PassThroughTransportUtils.isIP(ip.getHostAddress())) continue;
                return ip.getHostAddress();
            }
        }
        return address;
    }

    private static boolean isIP(String hostAddress) {
        return hostAddress.split("[.]").length == 4;
    }

    public String getServicesHTML(String prefix, ConfigurationContext cfgCtx) {
        HashMap services = cfgCtx.getAxisConfiguration().getServices();
        Hashtable erroneousServices = cfgCtx.getAxisConfiguration().getFaultyServices();
        boolean servicesFound = false;
        StringBuffer resultBuf = new StringBuffer();
        resultBuf.append("<html><head><title>Axis2: Services</title></head><body>");
        if (services != null && !services.isEmpty()) {
            servicesFound = true;
            resultBuf.append("<h2>Deployed services</h2>");
            for (Object service : services.values()) {
                AxisService axisService = (AxisService)service;
                Parameter parameter = axisService.getParameter("hiddenService");
                if (axisService.getName().startsWith("__") || parameter != null && JavaUtils.isTrueExplicitly((Object)parameter.getValue())) continue;
                Iterator iterator = axisService.getOperations();
                resultBuf.append("<h3><a href=\"").append(prefix).append(axisService.getName()).append("?wsdl\">").append(axisService.getName()).append("</a></h3>");
                if (iterator.hasNext()) {
                    resultBuf.append("Available operations <ul>");
                    while (iterator.hasNext()) {
                        AxisOperation axisOperation = (AxisOperation)iterator.next();
                        resultBuf.append("<li>").append(axisOperation.getName().getLocalPart()).append("</li>");
                    }
                    resultBuf.append("</ul>");
                    continue;
                }
                resultBuf.append("No operations specified for this service");
            }
        }
        if (erroneousServices != null && !erroneousServices.isEmpty()) {
            servicesFound = true;
            resultBuf.append("<hr><h2><font color=\"blue\">Faulty Services</font></h2>");
            Enumeration faultyservices = erroneousServices.keys();
            while (faultyservices.hasMoreElements()) {
                String faultyserviceName = (String)faultyservices.nextElement();
                resultBuf.append("<h3><font color=\"blue\">").append(faultyserviceName).append("</font></h3>");
            }
        }
        if (!servicesFound) {
            resultBuf.append("<h2>There are no services deployed</h2>");
        }
        resultBuf.append("</body></html>");
        return resultBuf.toString();
    }

    public static OMOutputFormat getOMOutputFormat(MessageContext msgContext) {
        OMOutputFormat format = null;
        format = msgContext.getProperty("MESSAGE_OUTPUT_FORMAT") != null ? (OMOutputFormat)msgContext.getProperty("MESSAGE_OUTPUT_FORMAT") : new OMOutputFormat();
        msgContext.setProperty("MESSAGE_OUTPUT_FORMAT", (Object)format);
        msgContext.setDoingMTOM(TransportUtils.doWriteMTOM((MessageContext)msgContext));
        msgContext.setDoingSwA(TransportUtils.doWriteSwA((MessageContext)msgContext));
        msgContext.setDoingREST(TransportUtils.isDoingREST((MessageContext)msgContext));
        if (msgContext.isDoingREST()) {
            msgContext.setProperty("invokedREST", (Object)true);
        }
        format.setSOAP11(msgContext.isSOAP11());
        format.setDoOptimize(msgContext.isDoingMTOM());
        format.setDoingSWA(msgContext.isDoingSwA());
        format.setCharSetEncoding(TransportUtils.getCharSetEncoding((MessageContext)msgContext));
        Object mimeBoundaryProperty = msgContext.getProperty("mimeBoundary");
        if (mimeBoundaryProperty != null) {
            format.setMimeBoundary((String)mimeBoundaryProperty);
        }
        return format;
    }
}

