/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.ApplicationXMLBuilder;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.MIMEBuilder;
import org.apache.axis2.builder.MTOMBuilder;
import org.apache.axis2.builder.SOAPBuilder;
import org.apache.axis2.builder.XFormURLEncodedBuilder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.ApplicationXMLFormatter;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.MultipartFormDataFormatter;
import org.apache.axis2.transport.http.SOAPMessageFormatter;
import org.apache.axis2.transport.http.XFormURLEncodedFormatter;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.passthru.util.RelayUtils;

public class DeferredMessageBuilder {
    private static Log log = LogFactory.getLog(DeferredMessageBuilder.class);
    private Map<String, Builder> builders = new HashMap<String, Builder>();
    private Map<String, MessageFormatter> formatters = new HashMap<String, MessageFormatter>();
    public static final String RELAY_FORMATTERS_MAP = "__RELAY_FORMATTERS_MAP";
    public static final String FORCED_RELAY_FORMATTER = "__FORCED_RELAY_FORMATTER";

    public DeferredMessageBuilder() {
        this.builders.put("multipart/related", (Builder)new MIMEBuilder());
        this.builders.put("application/soap+xml", (Builder)new SOAPBuilder());
        this.builders.put("text/xml", (Builder)new SOAPBuilder());
        this.builders.put("application/xop+xml", (Builder)new MTOMBuilder());
        this.builders.put("application/xml", (Builder)new ApplicationXMLBuilder());
        this.builders.put("application/x-www-form-urlencoded", (Builder)new XFormURLEncodedBuilder());
        this.formatters.put("application/x-www-form-urlencoded", (MessageFormatter)new XFormURLEncodedFormatter());
        this.formatters.put("multipart/form-data", (MessageFormatter)new MultipartFormDataFormatter());
        this.formatters.put("application/xml", (MessageFormatter)new ApplicationXMLFormatter());
        this.formatters.put("text/xml", (MessageFormatter)new SOAPMessageFormatter());
        this.formatters.put("application/soap+xml", (MessageFormatter)new SOAPMessageFormatter());
    }

    public Map<String, Builder> getBuilders() {
        return this.builders;
    }

    public void addBuilder(String contentType, Builder builder) {
        this.builders.put(contentType, builder);
    }

    public void addFormatter(String contentType, MessageFormatter messageFormatter) {
        this.formatters.put(contentType, messageFormatter);
    }

    public Map<String, MessageFormatter> getFormatters() {
        return this.formatters;
    }

    public OMElement getDocument(MessageContext msgCtx, InputStream in) throws XMLStreamException, IOException {
        Builder builder;
        if ("DELETE".equals(msgCtx.getProperty("HTTP_METHOD")) && RelayUtils.isEmptyPayloadStream(in)) {
            msgCtx.setProperty("NO_ENTITY_BODY", (Object)Boolean.TRUE);
            return TransportUtils.createSOAPEnvelope(null);
        }
        String contentType = (String)msgCtx.getProperty("ContentType");
        String _contentType = DeferredMessageBuilder.getContentType(contentType, msgCtx);
        in = HTTPTransportUtils.handleGZip((MessageContext)msgCtx, (InputStream)in);
        AxisConfiguration configuration = msgCtx.getConfigurationContext().getAxisConfiguration();
        Parameter useFallbackParameter = configuration.getParameter("useDefaultFallbackBuilder");
        boolean useFallbackBuilder = false;
        if (useFallbackParameter != null) {
            useFallbackBuilder = JavaUtils.isTrueExplicitly((Object)useFallbackParameter.getValue(), (boolean)useFallbackBuilder);
        }
        Map transportHeaders = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        String contentLength = null;
        String trasferEncoded = null;
        if (transportHeaders != null) {
            contentLength = (String)transportHeaders.get("Content-Length");
            trasferEncoded = (String)transportHeaders.get("Transfer-Encoding");
            if (contentType.equals("application/octet-stream") && (contentLength == null || Integer.valueOf(contentLength) == 0) && trasferEncoded == null) {
                msgCtx.setProperty("NO_ENTITY_BODY", (Object)true);
                msgCtx.setProperty("ContentType", (Object)"");
                msgCtx.setProperty("relay_early_build", (Object)true);
                return new org.apache.axiom.soap.impl.dom.soap11.SOAP11Factory().getDefaultEnvelope();
            }
        }
        OMElement element = null;
        if (contentType != null && (builder = MessageProcessorSelector.getMessageBuilder((String)_contentType, (MessageContext)msgCtx)) != null) {
            try {
                if (contentLength != null && "0".equals(contentLength) && !msgCtx.isDoingREST()) {
                    element = new SOAP11Factory().getDefaultEnvelope();
                    msgCtx.setProperty("messageType", (Object)"application/xml");
                } else {
                    element = builder.processDocument(in, contentType, msgCtx);
                }
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error building message", (Throwable)axisFault);
                throw axisFault;
            }
        }
        if (element == null) {
            if (msgCtx.isDoingREST()) {
                try {
                    element = BuilderUtil.getPOXBuilder((InputStream)in, null).getDocumentElement();
                }
                catch (XMLStreamException e) {
                    log.error((Object)"Error building message using POX Builder", (Throwable)e);
                    throw e;
                }
            }
            builder = new SOAPBuilder();
            try {
                if (contentLength != null && "0".equals(contentLength)) {
                    element = new org.apache.axiom.soap.impl.dom.soap11.SOAP11Factory().getDefaultEnvelope();
                    msgCtx.setProperty("messageType", (Object)"application/xml");
                } else {
                    element = builder.processDocument(in, contentType, msgCtx);
                }
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error building message using SOAP builder");
                throw axisFault;
            }
        }
        if (element instanceof SOAPEnvelope) {
            SOAPEnvelope env = (SOAPEnvelope)element;
            env.hasFault();
        }
        if (contentType != null && !contentType.isEmpty()) {
            msgCtx.setProperty("ContentType", (Object)contentType);
        }
        return element;
    }

    private Builder getBuilderForContentType(String contentType) {
        int index = contentType.indexOf(59);
        String type = index > 0 ? contentType.substring(0, index) : contentType;
        Builder builder = this.builders.get(type);
        if (builder == null) {
            builder = this.builders.get(type.toLowerCase());
        }
        if (builder == null) {
            Iterator<Map.Entry<String, Builder>> iterator = this.builders.entrySet().iterator();
            while (iterator.hasNext() && builder == null) {
                Map.Entry<String, Builder> entry = iterator.next();
                String key = entry.getKey();
                if (!contentType.matches(key)) continue;
                builder = entry.getValue();
            }
        }
        return builder;
    }

    public static Builder createBuilder(String className) throws AxisFault {
        try {
            Class<?> c = Class.forName(className);
            Object o = c.newInstance();
            if (o instanceof Builder) {
                return (Builder)o;
            }
        }
        catch (ClassNotFoundException e) {
            DeferredMessageBuilder.handleException("Builder class not found :" + className, e);
        }
        catch (IllegalAccessException e) {
            DeferredMessageBuilder.handleException("Cannot initiate Builder class :" + className, e);
        }
        catch (InstantiationException e) {
            DeferredMessageBuilder.handleException("Cannot initiate Builder class :" + className, e);
        }
        return null;
    }

    public static MessageFormatter createFormatter(String className) throws AxisFault {
        try {
            Class<?> c = Class.forName(className);
            Object o = c.newInstance();
            if (o instanceof MessageFormatter) {
                return (MessageFormatter)o;
            }
        }
        catch (ClassNotFoundException e) {
            DeferredMessageBuilder.handleException("MessageFormatter class not found :" + className, e);
        }
        catch (IllegalAccessException e) {
            DeferredMessageBuilder.handleException("Cannot initiate MessageFormatter class :" + className, e);
        }
        catch (InstantiationException e) {
            DeferredMessageBuilder.handleException("Cannot initiate MessageFormatter class :" + className, e);
        }
        return null;
    }

    private static void handleException(String message, Exception e) throws AxisFault {
        log.error((Object)message, (Throwable)e);
        throw new AxisFault(message, (Throwable)e);
    }

    public static String getContentType(String contentType, MessageContext msgContext) {
        int commaIndex;
        int index = contentType.indexOf(59);
        String type = index > 0 ? contentType.substring(0, index) : ((commaIndex = contentType.indexOf(44)) > 0 ? contentType.substring(0, commaIndex) : contentType);
        if (null != msgContext.getProperty("invokedREST") && msgContext.getProperty("invokedREST").equals(true) && "text/xml".equals(type)) {
            type = "application/xml";
        }
        return type;
    }
}

