/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.util;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.Handler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.wso2.caching.CacheConfiguration;

public class CacheMessageBuilderDispatchandler
extends AbstractDispatcher {
    private static final Log log = LogFactory.getLog(CacheMessageBuilderDispatchandler.class);
    public static final String NAME = "CacheMessageBuilderDispatchandler";

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        Handler.InvocationResponse invocationResponse = super.invoke(messageContext);
        EndpointReference toEPR = messageContext.getTo();
        Pipe pipe = (Pipe)messageContext.getProperty("pass-through.pipe");
        if (pipe != null && messageContext.getAxisMessage() != null) {
            CacheConfiguration cacheCfg = null;
            Parameter ccfgParam = messageContext.getAxisMessage().getParameter("cacheConfiguration");
            if (ccfgParam != null && ccfgParam.getValue() instanceof CacheConfiguration) {
                cacheCfg = (CacheConfiguration)ccfgParam.getValue();
                if (cacheCfg.getTimeout() <= 0L) {
                    return invocationResponse;
                }
                try {
                    RelayUtils.buildMessage(messageContext, false);
                }
                catch (Exception e) {
                    log.error((Object)"Error while executing the message at cache message builder handler", (Throwable)e);
                }
            }
        }
        return invocationResponse;
    }

    public AxisOperation findOperation(AxisService arg0, MessageContext arg1) throws AxisFault {
        return null;
    }

    public AxisService findService(MessageContext arg0) throws AxisFault {
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }
}

