/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.util;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.synapse.transport.passthru.jmx.PassThroughTransportMetricsCollector;

public class ActiveConnectionMonitor
implements Runnable {
    private static final Log log = LogFactory.getLog(ActiveConnectionMonitor.class);
    private PassThroughTransportMetricsCollector pttMetricsCollector;
    private DefaultListeningIOReactor ioReactor;
    private int maxActive;

    public ActiveConnectionMonitor(PassThroughTransportMetricsCollector metrics, DefaultListeningIOReactor ior, int maxActiveConnections) {
        this.ioReactor = ior;
        this.pttMetricsCollector = metrics;
        this.maxActive = maxActiveConnections;
    }

    @Override
    public void run() {
        try {
            if (this.maxActive > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Active Connection Count : " + this.pttMetricsCollector.getActiveConnectionCount()));
                }
                if (this.pttMetricsCollector.getActiveConnectionCount() > this.maxActive) {
                    log.warn((Object)"Pausing the Listening IOReactor : Too many open connections than the max_open_connections limit.");
                    this.ioReactor.pause();
                } else {
                    this.ioReactor.resume();
                }
            }
        }
        catch (IOException e) {
            log.warn((Object)"Active Connection Monitor Task - IO Error while pausing/resuming the IOReactor ");
        }
    }
}

