/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.jmx;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;

public class LatencyParameter {
    private static final int SMALL_DATA_COLLECTION_PERIOD = 5;
    private static final int LARGE_DATA_COLLECTION_PERIOD = 300;
    private static final int SAMPLES_PER_MINUTE = 12;
    private static final int SAMPLES_PER_HOUR = 12;
    private AtomicLong lastValue;
    private Queue<Long> cache;
    private Queue<Long> shortTermCache;
    private Queue<Long> longTermCache;
    private double allTimeAverage = 0.0;
    private int count = 0;
    private final Object lock = new Object();
    private final Object shortTermCacheLock = new Object();
    private final Object longTermCacheLock = new Object();
    private final boolean enabled;

    public LatencyParameter(boolean enabled) {
        this.enabled = enabled;
        if (!this.enabled) {
            return;
        }
        this.lastValue = new AtomicLong(0L);
        this.cache = new ConcurrentLinkedQueue<Long>();
        this.shortTermCache = new LinkedList<Long>();
        this.longTermCache = new LinkedList<Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (!this.enabled) {
            return;
        }
        this.lastValue.set(0L);
        this.cache.clear();
        Object object = this.shortTermCacheLock;
        synchronized (object) {
            this.shortTermCache.clear();
        }
        object = this.longTermCacheLock;
        synchronized (object) {
            this.longTermCache.clear();
        }
        object = this.lock;
        synchronized (object) {
            this.allTimeAverage = 0.0;
            this.count = 0;
        }
    }

    public long getLatency() {
        return this.enabled ? this.lastValue.get() : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAllTimeAverage() {
        Object object = this.lock;
        synchronized (object) {
            return this.enabled ? this.allTimeAverage : 0.0;
        }
    }

    public void updateCache() {
        if (!this.enabled) {
            return;
        }
        this.updateCacheQueue();
    }

    public void update(long value) {
        if (!this.enabled) {
            return;
        }
        this.lastValue.set(value);
        this.cache.offer(this.lastValue.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCacheQueue() {
        if (!this.enabled) {
            return;
        }
        int size = this.cache.size();
        if (size > 0) {
            long sum = 0L;
            for (int i = 0; i < size; ++i) {
                sum += this.cache.poll().longValue();
            }
            Object object = this.lock;
            synchronized (object) {
                this.allTimeAverage = (this.allTimeAverage * (double)this.count + (double)sum) / (double)(this.count + size);
                this.count += size;
            }
        }
        this.updateShortTermCache(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateShortTermCache(int size) {
        if (!this.enabled) {
            return;
        }
        long value = this.getLatency();
        Object object = this.shortTermCacheLock;
        synchronized (object) {
            if (this.shortTermCache.size() != 0 || value != 0L) {
                if (this.shortTermCache.size() == 180) {
                    this.shortTermCache.remove();
                }
                if (size == 0) {
                    this.shortTermCache.offer(0L);
                } else {
                    this.shortTermCache.offer(value);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLongTermCache() {
        if (!this.enabled) {
            return;
        }
        Object object = this.longTermCacheLock;
        synchronized (object) {
            if (this.longTermCache.size() != 0 || this.getLatency() != 0L) {
                if (this.longTermCache.size() == 288) {
                    this.longTermCache.remove();
                }
                this.longTermCache.offer((long)this.getAverageLatencyByMinute(5));
            }
        }
    }

    public double getAverageLatency15m() {
        return this.getAverageLatencyByMinute(15);
    }

    public double getAverageLatency5m() {
        return this.getAverageLatencyByMinute(5);
    }

    public double getAverageLatency1m() {
        return this.getAverageLatencyByMinute(1);
    }

    public double getAverageLatency24h() {
        return this.getAverageLatencyByHour(24);
    }

    public double getAverageLatency8h() {
        return this.getAverageLatencyByHour(8);
    }

    public double getAverageLatency1h() {
        return this.getAverageLatencyByHour(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getAverageLatencyByMinute(int n) {
        Long[] array;
        if (!this.enabled) {
            return 0.0;
        }
        int samples = n * 12;
        double sum = 0.0;
        Object object = this.shortTermCacheLock;
        synchronized (object) {
            array = this.shortTermCache.toArray(new Long[this.shortTermCache.size()]);
        }
        if (samples > array.length) {
            samples = array.length;
            for (int i = 0; i < array.length; ++i) {
                sum += (double)array[i].longValue();
            }
        } else {
            for (int i = 0; i < samples; ++i) {
                sum += (double)array[array.length - 1 - i].longValue();
            }
        }
        if (samples == 0) {
            return 0.0;
        }
        return sum / (double)samples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getAverageLatencyByHour(int n) {
        Long[] array;
        if (!this.enabled) {
            return 0.0;
        }
        int samples = n * 12;
        double sum = 0.0;
        Object object = this.longTermCacheLock;
        synchronized (object) {
            array = this.longTermCache.toArray(new Long[this.longTermCache.size()]);
        }
        if (samples > array.length) {
            samples = array.length;
            for (int i = 0; i < array.length; ++i) {
                sum += (double)array[i].longValue();
            }
        } else {
            for (int i = 0; i < samples; ++i) {
                sum += (double)array[array.length - 1 - i].longValue();
            }
        }
        if (samples == 0) {
            return 0.0;
        }
        return sum / (double)samples;
    }
}

