/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.core.ssl;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.TransportInDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.synapse.transport.certificatevalidation.RevocationVerificationManager;
import org.apache.synapse.transport.nhttp.config.ServerConnFactoryBuilder;

public class SSLServerConnFactoryBuilder
extends ServerConnFactoryBuilder {
    private final Log log = LogFactory.getLog(SSLServerConnFactoryBuilder.class);

    public SSLServerConnFactoryBuilder(TransportInDescription transportIn, HttpHost host) {
        super(transportIn, host);
    }

    public ServerConnFactoryBuilder parseSSL(OMElement keyStoreEl, OMElement trustStoreEl, OMElement clientAuthEl, OMElement httpsProtocolsEl, String sslProtocol, OMElement cvp, OMElement preferredCiphers) throws AxisFault {
        String cvEnable = cvp != null ? cvp.getAttribute(new QName("enable")).getAttributeValue() : null;
        RevocationVerificationManager revocationVerifier = null;
        if ("true".equalsIgnoreCase(cvEnable)) {
            Iterator iterator = cvp.getChildElements();
            String cacheDelayString = null;
            String cacheSizeString = null;
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (obj instanceof OMElement && ((OMElement)obj).getLocalName().equals("CacheSize")) {
                    cacheSizeString = ((OMElement)obj).getText();
                    continue;
                }
                if (!(obj instanceof OMElement) || !((OMElement)obj).getLocalName().equals("CacheDelay")) continue;
                cacheDelayString = ((OMElement)obj).getText();
            }
            Integer cacheSize = null;
            Integer cacheDelay = null;
            try {
                if (cacheDelayString != null && cacheSizeString != null) {
                    cacheSize = new Integer(cacheSizeString);
                    cacheDelay = new Integer(cacheDelayString);
                }
            }
            catch (NumberFormatException e) {
                this.log.error((Object)"Please specify correct Integer numbers for CacheDelay and CacheSize");
            }
            revocationVerifier = new RevocationVerificationManager(cacheSize, cacheDelay);
        }
        this.ssl = this.createSSLContext(keyStoreEl, trustStoreEl, clientAuthEl, httpsProtocolsEl, preferredCiphers, revocationVerifier, sslProtocol);
        return this;
    }
}

