/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.core.ssl;

import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.log4j.Logger;

public class SSLConfiguration {
    private Logger log = Logger.getLogger(SSLConfiguration.class);
    private String keyStore;
    private String trustStore;
    private String clientAuthEl;
    private String httpsProtocolsEl;
    private String revocationVerifier;
    private String sslProtocol;
    private String preferredCiphersEl;
    private OMElement keyStoreElement;
    private OMElement trustStoreElement;
    private OMElement clientAuthElement;
    private OMElement revocationVerifierElement;
    private OMElement httpsProtocolElement;
    private OMElement preferredCiphersElement;

    public SSLConfiguration(String keyStore, String trustStore, String clientAuthEl, String httpsProtocolsEl, String revocationVerifier, String sslProtocol, String preferredCiphersEl) {
        this.keyStore = keyStore;
        this.trustStore = trustStore;
        this.clientAuthEl = clientAuthEl;
        this.httpsProtocolsEl = httpsProtocolsEl;
        this.revocationVerifier = revocationVerifier;
        this.sslProtocol = sslProtocol;
        this.preferredCiphersEl = preferredCiphersEl;
    }

    public OMElement getKeyStoreElement() {
        if (this.keyStore != null) {
            try {
                this.keyStoreElement = AXIOMUtil.stringToOM((String)this.keyStore);
            }
            catch (XMLStreamException e) {
                this.log.error((Object)"Keystore may not be well formed XML", (Throwable)e);
            }
        }
        return this.keyStoreElement;
    }

    public OMElement getClientAuthElement() {
        if (this.clientAuthEl != null) {
            OMFactory fac = OMAbstractFactory.getOMFactory();
            this.clientAuthElement = fac.createOMElement("SSLVerifyClient", "", "");
            this.clientAuthElement.setText(this.clientAuthEl);
        }
        return this.clientAuthElement;
    }

    public OMElement getTrustStoreElement() {
        if (this.trustStore != null) {
            try {
                this.trustStoreElement = AXIOMUtil.stringToOM((String)this.trustStore);
            }
            catch (XMLStreamException e) {
                this.log.error((Object)"TrustStore may not be well formed XML", (Throwable)e);
            }
        }
        return this.trustStoreElement;
    }

    public OMElement getRevocationVerifierElement() {
        if (this.revocationVerifier != null) {
            try {
                this.revocationVerifierElement = AXIOMUtil.stringToOM((String)this.revocationVerifier);
            }
            catch (XMLStreamException e) {
                this.log.error((Object)"CertificateRevocationVerifier may not be well formed XML", (Throwable)e);
            }
        }
        return this.revocationVerifierElement;
    }

    public OMElement getHttpsProtocolElement() {
        if (this.httpsProtocolsEl != null) {
            OMFactory fac = OMAbstractFactory.getOMFactory();
            this.httpsProtocolElement = fac.createOMElement("HttpsProtocols", "", "");
            this.httpsProtocolElement.setText(this.httpsProtocolsEl);
        }
        return this.httpsProtocolElement;
    }

    public String getPreferredCiphersEl() {
        return this.preferredCiphersEl;
    }

    public OMElement getPreferredCiphersElement() {
        if (this.preferredCiphersEl != null) {
            OMFactory fac = OMAbstractFactory.getOMFactory();
            this.preferredCiphersElement = fac.createOMElement("PreferredCiphers", "", "");
            this.preferredCiphersElement.setText(this.preferredCiphersEl);
        }
        return this.preferredCiphersElement;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public String getClientAuthEl() {
        return this.clientAuthEl;
    }

    public String getHttpsProtocolsEl() {
        return this.httpsProtocolsEl;
    }

    public String getRevocationVerifier() {
        return this.revocationVerifier;
    }
}

