/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.core.ssl;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.reactor.IOSession;
import org.apache.log4j.Logger;
import org.apache.synapse.transport.http.conn.ServerConnFactory;
import org.apache.synapse.transport.passthru.core.MultiListenerServerIODispatch;

public class MultiListenerSSLServerIODispatch
extends MultiListenerServerIODispatch {
    private static final Logger log = Logger.getLogger(MultiListenerSSLServerIODispatch.class);
    private volatile Map<Integer, ServerConnFactory> endpointSSLConfigHolder;

    public MultiListenerSSLServerIODispatch(Map<Integer, NHttpServerEventHandler> handlers, NHttpServerEventHandler nHttpServerEventHandler, Map<Integer, ServerConnFactory> endpointSSLConfigHolder) {
        super(handlers, nHttpServerEventHandler, null);
        this.endpointSSLConfigHolder = endpointSSLConfigHolder;
    }

    @Override
    public void update(ServerConnFactory connFactory) {
        super.update(connFactory);
    }

    @Override
    protected DefaultNHttpServerConnection createConnection(IOSession session) {
        SocketAddress socketAddress = session.getLocalAddress();
        int port = ((InetSocketAddress)socketAddress).getPort();
        ServerConnFactory serverConnFactory = this.endpointSSLConfigHolder.get(port);
        if (serverConnFactory != null) {
            return serverConnFactory.createConnection(session);
        }
        log.error((Object)("Cannot find Configured Server Connection Factory for port " + port));
        return null;
    }
}

