/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.core;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.ListenerEndpoint;
import org.apache.http.nio.reactor.ListeningIOReactor;
import org.apache.log4j.Logger;
import org.apache.synapse.transport.http.conn.ServerConnFactory;
import org.apache.synapse.transport.passthru.ServerIODispatch;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.apache.synapse.transport.passthru.core.IOReactorSharingMode;
import org.apache.synapse.transport.passthru.core.MultiListenerServerIODispatch;
import org.apache.synapse.transport.passthru.core.PassThroughSharedListenerConfiguration;
import org.apache.synapse.transport.passthru.core.ssl.MultiListenerSSLServerIODispatch;
import org.apache.synapse.transport.passthru.core.ssl.SSLConfiguration;
import org.apache.synapse.transport.passthru.core.ssl.SSLConnectionUtils;

public class PassThroughListeningIOReactorManager {
    private static final Logger log = Logger.getLogger(PassThroughListeningIOReactorManager.class);
    private static PassThroughListeningIOReactorManager passThroughListeningIOReactorManager = new PassThroughListeningIOReactorManager();
    private ListeningIOReactor sharedListeningIOReactor;
    private ListeningIOReactor sharedSSLListeningIOReactor;
    private PassThroughSharedListenerConfiguration passThroughListenerConfiguration;
    private PassThroughSharedListenerConfiguration sslPassThroughListenerConfiguration;
    private Map<Integer, NHttpServerEventHandler> portServerHandlerMapper = new ConcurrentHashMap<Integer, NHttpServerEventHandler>();
    private Map<Integer, ListenerEndpoint> dynamicPTTListeningEndpointMapper = new ConcurrentHashMap<Integer, ListenerEndpoint>();
    private Map<Integer, ListeningIOReactor> passThroughListenerIOReactorMapper = new ConcurrentHashMap<Integer, ListeningIOReactor>();
    private Map<Integer, ServerIODispatch> passThroughListenerServerIODispatchMapper = new ConcurrentHashMap<Integer, ServerIODispatch>();
    private Map<Integer, ServerConnFactory> serverConnectionFactoryMapper = new ConcurrentHashMap<Integer, ServerConnFactory>();
    private AtomicBoolean isSharedIOReactorInitiated = new AtomicBoolean(false);
    private IOReactorSharingMode ioReactorSharingMode;
    private AtomicBoolean isSharedSSLIOReactorInitiated = new AtomicBoolean(false);
    private static final int DEFAULT_PORT_CLOSE_VERIFY_TIMEOUT = 10;

    private PassThroughListeningIOReactorManager() {
        this.ioReactorSharingMode = PassThroughConfiguration.getInstance().isListeningIOReactorShared() ? IOReactorSharingMode.SHARED : IOReactorSharingMode.UNSHARED;
    }

    public static PassThroughListeningIOReactorManager getInstance() {
        return passThroughListeningIOReactorManager;
    }

    public boolean startPTTEndpoint(InetSocketAddress inetSocketAddress, DefaultListeningIOReactor defaultListeningIOReactor, String namePrefix) {
        try {
            return this.startEndpoint(inetSocketAddress, (ListeningIOReactor)defaultListeningIOReactor, namePrefix) != null;
        }
        catch (Exception e) {
            log.error((Object)("Cannot Start PassThroughListeningEndpoint for port " + inetSocketAddress.getPort()), (Throwable)e);
            return false;
        }
    }

    public boolean startDynamicPTTEndpoint(InetSocketAddress inetSocketAddress, NHttpServerEventHandler nHttpServerEventHandler, String endpointName) {
        try {
            ListenerEndpoint endpoint = this.startEndpoint(inetSocketAddress, this.getSharedIOReactor(nHttpServerEventHandler, endpointName), endpointName);
            if (endpoint != null) {
                this.portServerHandlerMapper.put(inetSocketAddress.getPort(), nHttpServerEventHandler);
                this.dynamicPTTListeningEndpointMapper.put(inetSocketAddress.getPort(), endpoint);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error((Object)("Cannot Start Endpoint for " + endpointName), (Throwable)e);
            return false;
        }
    }

    public boolean startDynamicPTTSSLEndpoint(InetSocketAddress inetSocketAddress, NHttpServerEventHandler nHttpServerEventHandler, String endpointName, SSLConfiguration sslConfiguration) {
        try {
            ListenerEndpoint endpoint = this.startEndpoint(inetSocketAddress, this.getSharedSSLIOReactor(nHttpServerEventHandler, endpointName, inetSocketAddress.getPort(), sslConfiguration), endpointName);
            if (endpoint != null) {
                this.portServerHandlerMapper.put(inetSocketAddress.getPort(), nHttpServerEventHandler);
                this.dynamicPTTListeningEndpointMapper.put(inetSocketAddress.getPort(), endpoint);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error((Object)("Cannot Start Endpoint for " + endpointName), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListeningIOReactor initIOReactor(int port, NHttpServerEventHandler nHttpServerEventHandler, PassThroughSharedListenerConfiguration passThroughSharedListenerConfiguration) throws IOReactorException {
        ListeningIOReactor defaultListeningIOReactor;
        try {
            ServerIODispatch serverIODispatch;
            PassThroughListeningIOReactorManager passThroughListeningIOReactorManager = this;
            synchronized (passThroughListeningIOReactorManager) {
                if (this.passThroughListenerConfiguration == null && !passThroughSharedListenerConfiguration.getSourceConfiguration().getScheme().isSSL()) {
                    this.passThroughListenerConfiguration = passThroughSharedListenerConfiguration;
                }
                if (this.sslPassThroughListenerConfiguration == null && passThroughSharedListenerConfiguration.getSourceConfiguration().getScheme().isSSL()) {
                    this.sslPassThroughListenerConfiguration = passThroughSharedListenerConfiguration;
                }
            }
            if (this.ioReactorSharingMode == IOReactorSharingMode.SHARED && !this.isSharedIOReactorInitiated.get() && !passThroughSharedListenerConfiguration.getSourceConfiguration().getScheme().isSSL()) {
                passThroughListeningIOReactorManager = this;
                synchronized (passThroughListeningIOReactorManager) {
                    this.portServerHandlerMapper.put(port, nHttpServerEventHandler);
                    serverIODispatch = new MultiListenerServerIODispatch(this.portServerHandlerMapper, nHttpServerEventHandler, passThroughSharedListenerConfiguration.getServerConnFactory());
                    defaultListeningIOReactor = this.createListeningIOReactor(passThroughSharedListenerConfiguration);
                    log.info((Object)("IO Reactor for port " + port + " initiated on shared mode which will be used by non axis2 Transport Listeners "));
                    this.sharedListeningIOReactor = defaultListeningIOReactor;
                    this.isSharedIOReactorInitiated.compareAndSet(false, true);
                }
            } else if (this.ioReactorSharingMode == IOReactorSharingMode.SHARED && !this.isSharedSSLIOReactorInitiated.get() && passThroughSharedListenerConfiguration.getSourceConfiguration().getScheme().isSSL()) {
                passThroughListeningIOReactorManager = this;
                synchronized (passThroughListeningIOReactorManager) {
                    this.serverConnectionFactoryMapper.put(port, passThroughSharedListenerConfiguration.getServerConnFactory());
                    this.portServerHandlerMapper.put(port, nHttpServerEventHandler);
                    serverIODispatch = new MultiListenerSSLServerIODispatch(this.portServerHandlerMapper, nHttpServerEventHandler, this.serverConnectionFactoryMapper);
                    defaultListeningIOReactor = this.createListeningIOReactor(passThroughSharedListenerConfiguration);
                    log.info((Object)("IO Reactor for port " + port + " initiated on shared mode which will be used by non axis2 Transport SSL Listeners "));
                    this.sharedSSLListeningIOReactor = defaultListeningIOReactor;
                    this.isSharedSSLIOReactorInitiated.compareAndSet(false, true);
                }
            } else {
                serverIODispatch = new ServerIODispatch(nHttpServerEventHandler, passThroughSharedListenerConfiguration.getServerConnFactory());
                defaultListeningIOReactor = this.createListeningIOReactor(passThroughSharedListenerConfiguration);
            }
            this.passThroughListenerServerIODispatchMapper.put(port, serverIODispatch);
            this.passThroughListenerIOReactorMapper.put(port, defaultListeningIOReactor);
        }
        catch (IOReactorException e) {
            throw new IOReactorException("Error occurred when trying to init IO Reactor", (Exception)((Object)e));
        }
        return defaultListeningIOReactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeDynamicPTTEndpoint(int port) {
        int portCloseVerifyTimeout = System.getProperty("synapse.transport.portCloseVerifyTimeout") == null ? 10 : Integer.parseInt(System.getProperty("synapse.transport.portCloseVerifyTimeout"));
        try {
            log.info((Object)("Closing Endpoint Listener for port " + port));
            this.dynamicPTTListeningEndpointMapper.get(port).close();
        }
        catch (Exception e) {
            log.error((Object)("Cannot close  Endpoint relevant to port " + port), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.serverConnectionFactoryMapper.containsKey(port)) {
                this.serverConnectionFactoryMapper.remove(port);
            }
            if (this.isPortCloseSuccess(port, portCloseVerifyTimeout)) {
                log.info((Object)("Successfully closed Endpoint Listener for port " + port));
            } else {
                log.warn((Object)("Port close verify timeout " + portCloseVerifyTimeout + "s exceeded. Endpoint Listener for port " + port + " still bound to the ListenerEndpoint."));
            }
            this.dynamicPTTListeningEndpointMapper.remove(port);
        }
        return true;
    }

    public boolean closeAllPTTListenerEndpoints(int port) {
        try {
            ListeningIOReactor listeningIOReactor = this.passThroughListenerIOReactorMapper.get(port);
            if (listeningIOReactor != null) {
                Set endpoints = listeningIOReactor.getEndpoints();
                if (this.passThroughListenerServerIODispatchMapper.get(port) instanceof MultiListenerServerIODispatch) {
                    for (ListenerEndpoint listenerEndpoint : endpoints) {
                        int endPointPort;
                        if (!(listenerEndpoint.getAddress() instanceof InetSocketAddress) || this.dynamicPTTListeningEndpointMapper.containsKey(endPointPort = ((InetSocketAddress)listenerEndpoint.getAddress()).getPort())) continue;
                        log.info((Object)("Closing Endpoint Listener for port " + port));
                        listenerEndpoint.close();
                        log.info((Object)("Successfully closed Endpoint Listener for port " + port));
                    }
                } else {
                    for (ListenerEndpoint listenerEndpoint : endpoints) {
                        log.info((Object)("Closing Endpoint Listener for port " + port));
                        listenerEndpoint.close();
                        log.info((Object)("Successfully closed Endpoint Listener for port " + port));
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Error occurred when closing Endpoint in PassThrough Transport Related to port " + port), (Throwable)e);
            return false;
        }
    }

    public boolean closeSpecificPTTListenerEndpoints(int port, Set<InetSocketAddress> bindAddresses) {
        try {
            ListeningIOReactor listeningIOReactor = this.passThroughListenerIOReactorMapper.get(port);
            if (listeningIOReactor != null) {
                Set endpoints = listeningIOReactor.getEndpoints();
                if (this.passThroughListenerServerIODispatchMapper.get(port) instanceof MultiListenerServerIODispatch) {
                    for (ListenerEndpoint listenerEndpoint : endpoints) {
                        int endPointPort;
                        if (!(listenerEndpoint.getAddress() instanceof InetSocketAddress) || this.dynamicPTTListeningEndpointMapper.containsKey(endPointPort = ((InetSocketAddress)listenerEndpoint.getAddress()).getPort())) continue;
                        for (InetSocketAddress inetSocketAddress : bindAddresses) {
                            if (!inetSocketAddress.getHostName().equalsIgnoreCase(((InetSocketAddress)listenerEndpoint.getAddress()).getHostName())) continue;
                            listenerEndpoint.close();
                        }
                    }
                } else {
                    for (ListenerEndpoint listenerEndpoint : endpoints) {
                        for (InetSocketAddress inetSocketAddress : bindAddresses) {
                            if (!inetSocketAddress.getHostName().equalsIgnoreCase(((InetSocketAddress)listenerEndpoint.getAddress()).getHostName())) continue;
                            listenerEndpoint.close();
                        }
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Error occurred when closing Endpoint in PassThrough Transport Related to port " + port), (Throwable)e);
            return false;
        }
    }

    public ServerIODispatch getServerIODispatch(int port) {
        return this.passThroughListenerServerIODispatchMapper.get(port);
    }

    public SourceConfiguration getSharedPassThroughSourceConfiguration() {
        if (this.passThroughListenerConfiguration != null) {
            return this.passThroughListenerConfiguration.getSourceConfiguration();
        }
        return null;
    }

    public SourceConfiguration getSharedSSLPassThroughSourceConfiguration() {
        if (this.sslPassThroughListenerConfiguration != null) {
            return this.sslPassThroughListenerConfiguration.getSourceConfiguration();
        }
        return null;
    }

    public void shutdownIOReactor(int port, SourceConfiguration sourceConfiguration, long timeout) throws IOException, InterruptedException {
        if (sourceConfiguration.getMetrics().getUnServedRequestCount() > 0) {
            log.info((Object)("Waiting to cleanup active connections on port " + port + ": " + sourceConfiguration.getMetrics().getUnServedRequestCount()));
        }
        long startTime = System.currentTimeMillis();
        long timeoutTime = startTime + timeout;
        while (sourceConfiguration.getMetrics().getUnServedRequestCount() > 0) {
            Thread.sleep(1000L);
            if (System.currentTimeMillis() <= timeoutTime) continue;
            log.info((Object)"Shutting down listener since Socket Timeout exceeded");
            break;
        }
        this.shutdownIOReactor(port);
    }

    public void shutdownIOReactor(int port) throws IOException {
        ListeningIOReactor ioReactor = this.shutdownReactor(port);
        if (ioReactor != null) {
            try {
                ioReactor.shutdown();
            }
            catch (IOException e) {
                throw new IOException("IOException occurred when shutting down IOReactor for Listener started on port " + port, e);
            }
            this.passThroughListenerIOReactorMapper.remove(port);
            this.passThroughListenerServerIODispatchMapper.remove(port);
        }
    }

    public void shutdownIOReactor(int port, long miliSeconds) throws IOException {
        ListeningIOReactor ioReactor = this.shutdownReactor(port);
        if (ioReactor != null) {
            try {
                ioReactor.shutdown(miliSeconds);
            }
            catch (IOException e) {
                throw new IOException("IOException occurred when shutting down IOReactor for Listener started on port " + port, e);
            }
            this.passThroughListenerIOReactorMapper.remove(port);
            this.passThroughListenerServerIODispatchMapper.remove(port);
        }
    }

    public void pauseIOReactor(int port) throws IOException {
        ListeningIOReactor listeningIOReactor = this.passThroughListenerIOReactorMapper.get(port);
        ServerIODispatch serverIODispatch = this.passThroughListenerServerIODispatchMapper.get(port);
        if (listeningIOReactor != null) {
            if (serverIODispatch instanceof MultiListenerServerIODispatch || serverIODispatch instanceof MultiListenerSSLServerIODispatch) {
                log.info((Object)("Pausing shared IO Reactor bind for port " + port + " will be caused for pausing non axis2 Listeners "));
            } else {
                log.info((Object)("Pausing  IO Reactor bind for port " + port));
            }
            listeningIOReactor.pause();
        } else {
            log.error((Object)("Cannot find Pass Through Listener for port " + port));
        }
    }

    public void resumeIOReactor(int port) throws IOException {
        ListeningIOReactor listeningIOReactor = this.passThroughListenerIOReactorMapper.get(port);
        if (listeningIOReactor != null) {
            listeningIOReactor.resume();
        } else {
            log.error((Object)("Cannot find Pass Through Listener for port " + port));
        }
    }

    public void startIOReactor(final ListeningIOReactor listeningIOReactor, final ServerIODispatch serverIODispatch, final String prefix) {
        Thread reactorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    listeningIOReactor.execute((IOEventDispatch)serverIODispatch);
                }
                catch (Exception e) {
                    log.fatal((Object)("Exception encountered in the " + prefix + " Listener. No more connections will be accepted by this transport"), (Throwable)e);
                }
                finally {
                    log.info((Object)(prefix + " Listener shutdown."));
                    if (serverIODispatch instanceof MultiListenerServerIODispatch) {
                        log.info((Object)"Shutting down shared IO Reactor");
                    }
                }
            }
        }, "PassThrough " + prefix + " Listener");
        reactorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListeningIOReactor getSharedIOReactor(NHttpServerEventHandler nHttpServerEventHandler, String endpointName) throws Exception {
        block7: {
            if (!this.isSharedIOReactorInitiated.get()) {
                if (this.passThroughListenerConfiguration != null) {
                    try {
                        PassThroughListeningIOReactorManager passThroughListeningIOReactorManager = this;
                        synchronized (passThroughListeningIOReactorManager) {
                            this.sharedListeningIOReactor = this.createListeningIOReactor(this.passThroughListenerConfiguration);
                            MultiListenerServerIODispatch serverIODispatch = new MultiListenerServerIODispatch(this.portServerHandlerMapper, nHttpServerEventHandler, this.passThroughListenerConfiguration.getServerConnFactory());
                            this.startIOReactor(this.sharedListeningIOReactor, serverIODispatch, "HTTP");
                            this.isSharedIOReactorInitiated.compareAndSet(false, true);
                            break block7;
                        }
                    }
                    catch (IOReactorException e) {
                        throw new IOReactorException("Error occurred when creating shared IO Reactor for non axis2 Listener " + endpointName, (Exception)((Object)e));
                    }
                }
                throw new Exception("Cannot start Endpoint for" + endpointName + "Axis2 Transport Listeners for PassThrough transport not started correctly or not created the IOReactor Configuration");
            }
        }
        return this.sharedListeningIOReactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListeningIOReactor getSharedSSLIOReactor(NHttpServerEventHandler nHttpServerEventHandler, String endpointName, int port, SSLConfiguration sslConfiguration) throws Exception {
        block8: {
            if (!this.isSharedSSLIOReactorInitiated.get()) {
                if (this.sslPassThroughListenerConfiguration != null) {
                    try {
                        PassThroughListeningIOReactorManager passThroughListeningIOReactorManager = this;
                        synchronized (passThroughListeningIOReactorManager) {
                            this.sharedSSLListeningIOReactor = this.createListeningIOReactor(this.sslPassThroughListenerConfiguration);
                            MultiListenerSSLServerIODispatch serverIODispatch = new MultiListenerSSLServerIODispatch(this.portServerHandlerMapper, nHttpServerEventHandler, this.serverConnectionFactoryMapper);
                            this.startIOReactor(this.sharedSSLListeningIOReactor, serverIODispatch, "HTTPS");
                            this.isSharedSSLIOReactorInitiated.compareAndSet(false, true);
                            break block8;
                        }
                    }
                    catch (IOReactorException e) {
                        throw new IOReactorException("Error occurred when creating shared IO Reactor for non axis2 Listener " + endpointName, (Exception)((Object)e));
                    }
                }
                throw new Exception("Cannot start Endpoint for" + endpointName + "Axis2 SSL Transport Listeners for PassThrough transport not started correctly or not created the IOReactor Configuration");
            }
        }
        ServerConnFactory serverConnFactory = SSLConnectionUtils.getServerConnectionFactory(endpointName, this.sslPassThroughListenerConfiguration, sslConfiguration);
        if (this.serverConnectionFactoryMapper.get(port) != null) {
            throw new Exception("Cannot create ServerConnectionFactory for " + endpointName + "in port " + port + "already registered a server connection factory ");
        }
        this.serverConnectionFactoryMapper.put(port, serverConnFactory);
        return this.sharedSSLListeningIOReactor;
    }

    private ListeningIOReactor createListeningIOReactor(PassThroughSharedListenerConfiguration passThroughSharedListenerConfiguration) throws IOReactorException {
        try {
            return new DefaultListeningIOReactor(passThroughSharedListenerConfiguration.getSourceConfiguration().getIOReactorConfig(), passThroughSharedListenerConfiguration.getThreadFactory());
        }
        catch (IOReactorException e) {
            throw new IOReactorException("Error creating DefaultListingIOReactor, ioReactorConfig or thread factory may have problems", (Exception)((Object)e));
        }
    }

    private ListenerEndpoint startEndpoint(InetSocketAddress inetSocketAddress, ListeningIOReactor defaultListeningIOReactor, String endPointName) throws Exception {
        ListenerEndpoint endpoint = defaultListeningIOReactor.listen((SocketAddress)inetSocketAddress);
        try {
            endpoint.waitFor();
            InetSocketAddress address = (InetSocketAddress)endpoint.getAddress();
            if (!address.isUnresolved()) {
                log.info((Object)((endPointName != null ? "Pass-through " + endPointName : " Pass-through Http ") + " Listener started on " + address.getHostName() + ":" + address.getPort()));
            } else {
                log.info((Object)((endPointName != null ? "Pass-through " + endPointName : " Pass-through Http ") + " Listener started on " + address));
            }
        }
        catch (Exception e) {
            throw new Exception("Endpoint does not start for port " + inetSocketAddress.getPort() + "May be IO Reactor not started or endpoint binding exception ", e);
        }
        return endpoint;
    }

    private ListeningIOReactor shutdownReactor(int port) {
        ListeningIOReactor listeningIOReactor = this.passThroughListenerIOReactorMapper.get(port);
        ServerIODispatch serverIODispatch = this.passThroughListenerServerIODispatchMapper.get(port);
        if (listeningIOReactor != null) {
            if (serverIODispatch instanceof MultiListenerServerIODispatch || serverIODispatch instanceof MultiListenerSSLServerIODispatch) {
                log.info((Object)("Shutting down shared IO Reactor bind for port " + port + " will be caused for shutdown non axis2 Listeners "));
            } else {
                log.info((Object)("Shutting down IO Reactor bind for port " + port));
            }
        } else {
            log.error((Object)("Cannot find Pass Through Listener for port " + port));
        }
        return listeningIOReactor;
    }

    public boolean isDynamicEndpointRunning(int port) {
        return this.dynamicPTTListeningEndpointMapper.get(port) != null;
    }

    private boolean isPortCloseSuccess(int port, int portCloseVerifyTimeout) {
        boolean portCloseSuccess = false;
        for (int i = 0; i < portCloseVerifyTimeout; ++i) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Verify port [" + port + "] close status. Attempt: " + i));
                }
                ServerSocket srv = new ServerSocket(port);
                srv.close();
                srv = null;
                portCloseSuccess = true;
                break;
            }
            catch (IOException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The port " + port + " is not closed yet, verify again after waiting 1s"), (Throwable)e);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return portCloseSuccess;
    }
}

