/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.core;

import java.io.IOException;
import java.util.Map;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.synapse.transport.http.conn.ServerConnFactory;
import org.apache.synapse.transport.passthru.ServerIODispatch;

public class MultiListenerServerIODispatch
extends ServerIODispatch {
    private volatile Map<Integer, NHttpServerEventHandler> handlers;

    public MultiListenerServerIODispatch(Map<Integer, NHttpServerEventHandler> handlers, NHttpServerEventHandler nHttpServerEventHandler, ServerConnFactory connFactory) {
        super(nHttpServerEventHandler, connFactory);
        this.handlers = handlers;
    }

    @Override
    protected void onConnected(DefaultNHttpServerConnection defaultNHttpServerConnection) {
        int localPort = defaultNHttpServerConnection.getLocalPort();
        NHttpServerEventHandler handler = this.handlers.get(localPort);
        try {
            handler.connected((NHttpServerConnection)defaultNHttpServerConnection);
        }
        catch (Exception ex) {
            handler.exception((NHttpServerConnection)defaultNHttpServerConnection, ex);
        }
    }

    @Override
    protected void onClosed(DefaultNHttpServerConnection defaultNHttpServerConnection) {
        int localPort = defaultNHttpServerConnection.getLocalPort();
        NHttpServerEventHandler handler = this.handlers.get(localPort);
        try {
            handler.closed((NHttpServerConnection)defaultNHttpServerConnection);
        }
        catch (Exception ex) {
            handler.exception((NHttpServerConnection)defaultNHttpServerConnection, ex);
        }
    }

    @Override
    protected void onException(DefaultNHttpServerConnection defaultNHttpServerConnection, IOException e) {
        int localPort = defaultNHttpServerConnection.getLocalPort();
        NHttpServerEventHandler handler = this.handlers.get(localPort);
        try {
            handler.exception((NHttpServerConnection)defaultNHttpServerConnection, (Exception)e);
        }
        catch (Exception ex) {
            handler.exception((NHttpServerConnection)defaultNHttpServerConnection, ex);
        }
    }

    @Override
    protected void onInputReady(DefaultNHttpServerConnection defaultNHttpServerConnection) {
        int localPort = defaultNHttpServerConnection.getLocalPort();
        NHttpServerEventHandler handler = this.handlers.get(localPort);
        try {
            defaultNHttpServerConnection.consumeInput(handler);
        }
        catch (Exception ex) {
            handler.exception((NHttpServerConnection)defaultNHttpServerConnection, ex);
        }
    }

    @Override
    protected void onOutputReady(DefaultNHttpServerConnection defaultNHttpServerConnection) {
        int localPort = defaultNHttpServerConnection.getLocalPort();
        NHttpServerEventHandler handler = this.handlers.get(localPort);
        try {
            defaultNHttpServerConnection.produceOutput(handler);
        }
        catch (Exception ex) {
            handler.exception((NHttpServerConnection)defaultNHttpServerConnection, ex);
        }
    }

    @Override
    protected void onTimeout(DefaultNHttpServerConnection defaultNHttpServerConnection) {
        int localPort = defaultNHttpServerConnection.getLocalPort();
        NHttpServerEventHandler handler = this.handlers.get(localPort);
        try {
            handler.timeout((NHttpServerConnection)defaultNHttpServerConnection);
        }
        catch (Exception ex) {
            handler.exception((NHttpServerConnection)defaultNHttpServerConnection, ex);
        }
    }
}

