/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.connections;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.SessionRequestCallback;
import org.apache.synapse.transport.passthru.ConnectCallback;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.TargetContext;
import org.apache.synapse.transport.passthru.TargetErrorHandler;
import org.apache.synapse.transport.passthru.config.ConnectionTimeoutConfiguration;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.transport.passthru.config.TargetConfiguration;
import org.apache.synapse.transport.passthru.connections.HostConnections;

public class TargetConnections {
    private static final Log log = LogFactory.getLog(TargetConnections.class);
    private final Map<HttpRoute, HostConnections> poolMap = new ConcurrentHashMap<HttpRoute, HostConnections>();
    private final String sslSchemaName = "https";
    private int maxConnections;
    private ConnectingIOReactor ioReactor;
    private ConnectCallback callback = null;
    private ConnectionTimeoutConfiguration connectionTimeoutConfiguration;

    public TargetConnections(ConnectingIOReactor ioReactor, TargetConfiguration targetConfiguration, ConnectCallback callback) {
        this.maxConnections = targetConfiguration.getMaxConnections();
        this.ioReactor = ioReactor;
        this.callback = callback;
        this.connectionTimeoutConfiguration = new ConnectionTimeoutConfiguration(PassThroughConfiguration.getInstance().getConnectionIdleTime(), PassThroughConfiguration.getInstance().getMaximumConnectionLifespan(), PassThroughConfiguration.getInstance().getConnectionGraceTime());
    }

    public NHttpClientConnection getConnection(HttpRoute route, MessageContext msgContext, TargetErrorHandler targetErrorHandler, Queue<MessageContext> queue) {
        HostConnections pool;
        NHttpClientConnection connection;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to get a connection " + route));
        }
        if ((connection = (pool = this.getConnectionPool(route)).getConnection()) == null) {
            if (pool.checkAndIncrementPendingConnections()) {
                HttpHost host = route.getProxyHost() != null ? route.getProxyHost() : route.getTargetHost();
                this.ioReactor.connect((SocketAddress)new InetSocketAddress(host.getHostName(), host.getPort()), null, (Object)pool, (SessionRequestCallback)this.callback);
            } else {
                log.warn((Object)("Connection pool reached maximum allowed connections for route " + route + ". Target server may have become slow"));
                if (msgContext != null) {
                    queue.remove(msgContext);
                    msgContext.setProperty("CONNECTION_LIMIT_EXCEEDS", (Object)"true");
                    targetErrorHandler.handleError(msgContext, 101504, "No available connections to serve the request", null, ProtocolState.REQUEST_READY);
                }
            }
        } else {
            return connection;
        }
        return null;
    }

    public NHttpClientConnection getExistingConnection(HttpRoute route) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to get a existing connection connection " + route));
        }
        HostConnections pool = this.getConnectionPool(route);
        return pool.getConnection();
    }

    public void shutdownConnection(NHttpClientConnection conn) {
        this.shutdownConnection(conn, false);
    }

    public void shutdownConnection(NHttpClientConnection conn, boolean isError) {
        HostConnections pool = (HostConnections)conn.getContext().getAttribute("CONNECTION_POOL");
        TargetContext.get((NHttpConnection)conn).reset(isError);
        if (pool != null) {
            pool.forget(conn);
        } else {
            log.fatal((Object)"Connection without a pool. Something wrong. Need to fix.");
        }
        try {
            conn.shutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void releaseConnection(NHttpClientConnection conn) {
        HostConnections pool = (HostConnections)conn.getContext().getAttribute("CONNECTION_POOL");
        TargetContext.get((NHttpConnection)conn).reset(false);
        if (pool != null) {
            pool.release(conn);
        } else {
            log.fatal((Object)"Connection without a pool. Something wrong. Need to fix.");
        }
    }

    public void addConnection(NHttpClientConnection conn) {
        HostConnections pool = (HostConnections)conn.getContext().getAttribute("CONNECTION_POOL");
        if (pool != null) {
            pool.addConnection(conn);
        } else {
            log.fatal((Object)"Connection without a pool. Something wrong. Need to fix.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostConnections getConnectionPool(HttpRoute route) {
        Map<HttpRoute, HostConnections> map = this.poolMap;
        synchronized (map) {
            HostConnections pool = this.poolMap.get(route);
            if (pool == null) {
                pool = new HostConnections(route, this.maxConnections, this.connectionTimeoutConfiguration);
                this.poolMap.put(route, pool);
            }
            return pool;
        }
    }

    public void resetConnectionPool(Set<String> hostList) {
        for (String host : hostList) {
            String[] params = host.split(":");
            for (Map.Entry<HttpRoute, HostConnections> connectionsEntry : this.poolMap.entrySet()) {
                HttpRoute httpRoute = connectionsEntry.getKey();
                if (params.length <= 1 || !params[0].equalsIgnoreCase(httpRoute.getTargetHost().getHostName()) || Integer.valueOf(params[1]).intValue() != httpRoute.getTargetHost().getPort() || !httpRoute.getTargetHost().getSchemeName().equalsIgnoreCase("https")) continue;
                try {
                    NHttpClientConnection connection = connectionsEntry.getValue().getConnection();
                    if (connection != null && connection.getContext() != null) {
                        this.shutdownConnection(connectionsEntry.getValue().getConnection());
                        log.info((Object)("Connection " + httpRoute.getTargetHost().getHostName() + ":" + httpRoute.getTargetHost().getPort() + " Successful"));
                        continue;
                    }
                    log.debug((Object)("Error shutdown connection for " + httpRoute.getTargetHost().getHostName() + " " + httpRoute.getTargetHost().getPort() + " - Connection not available"));
                }
                catch (Exception e) {
                    log.warn((Object)("Error shutdown connection for " + httpRoute.getTargetHost().getHostName() + " " + httpRoute.getTargetHost().getPort() + " "), (Throwable)e);
                }
            }
        }
    }
}

