/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.connections;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.protocol.HttpContext;
import org.apache.synapse.transport.passthru.config.ConnectionTimeoutConfiguration;

public class HostConnections {
    private static final Log log = LogFactory.getLog(HostConnections.class);
    private final HttpRoute route;
    private final int maxSize;
    private int pendingConnections;
    private int connectionIdleTime;
    private int maximumConnectionLifeSpan;
    private int connectionGraceTime;
    private List<NHttpClientConnection> freeConnections = new ArrayList<NHttpClientConnection>();
    private List<NHttpClientConnection> busyConnections = new ArrayList<NHttpClientConnection>();
    private Lock lock = new ReentrantLock();

    public HostConnections(HttpRoute route, int maxSize) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating new connection pool: " + route));
        }
        this.route = route;
        this.maxSize = maxSize;
    }

    public HostConnections(HttpRoute route, int maxSize, ConnectionTimeoutConfiguration connectionTimeoutConfiguration) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating new connection pool: " + route));
        }
        this.route = route;
        this.maxSize = maxSize;
        this.connectionIdleTime = connectionTimeoutConfiguration.getConnectionIdleTime();
        this.maximumConnectionLifeSpan = connectionTimeoutConfiguration.getMaximumConnectionLifeSpane();
        this.connectionGraceTime = connectionTimeoutConfiguration.getConnectionGraceTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NHttpClientConnection getConnection() {
        this.lock.lock();
        try {
            while (!this.freeConnections.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Returning an existing free connection " + this.route));
                }
                NHttpClientConnection conn = this.freeConnections.get(0);
                long currentTime = System.currentTimeMillis();
                long connectionInitTime = (Long)conn.getContext().getAttribute("CONNECTION_INIT_TIME");
                long expiryTime = (Long)conn.getContext().getAttribute("CONNECTION_EXPIRY_TIME");
                if (this.isMaximumLifeSpanExceeded(currentTime, connectionInitTime) || currentTime >= expiryTime) {
                    this.freeConnections.remove(conn);
                    try {
                        conn.shutdown();
                    }
                    catch (IOException io) {
                        log.error((Object)("Error occurred while shutting down connection." + io.getMessage()), (Throwable)io);
                    }
                    continue;
                }
                this.freeConnections.remove(conn);
                this.busyConnections.add(conn);
                NHttpClientConnection nHttpClientConnection = conn;
                return nHttpClientConnection;
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    private boolean isMaximumLifeSpanExceeded(long currentTime, long connectionInitTime) {
        if (this.maximumConnectionLifeSpan > 0 && currentTime > (long)this.maximumConnectionLifeSpan + connectionInitTime) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Connection has been persisted for " + (currentTime - connectionInitTime) + " milliseconds where the maximum connection life span is " + this.maximumConnectionLifeSpan + " milliseconds."));
            }
            return true;
        }
        return false;
    }

    public void release(NHttpClientConnection conn) {
        conn.getMetrics().reset();
        HttpContext ctx = conn.getContext();
        ctx.removeAttribute("http.request");
        ctx.removeAttribute("http.response");
        ctx.setAttribute("CONNECTION_EXPIRY_TIME", (Object)this.getExpiryTime(conn));
        ctx.removeAttribute("endPointURI");
        ctx.removeAttribute("REQUEST_MESSAGE_CONTEXT");
        ctx.removeAttribute("RESPONSE_MESSAGE_CONTEXT");
        this.lock.lock();
        try {
            if (this.busyConnections.remove(conn)) {
                this.freeConnections.add(conn);
            } else {
                log.error((Object)"Attempted to releaseConnection connection not in the busy list");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private long getExpiryTime(NHttpClientConnection connection) {
        long expiryTime = System.currentTimeMillis();
        Object keepAlive = connection.getContext().getAttribute("CONNECTION_KEEP_ALIVE_TIME_OUT");
        if (keepAlive != null) {
            int keepAliveTimeout = (Integer)keepAlive;
            expiryTime = expiryTime + (long)keepAliveTimeout - (long)this.connectionGraceTime;
        } else {
            expiryTime += (long)this.connectionIdleTime;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Expiry time set for connection: " + expiryTime + " milliseconds"));
        }
        return expiryTime;
    }

    public void forget(NHttpClientConnection conn) {
        this.lock.lock();
        try {
            if (!this.freeConnections.remove(conn)) {
                this.busyConnections.remove(conn);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addConnection(NHttpClientConnection conn) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("New connection " + this.route + " is added to the free list"));
        }
        this.lock.lock();
        try {
            --this.pendingConnections;
            conn.getContext().setAttribute("CONNECTION_INIT_TIME", (Object)System.currentTimeMillis());
            this.busyConnections.add(conn);
        }
        finally {
            this.lock.unlock();
        }
    }

    public synchronized void pendingConnectionSucceeded() {
        this.lock.lock();
        try {
            --this.pendingConnections;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void pendingConnectionFailed() {
        this.lock.lock();
        try {
            --this.pendingConnections;
        }
        finally {
            this.lock.unlock();
        }
    }

    public HttpRoute getRoute() {
        return this.route;
    }

    public boolean checkAndIncrementPendingConnections() {
        this.lock.lock();
        int totalConnections = this.busyConnections.size() + this.pendingConnections;
        try {
            if (totalConnections < this.maxSize) {
                ++this.pendingConnections;
            }
            boolean bl = totalConnections < this.maxSize;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

