/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.config;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.synapse.transport.http.conn.ProxyAuthenticator;
import org.apache.synapse.transport.passthru.config.BaseConfiguration;
import org.apache.synapse.transport.passthru.config.ConnectionTimeoutConfiguration;
import org.apache.synapse.transport.passthru.connections.TargetConnections;
import org.apache.synapse.transport.passthru.jmx.PassThroughTransportMetricsCollector;

public class TargetConfiguration
extends BaseConfiguration {
    private HttpProcessor httpProcessor = null;
    private ProxyAuthenticator proxyAuthenticator = null;
    private int maxConnections = Integer.MAX_VALUE;
    private ConnectionTimeoutConfiguration connectionTimeoutConfiguration;
    private TargetConnections connections = null;

    public TargetConfiguration(ConfigurationContext configurationContext, ParameterInclude parameters, WorkerPool pool, PassThroughTransportMetricsCollector metrics, ProxyAuthenticator proxyAuthenticator) {
        super(configurationContext, parameters, pool, metrics);
        this.httpProcessor = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestConnControl(), new RequestUserAgent(), new RequestExpectContinue()});
        this.connectionTimeoutConfiguration = new ConnectionTimeoutConfiguration(this.conf.getConnectionIdleTime(), this.conf.getMaximumConnectionLifespan(), this.conf.getConnectionGraceTime());
        this.proxyAuthenticator = proxyAuthenticator;
    }

    @Override
    public void build() throws AxisFault {
        super.build();
        this.maxConnections = this.conf.getIntProperty("http.max.connection.per.host.port", Integer.MAX_VALUE);
        this.preserveUserAgentHeader = this.conf.isPreserveUserAgentHeader();
        this.preserveServerHeader = this.conf.isPreserveServerHeader();
        this.populatePreserveHttpHeaders(this.conf.getPreserveHttpHeaders());
    }

    public HttpParams getHttpParams() {
        return this.httpParams;
    }

    public IOReactorConfig getIOReactorConfig() {
        return this.ioReactorConfig;
    }

    public HttpProcessor getHttpProcessor() {
        return this.httpProcessor;
    }

    public ProxyAuthenticator getProxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public TargetConnections getConnections() {
        return this.connections;
    }

    public void setConnections(TargetConnections connections) {
        this.connections = connections;
    }
}

