/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.base.ParamUtils;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.synapse.transport.http.conn.Scheme;
import org.apache.synapse.transport.passthru.HttpGetRequestProcessor;
import org.apache.synapse.transport.passthru.config.BaseConfiguration;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.transport.passthru.connections.SourceConnections;
import org.apache.synapse.transport.passthru.jmx.PassThroughTransportMetricsCollector;

public class SourceConfiguration
extends BaseConfiguration {
    private Log log = LogFactory.getLog(SourceConfiguration.class);
    private HttpProcessor httpProcessor = null;
    private HttpResponseFactory responseFactory = null;
    private int port = 8280;
    private SourceConnections sourceConnections = null;
    private TransportInDescription inDescription;
    private Scheme scheme;
    private String host;
    private String serviceEPRPrefix;
    private String customEPRPrefix;
    private HttpGetRequestProcessor httpGetRequestProcessor = null;

    public SourceConfiguration(ConfigurationContext configurationContext, TransportInDescription description, Scheme scheme, WorkerPool pool, PassThroughTransportMetricsCollector metrics) {
        super(configurationContext, (ParameterInclude)description, pool, metrics);
        this.inDescription = description;
        this.scheme = scheme;
        this.httpProcessor = new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseDate(), new ResponseServer(), new ResponseContent(), new ResponseConnControl()});
        this.responseFactory = new DefaultHttpResponseFactory();
        this.sourceConnections = new SourceConnections();
    }

    public SourceConfiguration(WorkerPool pool, PassThroughTransportMetricsCollector metrics) {
        super(null, null, pool, metrics);
    }

    @Override
    public void build() throws AxisFault {
        super.build();
        this.port = ParamUtils.getRequiredParamInt((ParameterInclude)this.parameters, (String)"port");
        Parameter hostParameter = this.inDescription.getParameter("hostname");
        if (hostParameter != null) {
            this.host = ((String)hostParameter.getValue()).trim();
        } else {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.log.warn((Object)"Unable to lookup local host name, using 'localhost'");
            }
        }
        Parameter param = this.inDescription.getParameter("WSDLEPRPrefix");
        if (param != null) {
            this.serviceEPRPrefix = this.getServiceEPRPrefix(this.configurationContext, (String)param.getValue());
            this.customEPRPrefix = (String)param.getValue();
        } else {
            this.serviceEPRPrefix = this.getServiceEPRPrefix(this.configurationContext, this.host, this.port);
            this.customEPRPrefix = this.scheme.getName() + "://" + this.host + ":" + (this.port == this.scheme.getDefaultPort() ? "" : Integer.valueOf(this.port)) + "/";
        }
        param = this.inDescription.getParameter("httpGetProcessor");
        if (param != null && param.getValue() != null) {
            this.httpGetRequestProcessor = this.createHttpGetProcessor(param.getValue().toString());
            if (this.httpGetRequestProcessor == null) {
                this.handleException("Cannot create HttpGetRequestProcessor");
            }
        }
        this.populatePreserveHttpHeaders(this.conf.getResponsePreseveHttpHeaders());
    }

    public HttpParams getHttpParams() {
        return this.httpParams;
    }

    public IOReactorConfig getIOReactorConfig() {
        return this.ioReactorConfig;
    }

    public HttpProcessor getHttpProcessor() {
        return this.httpProcessor;
    }

    public HttpResponseFactory getResponseFactory() {
        return this.responseFactory;
    }

    public String getHostname() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public SourceConnections getSourceConnections() {
        return this.sourceConnections;
    }

    public TransportInDescription getInDescription() {
        return this.inDescription;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public String getServiceEPRPrefix() {
        return this.serviceEPRPrefix;
    }

    public String getCustomEPRPrefix() {
        return this.customEPRPrefix;
    }

    public HttpGetRequestProcessor getHttpGetRequestProcessor() {
        return this.httpGetRequestProcessor;
    }

    protected String getServiceEPRPrefix(ConfigurationContext cfgCtx, String wsdlEPRPrefix) {
        return wsdlEPRPrefix + (!cfgCtx.getServiceContextPath().startsWith("/") ? "/" : "") + cfgCtx.getServiceContextPath() + (!cfgCtx.getServiceContextPath().endsWith("/") ? "/" : "");
    }

    protected String getServiceEPRPrefix(ConfigurationContext cfgCtx, String host, int port) {
        return this.scheme.getName() + "://" + host + (port == this.scheme.getDefaultPort() ? "" : ":" + port) + (!cfgCtx.getServiceContextPath().startsWith("/") ? "/" : "") + cfgCtx.getServiceContextPath() + (!cfgCtx.getServiceContextPath().endsWith("/") ? "/" : "");
    }

    private HttpGetRequestProcessor createHttpGetProcessor(String str) throws AxisFault {
        Object obj = null;
        try {
            obj = Class.forName(str).newInstance();
        }
        catch (ClassNotFoundException e) {
            this.handleException("Error creating WSDL processor", e);
        }
        catch (InstantiationException e) {
            this.handleException("Error creating WSDL processor", e);
        }
        catch (IllegalAccessException e) {
            this.handleException("Error creating WSDL processor", e);
        }
        if (obj instanceof HttpGetRequestProcessor) {
            return obj;
        }
        this.handleException("Error creating WSDL processor. The HttpProcessor should be of type org.apache.synapse.transport.nhttp.HttpGetRequestProcessor");
        return null;
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        this.log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    private void handleException(String msg) throws AxisFault {
        this.log.error((Object)msg);
        throw new AxisFault(msg);
    }

    public boolean getBooleanValue(String name, boolean def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = PassThroughConfiguration.getInstance().getStringProperty(name, String.valueOf(def));
        }
        if (val != null && Boolean.parseBoolean(val)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Using Passthru http tuning parameter : " + name));
            }
            return true;
        }
        if (val != null && !Boolean.parseBoolean(val)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Using Passthru http tuning parameter : " + name));
            }
            return false;
        }
        return def;
    }
}

