/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PassThroughConfiguration {
    private static final int DEFAULT_WORKER_POOL_SIZE_CORE = 40;
    private static final int DEFAULT_WORKER_POOL_SIZE_MAX = 200;
    private static final int DEFAULT_WORKER_THREAD_KEEPALIVE_SEC = 60;
    private static final int DEFAULT_WORKER_POOL_QUEUE_LENGTH = -1;
    private static final int DEFAULT_IO_BUFFER_SIZE = 8192;
    private static final int DEFAULT_IO_THREADS_PER_REACTOR = Runtime.getRuntime().availableProcessors();
    private static final int DEFAULT_MAX_ACTIVE_CON = -1;
    private static final int DEFAULT_LISTENER_SHUTDOWN_WAIT_TIME = 0;
    private static final int DEFAULT_CONNECTION_GRACE_TIME = 10000;
    private Boolean isKeepAliveDisabled = null;
    private static final String REST_DISPATCHER_SERVICE = "rest.dispatcher.service";
    private static final String REST_URI_API_REGEX = "rest_uri_api_regex";
    private static final String REST_URI_PROXY_REGEX = "rest_uri_proxy_regex";
    private static final String ALLOWED_RESPONSE_PROPERTIES = "allowed_response_properties";
    private Boolean reverseProxyMode = null;
    private String passThroughDefaultServiceName = null;
    private static final Log log = LogFactory.getLog(PassThroughConfiguration.class);
    private static PassThroughConfiguration _instance = new PassThroughConfiguration();
    private Properties props;

    private PassThroughConfiguration() {
        try {
            this.props = PassThroughConfiguration.loadProperties("passthru-http.properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static PassThroughConfiguration getInstance() {
        return _instance;
    }

    public int getWorkerPoolCoreSize() {
        return this.getIntProperty("worker_pool_size_core", 40);
    }

    public int getWorkerPoolMaxSize() {
        return this.getIntProperty("worker_pool_size_max", 200);
    }

    public int getWorkerThreadKeepaliveSec() {
        return this.getIntProperty("worker_thread_keepalive_sec", 60);
    }

    public int getWorkerPoolQueueLen() {
        return this.getIntProperty("worker_pool_queue_length", -1);
    }

    public int getIOThreadsPerReactor() {
        return this.getIntProperty("io_threads_per_reactor", DEFAULT_IO_THREADS_PER_REACTOR);
    }

    public int getIOBufferSize() {
        return this.getIntProperty("io_buffer_size", 8192);
    }

    public boolean isKeepAliveDisabled() {
        if (this.isKeepAliveDisabled == null) {
            this.isKeepAliveDisabled = this.getBooleanProperty("http.connection.disable.keepalive", false);
        }
        return this.isKeepAliveDisabled;
    }

    public int getMaxActiveConnections() {
        return this.getIntProperty("max_open_connections", -1);
    }

    public int getListenerShutdownWaitTime() {
        return this.getIntProperty("transport.listener.shutdown.wait.sec", 0) * 1000;
    }

    public boolean isPreserveUserAgentHeader() {
        return this.getBooleanProperty("http.user.agent.preserve", false);
    }

    public boolean isPreserveServerHeader() {
        return this.getBooleanProperty("http.server.preserve", false);
    }

    public boolean isForcedXmlMessageValidationEnabled() {
        return this.getBooleanProperty("force.xml.message.validation", false);
    }

    public boolean isForcedJSONMessageValidationEnabled() {
        return this.getBooleanProperty("force.json.message.validation", false);
    }

    public String getPreserveHttpHeaders() {
        return this.getStringProperty("http.headers.preserve", "");
    }

    public String getResponsePreseveHttpHeaders() {
        return this.getStringProperty("http.response.headers.preserve", "");
    }

    public int getConnectionIdleTime() {
        int idleTime = this.isIntPropertyConfigured("transport.sender.connection.grace.time") ? this.getIdleTimeFromGraceTime() : this.getIntProperty("transport.sender.connection.idle.time", this.getIdleTimeFromGraceTime()).intValue();
        if (idleTime < 0) {
            return 0;
        }
        return idleTime;
    }

    public int getMaximumConnectionLifespan() {
        return this.getIntProperty("transport.sender.connection.maximum.lifespan", Integer.MAX_VALUE);
    }

    public int getConnectionGraceTime() {
        return this.getIntProperty("transport.sender.connection.grace.time", 10000);
    }

    private int getIdleTimeFromGraceTime() {
        return this.getIntProperty("http.socket.timeout", 60000) - this.getConnectionGraceTime();
    }

    public String getCorrelationHeaderName() {
        return this.getStringProperty("correlation_header_name", "activityid");
    }

    private static Properties loadProperties(String filePath) {
        String msg;
        Properties properties = new Properties();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading the file '" + filePath + "' from classpath"));
        }
        InputStream in = null;
        if (System.getProperty("conf.location") != null) {
            try {
                in = new FileInputStream(System.getProperty("conf.location") + File.separator + filePath);
            }
            catch (FileNotFoundException e) {
                msg = "Error loading properties from a file at from the System defined location: " + filePath;
                log.warn((Object)msg);
            }
        }
        if (in == null) {
            in = cl.getResourceAsStream(filePath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to load file  '" + filePath + "'"));
            }
            filePath = "conf" + File.separatorChar + filePath;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading the file '" + filePath + "'"));
            }
            if ((in = cl.getResourceAsStream(filePath)) == null && log.isDebugEnabled()) {
                log.debug((Object)("Unable to load file  '" + filePath + "'"));
            }
        }
        if (in != null) {
            try {
                properties.load(in);
            }
            catch (IOException e) {
                msg = "Error loading properties from a file at : " + filePath;
                log.error((Object)msg, (Throwable)e);
            }
        }
        return properties;
    }

    public Integer getIntProperty(String name, Integer def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        if (val != null) {
            int intVal;
            try {
                intVal = Integer.valueOf(val);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Invalid pass-through http tuning property value. " + name + " must be an integer"));
                return def;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using pass-through http tuning parameter : " + name + " = " + val));
            }
            return intVal;
        }
        return def;
    }

    private boolean isIntPropertyConfigured(String name) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        if (val != null) {
            try {
                Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Incorrect pass-through http tuning property value. " + name + " must be an integer"));
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using configured pass-through http tuning property value for : " + name));
            }
            return true;
        }
        return false;
    }

    public Integer getIntProperty(String name) {
        return this.getIntProperty(name, null);
    }

    public Boolean getBooleanProperty(String name, Boolean def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        if (val != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using pass-through http tuning parameter : " + name + " = " + val));
            }
            return Boolean.valueOf(val);
        }
        return def;
    }

    public Boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, null);
    }

    public String getStringProperty(String name, String def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        return val == null ? def : val;
    }

    public String getRESTDispatchService() {
        return this.getStringProperty(REST_DISPATCHER_SERVICE, "");
    }

    public String getRestUriApiRegex() {
        return this.getStringProperty(REST_URI_API_REGEX, "");
    }

    public String getRestUriProxyRegex() {
        return this.getStringProperty(REST_URI_PROXY_REGEX, "");
    }

    public boolean isListeningIOReactorShared() {
        return this.getBooleanProperty("http_listening_io_reactor_sharing_enable", false);
    }

    public String getAllowedResponseProperties() {
        return this.getStringProperty(ALLOWED_RESPONSE_PROPERTIES, null);
    }

    public boolean isReverseProxyMode() {
        if (this.reverseProxyMode == null) {
            this.reverseProxyMode = Boolean.parseBoolean(System.getProperty("reverseProxyMode"));
        }
        return this.reverseProxyMode;
    }

    public String getPassThroughDefaultServiceName() {
        if (this.passThroughDefaultServiceName == null) {
            this.passThroughDefaultServiceName = this.getStringProperty("passthru.default.service", "__SynapseService");
        }
        return this.passThroughDefaultServiceName;
    }
}

