/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.base.threads.WorkerPoolFactory;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.transport.passthru.jmx.PassThroughTransportMetricsCollector;
import org.apache.synapse.transport.passthru.util.BufferFactory;

public abstract class BaseConfiguration {
    protected ParameterInclude parameters = null;
    private WorkerPool workerPool = null;
    protected ConfigurationContext configurationContext = null;
    protected HttpParams httpParams = null;
    protected IOReactorConfig ioReactorConfig = null;
    protected BufferFactory bufferFactory = null;
    protected boolean preserveUserAgentHeader = false;
    protected boolean preserveServerHeader = true;
    protected List<String> preserveHttpHeaders;
    private PassThroughTransportMetricsCollector metrics = null;
    private int iOBufferSize;
    protected PassThroughConfiguration conf = PassThroughConfiguration.getInstance();
    private Boolean correlationLoggingEnabled = false;
    private static final String PASSTHROUGH_THREAD_GROUP = "Pass-through Message Processing Thread Group";
    private static final String PASSTHROUGH_THREAD_ID = "PassThroughMessageProcessor";
    private Integer socketTimeout = null;
    private Integer connectionTimeout = null;

    public BaseConfiguration(ConfigurationContext configurationContext, ParameterInclude parameters, WorkerPool workerPool, PassThroughTransportMetricsCollector metrics) {
        this.parameters = parameters;
        this.workerPool = workerPool;
        this.configurationContext = configurationContext;
        this.metrics = metrics;
    }

    public void build() throws AxisFault {
        this.iOBufferSize = this.conf.getIOBufferSize();
        if (this.workerPool == null) {
            this.workerPool = WorkerPoolFactory.getWorkerPool((int)this.conf.getWorkerPoolCoreSize(), (int)this.conf.getWorkerPoolMaxSize(), (int)this.conf.getWorkerThreadKeepaliveSec(), (int)this.conf.getWorkerPoolQueueLen(), (String)PASSTHROUGH_THREAD_GROUP, (String)PASSTHROUGH_THREAD_ID);
        }
        this.httpParams = this.buildHttpParams();
        this.ioReactorConfig = this.buildIOReactorConfig();
        String sysCorrelationStatus = System.getProperty("enableCorrelationLogs");
        if (sysCorrelationStatus != null) {
            this.correlationLoggingEnabled = sysCorrelationStatus.equalsIgnoreCase("true");
        }
        this.bufferFactory = new BufferFactory(this.iOBufferSize, (ByteBufferAllocator)new HeapByteBufferAllocator(), 512);
    }

    public WorkerPool getWorkerPool(int workerPoolCoreSize, int workerPoolMaxSize, int workerThreadKeepaliveSec, int workerPoolQueuLen, String threadGroupName, String threadgroupID) {
        if (threadGroupName == null) {
            threadGroupName = PASSTHROUGH_THREAD_GROUP;
        }
        if (threadgroupID == null) {
            threadgroupID = PASSTHROUGH_THREAD_ID;
        }
        if (workerPoolCoreSize == 0) {
            workerPoolCoreSize = this.conf.getWorkerPoolCoreSize();
        }
        if (workerPoolMaxSize == 0) {
            workerPoolMaxSize = this.conf.getWorkerPoolMaxSize();
        }
        if (workerThreadKeepaliveSec == 0) {
            workerThreadKeepaliveSec = this.conf.getWorkerThreadKeepaliveSec();
        }
        if (workerPoolQueuLen == 0) {
            workerPoolQueuLen = this.conf.getWorkerPoolQueueLen();
        }
        return WorkerPoolFactory.getWorkerPool((int)workerPoolCoreSize, (int)workerPoolMaxSize, (int)workerThreadKeepaliveSec, (int)workerPoolQueuLen, (String)threadGroupName, (String)threadgroupID);
    }

    public int getIOBufferSize() {
        return this.iOBufferSize;
    }

    public WorkerPool getWorkerPool() {
        return this.workerPool;
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    protected HttpParams buildHttpParams() {
        BasicHttpParams params = new BasicHttpParams();
        params.setIntParameter("http.socket.timeout", this.getSocketTimeout().intValue()).setIntParameter("http.connection.timeout", this.getConnectionTimeout().intValue()).setIntParameter("http.socket.buffer-size", this.conf.getIntProperty("http.socket.buffer-size", 8192).intValue()).setParameter("http.origin-server", (Object)this.conf.getStringProperty("http.origin-server", "WSO2-PassThrough-HTTP")).setParameter("http.useragent", (Object)this.conf.getStringProperty("http.useragent", "Synapse-PT-HttpComponents-NIO"));
        return params;
    }

    protected IOReactorConfig buildIOReactorConfig() {
        IOReactorConfig config = new IOReactorConfig();
        config.setIoThreadCount(this.conf.getIOThreadsPerReactor());
        config.setSoTimeout(this.getSocketTimeout().intValue());
        config.setConnectTimeout(this.getConnectionTimeout().intValue());
        config.setTcpNoDelay(this.conf.getBooleanProperty("http.tcp.nodelay", true).booleanValue());
        config.setSoLinger(this.conf.getIntProperty("http.socket.linger", -1).intValue());
        config.setSoReuseAddress(this.conf.getBooleanProperty("http.socket.reuseaddr", false).booleanValue());
        config.setInterestOpQueued(this.conf.getBooleanProperty("http.nio.interest-ops-queueing", false).booleanValue());
        config.setSelectInterval((long)this.conf.getIntProperty("http.nio.select-interval", 1000).intValue());
        return config;
    }

    public BufferFactory getBufferFactory() {
        return this.bufferFactory;
    }

    public PassThroughTransportMetricsCollector getMetrics() {
        return this.metrics;
    }

    public Boolean isCorrelationLoggingEnabled() {
        return this.correlationLoggingEnabled;
    }

    private Integer getSocketTimeout() {
        if (this.socketTimeout != null) {
            return this.socketTimeout;
        }
        this.socketTimeout = this.conf.getIntProperty("http.socket.timeout", 60000);
        return this.socketTimeout;
    }

    private Integer getConnectionTimeout() {
        if (this.connectionTimeout != null) {
            return this.connectionTimeout;
        }
        this.connectionTimeout = this.conf.getIntProperty("http.connection.timeout", this.getSocketTimeout() / 2);
        return this.connectionTimeout;
    }

    public boolean isPreserveHttpHeader(String headerName) {
        if (this.preserveHttpHeaders == null || this.preserveHttpHeaders.isEmpty() || headerName == null) {
            return false;
        }
        return this.preserveHttpHeaders.contains(headerName.toUpperCase());
    }

    public List<String> getPreserveHttpHeaders() {
        return this.preserveHttpHeaders;
    }

    protected void populatePreserveHttpHeaders(String preserveHeaders) {
        String[] presHeaders;
        this.preserveHttpHeaders = new ArrayList<String>();
        if (preserveHeaders != null && !preserveHeaders.isEmpty() && (presHeaders = preserveHeaders.trim().toUpperCase().split(",")) != null && presHeaders.length > 0) {
            this.preserveHttpHeaders.addAll(Arrays.asList(presHeaders));
        }
        if (this.preserveServerHeader && !this.preserveHttpHeaders.contains("Server".toUpperCase())) {
            this.preserveHttpHeaders.add("Server".toUpperCase());
        }
        if (this.preserveUserAgentHeader && !this.preserveHttpHeaders.contains("User-Agent".toUpperCase())) {
            this.preserveHttpHeaders.add("User-Agent".toUpperCase());
        }
    }
}

