/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.api;

import java.net.InetSocketAddress;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.apache.synapse.transport.passthru.core.PassThroughListeningIOReactorManager;
import org.apache.synapse.transport.passthru.core.ssl.SSLConfiguration;

public class PassThroughInboundEndpointHandler {
    public static boolean startEndpoint(InetSocketAddress inetSocketAddress, NHttpServerEventHandler nHttpServerEventHandler, String endpointName) {
        return PassThroughListeningIOReactorManager.getInstance().startDynamicPTTEndpoint(inetSocketAddress, nHttpServerEventHandler, endpointName);
    }

    public static boolean closeEndpoint(int port) {
        return PassThroughListeningIOReactorManager.getInstance().closeDynamicPTTEndpoint(port);
    }

    public static SourceConfiguration getPassThroughSourceConfiguration() throws Exception {
        SourceConfiguration sourceConfiguration = PassThroughListeningIOReactorManager.getInstance().getSharedPassThroughSourceConfiguration();
        if (sourceConfiguration != null) {
            return sourceConfiguration;
        }
        throw new Exception("PassThroughSharedListenerConfiguration  is not initiated correctly when  PassThroughListeners  are starting");
    }

    public static SourceConfiguration getPassThroughSSLSourceConfiguration() throws Exception {
        SourceConfiguration sourceConfiguration = PassThroughListeningIOReactorManager.getInstance().getSharedSSLPassThroughSourceConfiguration();
        if (sourceConfiguration != null) {
            return sourceConfiguration;
        }
        throw new Exception("PassThroughSharedListenerConfiguration  is not initiated correctly when  SSLPassThroughListeners  are starting");
    }

    public static boolean isEndpointRunning(int port) {
        return PassThroughListeningIOReactorManager.getInstance().isDynamicEndpointRunning(port);
    }

    public static boolean startSSLEndpoint(InetSocketAddress inetSocketAddress, NHttpServerEventHandler nHttpServerEventHandler, String endpointName, SSLConfiguration sslConfiguration) {
        return PassThroughListeningIOReactorManager.getInstance().startDynamicPTTSSLEndpoint(inetSocketAddress, nHttpServerEventHandler, endpointName, sslConfiguration);
    }
}

