/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpConnection;
import org.apache.synapse.transport.http.conn.LoggingNHttpClientConnection;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.TargetContext;
import org.apache.synapse.transport.passthru.config.TargetConfiguration;

public class TargetResponse {
    private Log log = LogFactory.getLog(TargetResponse.class);
    private Pipe pipe = null;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map excessHeaders = new MultiValueMap();
    private int status = 200;
    private String statusLine = "OK";
    private HttpResponse response = null;
    private TargetConfiguration targetConfiguration;
    private ProtocolVersion version = HttpVersion.HTTP_1_1;
    private ConnectionReuseStrategy connStrategy = new DefaultConnectionReuseStrategy();
    private NHttpClientConnection connection;
    private boolean expectResponseBody = true;
    private boolean forceShutdownConnectionOnComplete = false;
    private static final Log correlationLog = LogFactory.getLog((String)"correlation");
    private static final String KEEP_ALIVE_HEADER = "Keep-Alive";
    private static final String KEEP_ALIVE_TIMEOUT = "timeout=";

    public TargetResponse(TargetConfiguration targetConfiguration, HttpResponse response, NHttpClientConnection conn, boolean expectResponseBody, boolean forceShutdownConnectionOnComplete) {
        this.targetConfiguration = targetConfiguration;
        this.response = response;
        this.connection = conn;
        this.version = response.getProtocolVersion();
        this.status = response.getStatusLine().getStatusCode();
        this.statusLine = response.getStatusLine().getReasonPhrase();
        Header[] headers = response.getAllHeaders();
        if (headers != null) {
            for (Header header : headers) {
                String keepAlive;
                if (this.headers.containsKey(header.getName())) {
                    this.addExcessHeader(header);
                } else {
                    this.headers.put(header.getName(), header.getValue());
                }
                if (!header.getName().equalsIgnoreCase(KEEP_ALIVE_HEADER) || (keepAlive = header.getValue()) == null || !keepAlive.contains(KEEP_ALIVE_TIMEOUT)) continue;
                conn.getContext().setAttribute("CONNECTION_KEEP_ALIVE_TIME_OUT", (Object)this.getKeepAliveTimeout(keepAlive));
            }
        }
        this.expectResponseBody = expectResponseBody;
        this.forceShutdownConnectionOnComplete = forceShutdownConnectionOnComplete;
    }

    public void start(NHttpClientConnection conn) {
        TargetContext.updateState((NHttpConnection)conn, ProtocolState.RESPONSE_HEAD);
        if (this.expectResponseBody) {
            this.pipe = new Pipe((IOControl)conn, this.targetConfiguration.getBufferFactory().getBuffer(), "target", this.targetConfiguration);
            TargetContext.get((NHttpConnection)conn).setReader(this.pipe);
            BasicHttpEntity entity = new BasicHttpEntity();
            if (this.response.getStatusLine().getProtocolVersion().greaterEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
                entity.setChunked(true);
            }
            this.response.setEntity((HttpEntity)entity);
        } else if (!this.connStrategy.keepAlive(this.response, conn.getContext()) || this.forceShutdownConnectionOnComplete) {
            try {
                TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
                this.targetConfiguration.getConnections().shutdownConnection(conn);
            }
            catch (Exception exception) {}
        } else {
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.RESPONSE_DONE);
            this.targetConfiguration.getConnections().releaseConnection(conn);
        }
    }

    public int read(NHttpClientConnection conn, ContentDecoder decoder) throws IOException {
        int bytes = 0;
        if (this.pipe != null) {
            bytes = this.pipe.produce(decoder);
        }
        this.readPostActions(conn, decoder);
        return bytes;
    }

    public ByteBuffer copyAndRead(NHttpClientConnection conn, ContentDecoder decoder) throws IOException {
        ByteBuffer bufferCopy = null;
        if (this.pipe != null) {
            bufferCopy = this.pipe.copyAndProduce(decoder);
        }
        this.readPostActions(conn, decoder);
        return bufferCopy;
    }

    private void readPostActions(NHttpClientConnection conn, ContentDecoder decoder) {
        if (decoder.isCompleted()) {
            conn.getContext().setAttribute("RES_FROM_BACKEND_READ_END_TIME", (Object)System.currentTimeMillis());
            conn.getContext().setAttribute("RES_ARRIVAL_TIME", (Object)System.currentTimeMillis());
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.RESPONSE_DONE);
            this.targetConfiguration.getMetrics().notifyReceivedMessageSize(conn.getMetrics().getReceivedBytesCount());
            if (!this.connStrategy.keepAlive(this.response, conn.getContext()) || this.forceShutdownConnectionOnComplete) {
                TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
                this.targetConfiguration.getConnections().shutdownConnection(conn);
            } else if (conn instanceof LoggingNHttpClientConnection) {
                ((LoggingNHttpClientConnection)conn).setReleaseConn(true);
            }
        }
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map getExcessHeaders() {
        return this.excessHeaders;
    }

    public void addExcessHeader(Header h) {
        this.excessHeaders.put(h.getName(), h.getValue());
    }

    public Pipe getPipe() {
        return this.pipe;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusLine() {
        return this.statusLine;
    }

    public boolean isExpectResponseBody() {
        return this.expectResponseBody;
    }

    public NHttpClientConnection getConnection() {
        return this.connection;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    private int getKeepAliveTimeout(String keepAlive) {
        String timeout;
        int keepAliveTimeout = -1;
        try {
            timeout = keepAlive.split(KEEP_ALIVE_TIMEOUT)[1];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.log.error((Object)"Value is not specified in KeepAlive Timeout header.");
            return -1;
        }
        int commaIndex = timeout.indexOf(44);
        if (commaIndex != -1) {
            timeout = timeout.substring(0, commaIndex);
        }
        try {
            keepAliveTimeout = Integer.parseInt(timeout) * 1000;
        }
        catch (NumberFormatException e) {
            this.log.error((Object)("Error parsing value " + timeout + " as connection keep-alive timeout."), (Throwable)e);
        }
        return keepAliveTimeout;
    }
}

