/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.synapse.transport.nhttp.util.MessageFormatterDecoratorFactory;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.TargetContext;
import org.apache.synapse.transport.passthru.config.TargetConfiguration;
import org.apache.synapse.transport.passthru.util.PassThroughTransportUtils;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.apache.synapse.transport.passthru.util.TargetRequestFactory;

public class TargetRequest {
    private TargetConfiguration targetConfiguration;
    private HttpRoute route;
    private Pipe pipe = null;
    private Map<String, LinkedHashSet<String>> headers = new HashMap<String, LinkedHashSet<String>>();
    private URL url;
    private String method;
    private HttpRequest request = null;
    private boolean chunk = true;
    private ProtocolVersion version = null;
    private boolean fullUrl = false;
    private int port = 80;
    private boolean hasEntityBody = true;
    private boolean keepAlive = true;
    private static final Log correlationLog = LogFactory.getLog((String)"correlation");

    public TargetRequest(TargetConfiguration targetConfiguration, HttpRoute route, URL url, String method, boolean hasEntityBody) {
        this(targetConfiguration, route, method, url, hasEntityBody);
    }

    public TargetRequest(TargetConfiguration targetConfiguration, HttpRoute route, String method, URL url, boolean hasEntityBody) {
        this.route = route;
        this.method = method;
        this.url = url;
        this.targetConfiguration = targetConfiguration;
        this.hasEntityBody = hasEntityBody;
    }

    public void connect(Pipe pipe) {
        this.pipe = pipe;
    }

    public void start(NHttpClientConnection conn) throws IOException, HttpException {
        Map _headers;
        String trpContentType;
        Object o;
        MessageContext requestMsgCtx;
        if (this.pipe != null) {
            TargetContext.get((NHttpConnection)conn).setWriter(this.pipe);
        }
        String path = this.fullUrl || this.route.getProxyHost() != null && !this.route.isTunnelled() ? this.url.toString() : this.url.getPath() + (this.url.getQuery() != null ? "?" + this.url.getQuery() : "");
        long contentLength = -1L;
        String contentLengthHeader = null;
        LinkedHashSet<String> httpContentLengthHeader = this.headers.get("Content-Length");
        if (httpContentLengthHeader != null && httpContentLengthHeader.iterator().hasNext()) {
            contentLengthHeader = (String)httpContentLengthHeader.iterator().next();
        }
        if (contentLengthHeader != null) {
            contentLength = Long.parseLong(contentLengthHeader);
            this.headers.remove("Content-Length");
        }
        if ((requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx()).getProperty("PASSTROUGH_MESSAGE_LENGTH") != null) {
            contentLength = (Long)requestMsgCtx.getProperty("PASSTROUGH_MESSAGE_LENGTH");
        }
        if (requestMsgCtx.isPropertyTrue("POST_TO_URI")) {
            path = this.url.toString();
        }
        if ("GET".equals(requestMsgCtx.getProperty("HTTP_METHOD")) || RelayUtils.isDeleteRequestWithoutPayload(requestMsgCtx)) {
            this.hasEntityBody = false;
            MessageFormatter formatter = MessageProcessorSelector.getMessageFormatter((MessageContext)requestMsgCtx);
            OMOutputFormat format = PassThroughTransportUtils.getOMOutputFormat(requestMsgCtx);
            if (formatter != null && format != null) {
                URL _url = formatter.getTargetAddress(requestMsgCtx, format, this.url);
                if (_url != null && !_url.toString().isEmpty()) {
                    path = requestMsgCtx.getProperty("POST_TO_URI") != null && Boolean.TRUE.toString().equals(requestMsgCtx.getProperty("POST_TO_URI")) ? _url.toString() : _url.getPath() + (_url.getQuery() != null && !_url.getQuery().isEmpty() ? "?" + _url.getQuery() : "");
                }
                this.headers.remove("Content-Type");
            }
        }
        if ((o = requestMsgCtx.getProperty("TRANSPORT_HEADERS")) != null && o instanceof TreeMap && (trpContentType = (String)(_headers = (Map)o).get("Content-Type")) != null && !trpContentType.equals("") && !TargetRequestFactory.isMultipartContent(trpContentType)) {
            this.addHeader("Content-Type", trpContentType);
        }
        if (this.hasEntityBody) {
            this.request = new BasicHttpEntityEnclosingRequest(this.method, path, (ProtocolVersion)(this.version != null ? this.version : HttpVersion.HTTP_1_1));
            BasicHttpEntity entity = new BasicHttpEntity();
            boolean forceContentLength = requestMsgCtx.isPropertyTrue("FORCE_HTTP_CONTENT_LENGTH");
            boolean forceContentLengthCopy = requestMsgCtx.isPropertyTrue("COPY_CONTENT_LENGTH_FROM_INCOMING");
            if (forceContentLength) {
                entity.setChunked(false);
                if (forceContentLengthCopy && contentLength != -1L) {
                    entity.setContentLength(contentLength);
                }
            } else if (contentLength != -1L) {
                entity.setChunked(false);
                entity.setContentLength(contentLength);
            } else {
                entity.setChunked(this.chunk);
            }
            ((BasicHttpEntityEnclosingRequest)this.request).setEntity((HttpEntity)entity);
        } else {
            this.request = new BasicHttpRequest(this.method, path, (ProtocolVersion)(this.version != null ? this.version : HttpVersion.HTTP_1_1));
        }
        Set<Map.Entry<String, LinkedHashSet<String>>> entries = this.headers.entrySet();
        for (Map.Entry<String, LinkedHashSet<String>> entry : entries) {
            if (entry.getKey() == null) continue;
            Iterator i = entry.getValue().iterator();
            while (i.hasNext()) {
                this.request.addHeader(entry.getKey(), (String)i.next());
            }
        }
        if (this.request != null) {
            String soapAction = requestMsgCtx.getSoapAction();
            if (soapAction == null) {
                soapAction = requestMsgCtx.getWSAAction();
                requestMsgCtx.getAxisOperation().getInputAction();
            }
            if (requestMsgCtx.isSOAP11() && soapAction != null && soapAction.length() > 0) {
                Header existingHeader = this.request.getFirstHeader("SOAPAction");
                if (existingHeader != null) {
                    this.request.removeHeader(existingHeader);
                }
                MessageFormatter messageFormatter = MessageFormatterDecoratorFactory.createMessageFormatterDecorator(requestMsgCtx);
                this.request.setHeader("SOAPAction", messageFormatter.formatSOAPAction(requestMsgCtx, null, soapAction));
            }
        }
        this.request.setParams((HttpParams)new DefaultedHttpParams(this.request.getParams(), this.targetConfiguration.getHttpParams()));
        if (!this.request.getProtocolVersion().equals((Object)HttpVersion.HTTP_1_0) && !"GET".equals(requestMsgCtx.getProperty("HTTP_METHOD")) && !RelayUtils.isDeleteRequestWithoutPayload(requestMsgCtx) && this.hasEntityBody) {
            this.processChunking(conn, requestMsgCtx);
        }
        if (!this.keepAlive) {
            this.request.setHeader("Connection", "Close");
        }
        HttpContext httpContext = conn.getContext();
        httpContext.setAttribute("http.connection", (Object)conn);
        if (this.port == -1) {
            httpContext.setAttribute("http.target_host", (Object)new HttpHost(this.url.getHost()));
        } else {
            httpContext.setAttribute("http.target_host", (Object)new HttpHost(this.url.getHost(), this.port));
        }
        conn.getContext().setAttribute("http.request", (Object)this.request);
        httpContext.setAttribute("PROXY_PROFILE_TARGET_HOST", requestMsgCtx.getProperty("PROXY_PROFILE_TARGET_HOST"));
        this.targetConfiguration.getHttpProcessor().process(this.request, httpContext);
        if (this.targetConfiguration.getProxyAuthenticator() != null && this.route.getProxyHost() != null && !this.route.isTunnelled()) {
            this.targetConfiguration.getProxyAuthenticator().authenticatePreemptively(this.request, httpContext);
        }
        conn.submitRequest(this.request);
        if (this.hasEntityBody) {
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_HEAD);
        } else {
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_DONE);
        }
    }

    private void processChunking(NHttpClientConnection conn, MessageContext requestMsgCtx) throws IOException, AxisFault {
        String disableChunking = (String)requestMsgCtx.getProperty("DISABLE_CHUNKING");
        String forceHttp10 = (String)requestMsgCtx.getProperty("FORCE_HTTP_1.0");
        if (("true".equals(disableChunking) || "true".equals(forceHttp10)) && requestMsgCtx.getEnvelope().getBody().getFirstElement() == null) {
            BasicHttpEntity entity = (BasicHttpEntity)((BasicHttpEntityEnclosingRequest)this.request).getEntity();
            try {
                RelayUtils.buildMessage(requestMsgCtx);
                this.hasEntityBody = true;
                Pipe pipe = (Pipe)requestMsgCtx.getProperty("pass-through.pipe");
                if (pipe != null) {
                    pipe.attachConsumer((IOControl)conn);
                    this.connect(pipe);
                    if (Boolean.TRUE.equals(requestMsgCtx.getProperty("message.builder.invoked"))) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        MessageFormatter formatter = MessageProcessorSelector.getMessageFormatter((MessageContext)requestMsgCtx);
                        OMOutputFormat format = PassThroughTransportUtils.getOMOutputFormat(requestMsgCtx);
                        formatter.writeTo(requestMsgCtx, format, (OutputStream)out, false);
                        OutputStream _out = pipe.getOutputStream();
                        IOUtils.write((byte[])out.toByteArray(), (OutputStream)_out);
                        entity.setContentLength(new Long(out.toByteArray().length).longValue());
                        entity.setChunked(false);
                    }
                }
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
    }

    public int write(NHttpClientConnection conn, ContentEncoder encoder) throws IOException {
        int bytes = 0;
        if (this.pipe != null) {
            bytes = this.pipe.consume(encoder);
        }
        this.writePostActions(conn, encoder);
        return bytes;
    }

    public ByteBuffer copyAndWrite(NHttpClientConnection conn, ContentEncoder encoder) throws IOException {
        ByteBuffer bufferCopy = null;
        if (this.pipe != null) {
            bufferCopy = this.pipe.copyAndConsume(encoder);
        }
        this.writePostActions(conn, encoder);
        return bufferCopy;
    }

    private void writePostActions(NHttpClientConnection conn, ContentEncoder encoder) {
        if (encoder.isCompleted()) {
            conn.getContext().setAttribute("REQ_DEPARTURE_TIME", (Object)System.currentTimeMillis());
            conn.getContext().setAttribute("REQ_TO_BACKEND_WRITE_END_TIME", (Object)System.currentTimeMillis());
            this.targetConfiguration.getMetrics().notifySentMessageSize(conn.getMetrics().getSentBytesCount());
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_DONE);
        }
    }

    public boolean hasEntityBody() {
        return this.hasEntityBody;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setHasEntityBody(boolean hasEntityBody) {
        this.hasEntityBody = hasEntityBody;
    }

    public Map<String, LinkedHashSet<String>> getHeaders() {
        return this.headers;
    }

    public void addHeader(String name, String value) {
        if (this.headers.get(name) == null) {
            LinkedHashSet<String> values = new LinkedHashSet<String>();
            values.add(value);
            if ("Content-Type".equalsIgnoreCase(name)) {
                this.headers.put("Content-Type", values);
            } else {
                this.headers.put(name, values);
            }
        } else if ("Content-Type".equalsIgnoreCase(name)) {
            this.headers.remove("Content-Type");
            LinkedHashSet<String> values = new LinkedHashSet<String>();
            values.add(value);
            this.headers.put("Content-Type", values);
        } else {
            LinkedHashSet<String> values = this.headers.get(name);
            values.add(value);
        }
    }

    public String getMethod() {
        return this.method;
    }

    public void setChunk(boolean chunk) {
        this.chunk = chunk;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setFullUrl(boolean fullUrl) {
        this.fullUrl = fullUrl;
    }

    public void setVersion(ProtocolVersion version) {
        this.version = version;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public HttpRoute getRoute() {
        return this.route;
    }

    public Pipe getPipe() {
        return this.pipe;
    }
}

