/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.protocol.HttpContext;
import org.apache.synapse.commons.logger.ContextAwareLogger;
import org.apache.synapse.commons.util.MiscellaneousUtil;
import org.apache.synapse.transport.http.conn.ClientConnFactory;
import org.apache.synapse.transport.http.conn.LoggingNHttpClientConnection;
import org.apache.synapse.transport.http.conn.ProxyTunnelHandler;
import org.apache.synapse.transport.passthru.ClientWorker;
import org.apache.synapse.transport.passthru.DeliveryAgent;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.SourceContext;
import org.apache.synapse.transport.passthru.StreamInterceptor;
import org.apache.synapse.transport.passthru.TargetContext;
import org.apache.synapse.transport.passthru.TargetErrorHandler;
import org.apache.synapse.transport.passthru.TargetRequest;
import org.apache.synapse.transport.passthru.TargetResponse;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.transport.passthru.config.TargetConfiguration;
import org.apache.synapse.transport.passthru.connections.HostConnections;
import org.apache.synapse.transport.passthru.jmx.PassThroughTransportMetricsCollector;

public class TargetHandler
implements NHttpClientEventHandler {
    private static Log log = LogFactory.getLog(TargetHandler.class);
    private static final Log correlationLog = LogFactory.getLog((String)"correlation");
    private final DeliveryAgent deliveryAgent;
    private ClientConnFactory connFactory;
    private final TargetConfiguration targetConfiguration;
    private final TargetErrorHandler targetErrorHandler;
    private PassThroughTransportMetricsCollector metrics = null;
    private static boolean isMessageSizeValidationEnabled = false;
    private static int validMaxMessageSize = Integer.MAX_VALUE;
    public static final String PROPERTY_FILE = "passthru-http.properties";
    public static final String MESSAGE_SIZE_VALIDATION = "message.size.validation.enabled";
    public static final String VALID_MAX_MESSAGE_SIZE = "valid.max.message.size.in.bytes";
    private List<StreamInterceptor> streamInterceptors;
    private boolean interceptStream;
    private int noOfInterceptors;
    private static List<String> allowedResponseProperties = new ArrayList<String>();

    public TargetHandler(DeliveryAgent deliveryAgent, ClientConnFactory connFactory, TargetConfiguration configuration) {
        this(deliveryAgent, connFactory, configuration, new ArrayList<StreamInterceptor>());
    }

    public TargetHandler(DeliveryAgent deliveryAgent, ClientConnFactory connFactory, TargetConfiguration configuration, List<StreamInterceptor> interceptors) {
        this.deliveryAgent = deliveryAgent;
        this.connFactory = connFactory;
        this.targetConfiguration = configuration;
        this.targetErrorHandler = new TargetErrorHandler(this.targetConfiguration);
        this.metrics = this.targetConfiguration.getMetrics();
        this.streamInterceptors = interceptors;
        this.interceptStream = !this.streamInterceptors.isEmpty();
        this.noOfInterceptors = this.streamInterceptors.size();
        Properties props = MiscellaneousUtil.loadProperties((String)PROPERTY_FILE);
        String validationProperty = MiscellaneousUtil.getProperty((Properties)props, (String)MESSAGE_SIZE_VALIDATION, (String)"false");
        String validMaxMessageSizeStr = MiscellaneousUtil.getProperty((Properties)props, (String)VALID_MAX_MESSAGE_SIZE, (String)String.valueOf(Integer.MAX_VALUE));
        isMessageSizeValidationEnabled = Boolean.valueOf(validationProperty);
        try {
            validMaxMessageSize = Integer.valueOf(validMaxMessageSizeStr);
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Invalid max message size configured for property \"valid.max.message.size.in.bytes\", setting the Integer MAX_VALUE as the valid maximum message size", (Throwable)e);
            validMaxMessageSize = Integer.MAX_VALUE;
        }
        PassThroughConfiguration conf = PassThroughConfiguration.getInstance();
        String properties = conf.getAllowedResponseProperties();
        if (properties != null) {
            String[] propertyList;
            for (String property : propertyList = properties.trim().split(",")) {
                allowedResponseProperties.add(property.trim());
            }
        }
    }

    public void connected(NHttpClientConnection conn, Object o) {
        assert (o instanceof HostConnections) : "Attachment should be a HostConnections";
        HostConnections pool = (HostConnections)o;
        conn.getContext().setAttribute("CONNECTION_POOL", (Object)pool);
        HttpRoute route = pool.getRoute();
        TargetContext.create((NHttpConnection)conn, ProtocolState.REQUEST_READY, this.targetConfiguration);
        this.targetConfiguration.getConnections().addConnection(conn);
        this.deliveryAgent.connected(pool.getRoute(), conn);
        HttpContext context = conn.getContext();
        context.setAttribute("REQ_DEPARTURE_TIME", (Object)System.currentTimeMillis());
        this.metrics.connected();
        if (route.isTunnelled()) {
            ProxyTunnelHandler tunnelHandler = new ProxyTunnelHandler(route, this.connFactory);
            context.setAttribute("TUNNEL_HANDLER", (Object)tunnelHandler);
        }
    }

    public void requestReady(NHttpClientConnection conn) {
        block11: {
            HttpContext context = conn.getContext();
            ProtocolState connState = null;
            try {
                connState = TargetContext.getState((NHttpConnection)conn);
                if (connState == ProtocolState.REQUEST_DONE || connState == ProtocolState.RESPONSE_BODY) {
                    return;
                }
                if (connState != ProtocolState.REQUEST_READY) {
                    this.handleInvalidState(conn, "Request not started");
                    return;
                }
                ProxyTunnelHandler tunnelHandler = (ProxyTunnelHandler)context.getAttribute("TUNNEL_HANDLER");
                if (tunnelHandler != null && !tunnelHandler.isCompleted()) {
                    Object targetHost = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx().getProperty("PROXY_PROFILE_TARGET_HOST");
                    context.setAttribute("PROXY_PROFILE_TARGET_HOST", targetHost);
                    if (!tunnelHandler.isRequested()) {
                        HttpRequest request = tunnelHandler.generateRequest(context);
                        if (this.targetConfiguration.getProxyAuthenticator() != null) {
                            this.targetConfiguration.getProxyAuthenticator().authenticatePreemptively(request, context);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(conn + ": Sending CONNECT request to " + tunnelHandler.getProxy()));
                        }
                        conn.submitRequest(request);
                        tunnelHandler.setRequested();
                    }
                    return;
                }
                TargetRequest request = TargetContext.getRequest((NHttpConnection)conn);
                if (request != null) {
                    TargetContext targetContext = TargetContext.get((NHttpConnection)conn);
                    targetContext.updateLastStateUpdatedTime();
                    request.start(conn);
                    this.targetConfiguration.getMetrics().incrementMessagesSent();
                }
                context.setAttribute("REQ_TO_BACKEND_WRITE_START_TIME", (Object)System.currentTimeMillis());
                context.setAttribute("REQ_DEPARTURE_TIME", (Object)System.currentTimeMillis());
            }
            catch (IOException e) {
                this.logIOException(conn, e);
                TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
                this.targetConfiguration.getConnections().shutdownConnection(conn, true);
                MessageContext requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx();
                if (requestMsgCtx != null) {
                    requestMsgCtx.setProperty("_INTERNAL_EXCEPTION_ORIGIN", (Object)"TARGET_ERROR_HANDLER");
                    this.targetErrorHandler.handleError(requestMsgCtx, 101500, "Error in Sender", null, connState);
                }
            }
            catch (HttpException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
                this.targetConfiguration.getConnections().shutdownConnection(conn, true);
                MessageContext requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx();
                if (requestMsgCtx == null) break block11;
                requestMsgCtx.setProperty("_INTERNAL_EXCEPTION_ORIGIN", (Object)"TARGET_ERROR_HANDLER");
                this.targetErrorHandler.handleError(requestMsgCtx, 102510, "Error in Sender", null, connState);
            }
        }
    }

    public void outputReady(NHttpClientConnection conn, ContentEncoder encoder) {
        block21: {
            ProtocolState connState = null;
            MessageContext requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx();
            try {
                connState = TargetContext.getState((NHttpConnection)conn);
                if (connState != ProtocolState.REQUEST_HEAD && connState != ProtocolState.REQUEST_DONE) {
                    this.handleInvalidState(conn, "Writing message body");
                    return;
                }
                TargetRequest request = TargetContext.getRequest((NHttpConnection)conn);
                if (request.hasEntityBody()) {
                    int bytesWritten = -1;
                    boolean interceptionEnabled = false;
                    Boolean[] interceptorResults = new Boolean[this.noOfInterceptors];
                    if (this.interceptStream) {
                        int index = 0;
                        for (StreamInterceptor interceptor : this.streamInterceptors) {
                            interceptorResults[index] = interceptor.interceptTargetRequest((MessageContext)conn.getContext().getAttribute("REQUEST_MESSAGE_CONTEXT"));
                            if (!interceptionEnabled && interceptorResults[index].booleanValue()) {
                                interceptionEnabled = true;
                            }
                            ++index;
                        }
                        if (interceptionEnabled) {
                            ByteBuffer bytesSent = request.copyAndWrite(conn, encoder);
                            if (bytesSent != null) {
                                bytesWritten = bytesSent.remaining();
                                index = 0;
                                for (StreamInterceptor interceptor : this.streamInterceptors) {
                                    if (interceptorResults[index].booleanValue()) {
                                        interceptor.targetRequest(bytesSent.duplicate().asReadOnlyBuffer(), (MessageContext)conn.getContext().getAttribute("REQUEST_MESSAGE_CONTEXT"));
                                    }
                                    ++index;
                                }
                            }
                        } else {
                            bytesWritten = request.write(conn, encoder);
                        }
                    } else {
                        bytesWritten = request.write(conn, encoder);
                    }
                    if (bytesWritten > 0) {
                        if (this.metrics.getLevel() == 2) {
                            this.metrics.incrementBytesSent(requestMsgCtx, bytesWritten);
                        } else {
                            this.metrics.incrementBytesSent(bytesWritten);
                        }
                    }
                    if (encoder.isCompleted()) {
                        if (this.metrics.getLevel() == 2) {
                            this.metrics.incrementMessagesSent(requestMsgCtx);
                        } else {
                            this.metrics.incrementMessagesSent();
                        }
                    }
                }
            }
            catch (IOException ex) {
                this.logIOException(conn, ex);
                TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
                this.targetConfiguration.getConnections().shutdownConnection(conn, true);
                this.informWriterError(conn);
                if (requestMsgCtx != null) {
                    requestMsgCtx.setProperty("_INTERNAL_EXCEPTION_ORIGIN", (Object)"TARGET_ERROR_HANDLER");
                    this.targetErrorHandler.handleError(requestMsgCtx, 102510, "Error in Sender", null, connState);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error occurred while writing data to the target", (Throwable)e);
                TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
                this.targetConfiguration.getConnections().shutdownConnection(conn, true);
                this.informWriterError(conn);
                if (requestMsgCtx == null) break block21;
                requestMsgCtx.setProperty("_INTERNAL_EXCEPTION_ORIGIN", (Object)"TARGET_ERROR_HANDLER");
                this.targetErrorHandler.handleError(requestMsgCtx, 102510, "Error in Sender", null, connState);
            }
        }
    }

    public void responseReceived(NHttpClientConnection conn) {
        HttpContext context = conn.getContext();
        if (isMessageSizeValidationEnabled) {
            context.setAttribute("MESSAGE_SIZE_VALIDATION_SUM", (Object)0);
        }
        HttpResponse response = conn.getHttpResponse();
        try {
            boolean canResponseHaveBody;
            int statusCode;
            String method = null;
            ProxyTunnelHandler tunnelHandler = (ProxyTunnelHandler)context.getAttribute("TUNNEL_HANDLER");
            if (tunnelHandler != null && !tunnelHandler.isCompleted()) {
                method = "CONNECT";
                context.removeAttribute("TUNNEL_HANDLER");
                tunnelHandler.handleResponse(response, conn);
                if (tunnelHandler.isSuccessful()) {
                    log.debug((Object)(conn + ": Tunnel established"));
                    conn.resetInput();
                    conn.requestOutput();
                    return;
                }
                log.warn((Object)"Tunnel response failed");
                TargetRequest targetRequest = TargetContext.getRequest((NHttpConnection)conn);
                if (targetRequest != null) {
                    targetRequest.getPipe().consumerError();
                } else {
                    log.warn((Object)"Failed target response, but the target request is null");
                }
                TargetContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_DONE);
            }
            if ((statusCode = response.getStatusLine().getStatusCode()) < 200) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(conn + ": Received a 100 Continue response"));
                }
                return;
            }
            context.setAttribute("RES_HEADER_ARRIVAL_TIME", (Object)System.currentTimeMillis());
            ProtocolState connState = TargetContext.getState((NHttpConnection)conn);
            if (this.targetConfiguration.isCorrelationLoggingEnabled().booleanValue() && TargetContext.isCorrelationIdAvailable((NHttpConnection)conn).booleanValue()) {
                long startTime = (Long)context.getAttribute("REQ_TO_BACKEND_WRITE_START_TIME");
                ContextAwareLogger.getLogger((HttpContext)context, (Log)correlationLog, (boolean)false).info((Object)(System.currentTimeMillis() - startTime + "|HTTP|" + TargetContext.getRequest((NHttpConnection)conn).getUrl().toString() + "|BACKEND LATENCY"));
            }
            boolean isError = false;
            if (connState != ProtocolState.REQUEST_DONE) {
                isError = true;
                this.informWriterError(conn);
                StatusLine errorStatus = response.getStatusLine();
                if (errorStatus != null) {
                    if (errorStatus.getStatusCode() >= 400) {
                        MessageContext requestMsgContext;
                        TargetContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_DONE);
                        conn.resetOutput();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(conn + ": Received response with status code : " + response.getStatusLine().getStatusCode() + " in invalid state : " + connState.name()));
                        }
                        if ((requestMsgContext = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx()) != null) {
                            NHttpServerConnection sourceConn = (NHttpServerConnection)requestMsgContext.getProperty("pass-through.Source-Connection");
                            if (sourceConn != null) {
                                SourceContext.updateState((NHttpConnection)sourceConn, ProtocolState.REQUEST_DONE);
                                SourceContext.get((NHttpConnection)sourceConn).setShutDown(true);
                            }
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(conn + ": has not started any request"));
                            }
                            if (statusCode == 408) {
                                return;
                            }
                        }
                    }
                } else {
                    this.handleInvalidState(conn, "Receiving response");
                    return;
                }
            }
            context.setAttribute("RES_FROM_BACKEND_READ_START_TIME", (Object)System.currentTimeMillis());
            TargetRequest targetRequest = TargetContext.getRequest((NHttpConnection)conn);
            if (targetRequest != null) {
                method = targetRequest.getMethod();
            }
            if (!(canResponseHaveBody = this.isResponseHaveBodyExpected(method, response))) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(conn + ": Received no-content response " + response.getStatusLine().getStatusCode()));
                }
                conn.resetInput();
            }
            TargetResponse targetResponse = new TargetResponse(this.targetConfiguration, response, conn, canResponseHaveBody, isError);
            TargetContext.setResponse((NHttpConnection)conn, targetResponse);
            targetResponse.start(conn);
            MessageContext requestMsgContext = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx();
            if (statusCode == 202 && this.handle202(requestMsgContext)) {
                return;
            }
            this.targetConfiguration.getWorkerPool().execute((Runnable)new ClientWorker(this.targetConfiguration, requestMsgContext, targetResponse, allowedResponseProperties));
            this.targetConfiguration.getMetrics().incrementMessagesReceived();
            NHttpServerConnection sourceConn = (NHttpServerConnection)requestMsgContext.getProperty("pass-through.Source-Connection");
            if (sourceConn != null) {
                sourceConn.getContext().setAttribute("RES_HEADER_ARRIVAL_TIME", conn.getContext().getAttribute("RES_HEADER_ARRIVAL_TIME"));
                conn.getContext().removeAttribute("RES_HEADER_ARRIVAL_TIME");
                sourceConn.getContext().setAttribute("REQ_DEPARTURE_TIME", conn.getContext().getAttribute("REQ_DEPARTURE_TIME"));
                conn.getContext().removeAttribute("REQ_DEPARTURE_TIME");
                sourceConn.getContext().setAttribute("REQ_TO_BACKEND_WRITE_START_TIME", conn.getContext().getAttribute("REQ_TO_BACKEND_WRITE_START_TIME"));
                conn.getContext().removeAttribute("REQ_TO_BACKEND_WRITE_START_TIME");
                sourceConn.getContext().setAttribute("REQ_TO_BACKEND_WRITE_END_TIME", conn.getContext().getAttribute("REQ_TO_BACKEND_WRITE_END_TIME"));
                conn.getContext().removeAttribute("REQ_TO_BACKEND_WRITE_END_TIME");
                sourceConn.getContext().setAttribute("RES_FROM_BACKEND_READ_START_TIME", conn.getContext().getAttribute("RES_FROM_BACKEND_READ_START_TIME"));
                conn.getContext().removeAttribute("RES_FROM_BACKEND_READ_START_TIME");
            }
        }
        catch (Exception ex) {
            log.error((Object)"Exception occurred while processing response", (Throwable)ex);
            this.informReaderError(conn);
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.targetConfiguration.getConnections().shutdownConnection(conn, true);
        }
    }

    private boolean handle202(MessageContext requestMsgContext) throws AxisFault {
        if (requestMsgContext.isPropertyTrue("IGNORE_SC_ACCEPTED")) {
            return true;
        }
        MessageReceiver mr = requestMsgContext.getAxisOperation().getMessageReceiver();
        MessageContext responseMsgCtx = requestMsgContext.getOperationContext().getMessageContext("In");
        if (responseMsgCtx == null || requestMsgContext.getOptions().isUseSeparateListener()) {
            requestMsgContext.setProperty("HTTP_202_RECEIVED", (Object)"true");
            mr.receive(requestMsgContext);
            return true;
        }
        return false;
    }

    private void dropTargetConnection(NHttpClientConnection conn) {
        try {
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            conn.close();
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.targetConfiguration.getConnections().shutdownConnection(conn, true);
        }
    }

    public void inputReady(NHttpClientConnection conn, ContentDecoder decoder) {
        MessageContext msgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx();
        try {
            ProtocolState connState = TargetContext.getState((NHttpConnection)conn);
            if (connState.compareTo(ProtocolState.RESPONSE_HEAD) < 0) {
                return;
            }
            if (connState != ProtocolState.RESPONSE_HEAD && connState != ProtocolState.RESPONSE_BODY) {
                this.handleInvalidState(conn, "Response received");
                return;
            }
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.RESPONSE_BODY);
            TargetResponse response = TargetContext.getResponse((NHttpConnection)conn);
            int statusCode = -1;
            if (response != null) {
                statusCode = conn.getHttpResponse().getStatusLine().getStatusCode();
                int responseRead = -1;
                boolean interceptionEnabled = false;
                Boolean[] interceptorResults = new Boolean[this.noOfInterceptors];
                if (this.interceptStream) {
                    int index = 0;
                    for (StreamInterceptor interceptor : this.streamInterceptors) {
                        interceptorResults[index] = interceptor.interceptTargetResponse((MessageContext)conn.getContext().getAttribute("RESPONSE_MESSAGE_CONTEXT"));
                        if (!interceptionEnabled && interceptorResults[index].booleanValue()) {
                            interceptionEnabled = true;
                        }
                        ++index;
                    }
                    if (interceptionEnabled) {
                        ByteBuffer bytesRead = response.copyAndRead(conn, decoder);
                        if (bytesRead != null) {
                            responseRead = bytesRead.remaining();
                            index = 0;
                            for (StreamInterceptor interceptor : this.streamInterceptors) {
                                boolean proceed;
                                if (interceptorResults[index].booleanValue() && !(proceed = interceptor.targetResponse(bytesRead.duplicate().asReadOnlyBuffer(), (MessageContext)conn.getContext().getAttribute("RESPONSE_MESSAGE_CONTEXT")))) {
                                    log.info((Object)("Dropping target connection since request is blocked by : " + interceptor.getClass().getName()));
                                    this.dropTargetConnection(conn);
                                    response.getPipe().forceProducerComplete(decoder);
                                    break;
                                }
                                ++index;
                            }
                        }
                    } else {
                        responseRead = response.read(conn, decoder);
                    }
                } else {
                    responseRead = response.read(conn, decoder);
                }
                if (isMessageSizeValidationEnabled) {
                    HttpContext httpContext = conn.getContext();
                    if (httpContext.getAttribute("MESSAGE_SIZE_VALIDATION_SUM") == null) {
                        httpContext.setAttribute("MESSAGE_SIZE_VALIDATION_SUM", (Object)0);
                    }
                    int messageSizeSum = (Integer)httpContext.getAttribute("MESSAGE_SIZE_VALIDATION_SUM");
                    if ((messageSizeSum += responseRead) > validMaxMessageSize) {
                        log.warn((Object)("Payload exceeds valid payload size range, hence discontinuing chunk stream at " + messageSizeSum + " bytes to prevent OOM."));
                        this.dropTargetConnection(conn);
                        response.getPipe().forceProducerComplete(decoder);
                    }
                    httpContext.setAttribute("MESSAGE_SIZE_VALIDATION_SUM", (Object)messageSizeSum);
                }
                if (this.metrics.getLevel() == 2) {
                    this.metrics.incrementBytesReceived(msgCtx, responseRead);
                } else {
                    this.metrics.incrementBytesReceived(responseRead);
                }
            }
            if (decoder.isCompleted()) {
                MessageContext requestMsgContext;
                NHttpServerConnection sourceConn;
                if (this.metrics.getLevel() == 2) {
                    this.metrics.incrementMessagesReceived(msgCtx);
                    this.metrics.notifyReceivedMessageSize(msgCtx, conn.getMetrics().getReceivedBytesCount());
                    this.metrics.notifySentMessageSize(msgCtx, conn.getMetrics().getSentBytesCount());
                    if (statusCode != -1) {
                        this.metrics.reportResponseCode(msgCtx, statusCode);
                    }
                } else {
                    this.metrics.incrementMessagesReceived();
                    this.metrics.notifyReceivedMessageSize(conn.getMetrics().getReceivedBytesCount());
                    this.metrics.notifySentMessageSize(conn.getMetrics().getSentBytesCount());
                }
                if ((sourceConn = (NHttpServerConnection)(requestMsgContext = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx()).getProperty("pass-through.Source-Connection")) != null) {
                    if (conn.getContext().getAttribute("RES_FROM_BACKEND_READ_END_TIME") != null) {
                        sourceConn.getContext().setAttribute("RES_FROM_BACKEND_READ_END_TIME", conn.getContext().getAttribute("RES_FROM_BACKEND_READ_END_TIME"));
                        conn.getContext().removeAttribute("RES_FROM_BACKEND_READ_END_TIME");
                    }
                    sourceConn.getContext().setAttribute("RES_ARRIVAL_TIME", conn.getContext().getAttribute("RES_ARRIVAL_TIME"));
                    conn.getContext().removeAttribute("RES_ARRIVAL_TIME");
                }
            }
        }
        catch (IOException e) {
            this.logException(conn, e);
            this.logIOException(conn, e);
            this.informReaderError(conn);
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.targetConfiguration.getConnections().shutdownConnection(conn, true);
        }
        catch (Exception ex) {
            log.error((Object)"Exception occurred while reading request body", (Throwable)ex);
            this.informReaderError(conn);
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.targetConfiguration.getConnections().shutdownConnection(conn, true);
        }
    }

    private void logException(NHttpClientConnection conn, Exception e) {
        ProtocolState state = TargetContext.getState((NHttpConnection)conn);
        if (state != null) {
            MessageContext requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx();
            Map<String, String> logDetails = this.getLoggingInfo(conn, state, requestMsgCtx, e);
            log.warn((Object)("ERROR_CODE = " + logDetails.get("error_code") + ", STATE_DESCRIPTION = Exception occurred " + logDetails.get("state_description") + ", INTERNAL_STATE = " + (Object)((Object)state) + ", DIRECTION = " + logDetails.get("direction") + ", CAUSE_OF_ERROR = " + logDetails.get("cause_of_error") + ", TARGET_HOST = " + logDetails.get("host") + ", TARGET_PORT = " + logDetails.get("port") + ", TARGET_CONTEXT = " + logDetails.get("url") + ", HTTP_METHOD = " + logDetails.get("method") + ", TRIGGER_TYPE = " + logDetails.get("trigger_type") + ", TRIGGER_NAME = " + logDetails.get("trigger_name") + ", REMOTE_ADDRESS = " + this.getBackEndConnectionInfo(conn) + ", CONNECTION = " + conn));
        }
    }

    public void closed(NHttpClientConnection conn) {
        ProtocolState state = TargetContext.getState((NHttpConnection)conn);
        MessageContext requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx();
        Map<String, String> logDetails = this.getLoggingInfo(conn, state, requestMsgCtx);
        boolean isFault = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Connection closed by target host while in state " + state.name() + ". Response code : " + conn.getStatus()));
        }
        if (state == ProtocolState.RESPONSE_DONE || state == ProtocolState.REQUEST_READY) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Keep-Alive Connection closed " + this.getConnectionLoggingInfo(conn)));
            }
        } else if (state == ProtocolState.REQUEST_HEAD || state == ProtocolState.REQUEST_BODY) {
            this.informWriterError(conn);
            log.warn((Object)("ERROR_CODE = 101505, STATE_DESCRIPTION = Connection closed by target host " + logDetails.get("state_description") + ", INTERNAL_STATE = " + (Object)((Object)state) + ", DIRECTION = " + logDetails.get("direction") + ", CAUSE_OF_ERROR = Connection between the Server and the BackEnd has been closed, TARGET_HOST = " + logDetails.get("host") + ", TARGET_PORT = " + logDetails.get("port") + ", TARGET_CONTEXT = " + logDetails.get("url") + ", HTTP_METHOD = " + logDetails.get("method") + ", TRIGGER_TYPE = " + logDetails.get("trigger_type") + ", TRIGGER_NAME = " + logDetails.get("trigger_name") + ", REMOTE_ADDRESS = " + this.getBackEndConnectionInfo(conn) + ", CONNECTION = " + conn));
            isFault = true;
        } else if (state == ProtocolState.RESPONSE_HEAD || state == ProtocolState.RESPONSE_BODY) {
            this.informReaderError(conn);
            log.warn((Object)("ERROR_CODE = 101505, STATE_DESCRIPTION = Connection closed by target host " + logDetails.get("state_description") + ", INTERNAL_STATE = " + (Object)((Object)state) + ", DIRECTION = " + logDetails.get("direction") + ", CAUSE_OF_ERROR = Connection between the Server and the BackEnd has been closed, TARGET_HOST = " + logDetails.get("host") + ", TARGET_PORT = " + logDetails.get("port") + ", TARGET_CONTEXT = " + logDetails.get("url") + ", HTTP_METHOD = " + logDetails.get("method") + ", TRIGGER_TYPE = " + logDetails.get("trigger_type") + ", TRIGGER_NAME = " + logDetails.get("trigger_name") + ", REMOTE_ADDRESS = " + this.getBackEndConnectionInfo(conn) + ", CONNECTION = " + conn));
            isFault = true;
        } else if (state == ProtocolState.REQUEST_DONE) {
            log.warn((Object)("ERROR_CODE = 101505, STATE_DESCRIPTION = Connection closed by target host " + logDetails.get("state_description") + ", INTERNAL_STATE = " + (Object)((Object)state) + ", DIRECTION = " + logDetails.get("direction") + ", CAUSE_OF_ERROR = Connection between the Server and the BackEnd has been closed, TARGET_HOST = " + logDetails.get("host") + ", TARGET_PORT = " + logDetails.get("port") + ", TARGET_CONTEXT = " + logDetails.get("url") + ", HTTP_METHOD = " + logDetails.get("method") + ", TRIGGER_TYPE = " + logDetails.get("trigger_type") + ", TRIGGER_NAME = " + logDetails.get("trigger_name") + ", REMOTE_ADDRESS = " + this.getBackEndConnectionInfo(conn) + ", CONNECTION = " + conn));
            isFault = true;
        }
        if (isFault && requestMsgCtx != null) {
            requestMsgCtx.setProperty("_INTERNAL_EXCEPTION_ORIGIN", (Object)"TARGET_ERROR_HANDLER");
            this.targetErrorHandler.handleError(requestMsgCtx, 101505, "Error in Sender", null, state);
        }
        this.metrics.disconnected();
        TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
        this.targetConfiguration.getConnections().shutdownConnection(conn, isFault);
    }

    private void logIOException(NHttpClientConnection conn, IOException e) {
        String message = this.getErrorMessage("I/O error : " + e.getMessage(), conn);
        if (e instanceof ConnectionClosedException || e.getMessage() != null && e.getMessage().toLowerCase().contains("connection reset by peer") || e.getMessage().toLowerCase().contains("forcibly closed")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(conn + ": I/O error (Probably the keep-alive connection was closed):" + e.getMessage()));
            }
        } else if (e.getMessage() != null) {
            String msg = e.getMessage().toLowerCase();
            if (msg.indexOf("broken") != -1) {
                log.warn((Object)("I/O error (Probably the connection was closed by the remote party):" + e.getMessage()));
            } else {
                log.error((Object)("I/O error: " + e.getMessage()), (Throwable)e);
            }
        } else {
            log.error((Object)message, (Throwable)e);
        }
    }

    public void timeout(NHttpClientConnection conn) {
        ProtocolState state = TargetContext.getState((NHttpConnection)conn);
        MessageContext requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx();
        Map<String, String> logDetails = this.getLoggingInfo(conn, state, requestMsgCtx);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.getErrorMessage("Connection timeout", conn) + " " + this.getConnectionLoggingInfo(conn)));
        }
        if (state != null && (state == ProtocolState.REQUEST_READY || state == ProtocolState.RESPONSE_DONE)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.getErrorMessage("Keep-alive connection timed out", conn) + " " + this.getConnectionLoggingInfo(conn)));
            }
        } else if (state != null) {
            if (state == ProtocolState.REQUEST_BODY) {
                this.metrics.incrementTimeoutsSending();
                this.informWriterError(conn);
                log.warn((Object)("ERROR_CODE = 101504, STATE_DESCRIPTION = Socket Timeout occurred " + logDetails.get("state_description") + ", INTERNAL_STATE = " + (Object)((Object)state) + ", DIRECTION = " + logDetails.get("direction") + ", CAUSE_OF_ERROR = Connection between the EI and the BackEnd timeouts, TARGET_HOST = " + logDetails.get("host") + ", TARGET_PORT = " + logDetails.get("port") + ", TARGET_CONTEXT = " + logDetails.get("url") + ", HTTP_METHOD = " + logDetails.get("method") + ", TRIGGER_TYPE = " + logDetails.get("trigger_type") + ", TRIGGER_NAME = " + logDetails.get("trigger_name") + ", REMOTE_ADDRESS = " + this.getBackEndConnectionInfo(conn) + ", CONNECTION = " + conn + ", SOCKET_TIMEOUT = " + conn.getSocketTimeout() + ", CORRELATION_ID = " + conn.getContext().getAttribute("correlation_id")));
            }
            if (state == ProtocolState.RESPONSE_BODY || state == ProtocolState.REQUEST_HEAD) {
                this.metrics.incrementTimeoutsReceiving();
                this.informReaderError(conn);
                log.warn((Object)("ERROR_CODE = 101504, STATE_DESCRIPTION = Socket Timeout occurred " + logDetails.get("state_description") + ", INTERNAL_STATE = " + (Object)((Object)state) + ", DIRECTION = " + logDetails.get("direction") + ", CAUSE_OF_ERROR = Connection between the EI and the BackEnd timeouts, TARGET_HOST = " + logDetails.get("host") + ", TARGET_PORT = " + logDetails.get("port") + ", TARGET_CONTEXT = " + logDetails.get("url") + ", HTTP_METHOD = " + logDetails.get("method") + ", TRIGGER_TYPE = " + logDetails.get("trigger_type") + ", TRIGGER_NAME = " + logDetails.get("trigger_name") + ", REMOTE_ADDRESS = " + this.getBackEndConnectionInfo(conn) + ", CONNECTION = " + conn + ", SOCKET_TIMEOUT = " + conn.getSocketTimeout() + ", CORRELATION_ID = " + conn.getContext().getAttribute("correlation_id")));
            }
            if (state.compareTo(ProtocolState.REQUEST_DONE) <= 0) {
                log.warn((Object)("ERROR_CODE = 101504, STATE_DESCRIPTION = Socket Timeout occurred " + logDetails.get("state_description") + ", INTERNAL_STATE = " + (Object)((Object)state) + ", DIRECTION = " + logDetails.get("direction") + ", CAUSE_OF_ERROR = Connection between the EI and the BackEnd timeouts, TARGET_HOST = " + logDetails.get("host") + ", TARGET_PORT = " + logDetails.get("port") + ", TARGET_CONTEXT = " + logDetails.get("url") + ", HTTP_METHOD = " + logDetails.get("method") + ", TRIGGER_TYPE = " + logDetails.get("trigger_type") + ", TRIGGER_NAME = " + logDetails.get("trigger_name") + ", REMOTE_ADDRESS = " + this.getBackEndConnectionInfo(conn) + ", CONNECTION = " + conn + ", SOCKET_TIMEOUT = " + conn.getSocketTimeout() + ", CORRELATION_ID = " + conn.getContext().getAttribute("correlation_id")));
                if (this.targetConfiguration.isCorrelationLoggingEnabled().booleanValue()) {
                    this.logHttpRequestErrorInCorrelationLog(conn, "Timeout in " + (Object)((Object)state));
                }
                if (requestMsgCtx != null) {
                    requestMsgCtx.setProperty("_INTERNAL_EXCEPTION_ORIGIN", (Object)"TARGET_ERROR_HANDLER");
                    this.targetErrorHandler.handleError(requestMsgCtx, 101504, "Error in Sender", null, state);
                }
            }
        }
        TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
        this.targetConfiguration.getConnections().shutdownConnection(conn, true);
    }

    private boolean isResponseHaveBodyExpected(String method, HttpResponse response) {
        if ("HEAD".equalsIgnoreCase(method)) {
            return false;
        }
        int status = response.getStatusLine().getStatusCode();
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }

    private String getErrorMessage(String message, NHttpClientConnection conn) {
        DefaultNHttpClientConnection c;
        if (conn != null && conn instanceof DefaultNHttpClientConnection && (c = (DefaultNHttpClientConnection)conn).getRemoteAddress() != null) {
            return message + " For : " + c.getRemoteAddress().getHostAddress() + ":" + c.getRemotePort();
        }
        return message;
    }

    private void handleInvalidState(NHttpClientConnection conn, String action) {
        ProtocolState state = TargetContext.getState((NHttpConnection)conn);
        if (log.isWarnEnabled()) {
            log.warn((Object)(conn + ": " + action + " while the handler is in an inconsistent state " + (Object)((Object)TargetContext.getState((NHttpConnection)conn))));
        }
        MessageContext requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx();
        TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
        this.targetConfiguration.getConnections().shutdownConnection(conn, true);
        if (requestMsgCtx != null) {
            requestMsgCtx.setProperty("_INTERNAL_EXCEPTION_ORIGIN", (Object)"TARGET_ERROR_HANDLER");
            this.targetErrorHandler.handleError(requestMsgCtx, 102510, "Error in Sender", null, state);
        }
    }

    private void informReaderError(NHttpClientConnection conn) {
        Pipe reader = TargetContext.get((NHttpConnection)conn).getReader();
        this.metrics.incrementFaultsReceiving();
        if (reader != null) {
            reader.producerError();
        }
    }

    private void informWriterError(NHttpClientConnection conn) {
        Pipe writer = TargetContext.get((NHttpConnection)conn).getWriter();
        this.metrics.incrementFaultsReceiving();
        if (writer != null) {
            writer.consumerError();
        }
    }

    public void endOfInput(NHttpClientConnection conn) throws IOException {
        conn.close();
    }

    public void exception(NHttpClientConnection conn, Exception ex) {
        ProtocolState state = TargetContext.getState((NHttpConnection)conn);
        MessageContext requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx();
        Map<String, String> logDetails = this.getLoggingInfo(conn, state, requestMsgCtx, ex);
        if (state == ProtocolState.REQUEST_HEAD || state == ProtocolState.REQUEST_BODY) {
            this.informWriterError(conn);
            log.warn((Object)("ERROR_CODE = " + logDetails.get("error_code") + ", STATE_DESCRIPTION = Exception occurred " + logDetails.get("state_description") + ", INTERNAL_STATE = " + (Object)((Object)state) + ", DIRECTION = " + logDetails.get("direction") + ", CAUSE_OF_ERROR = " + logDetails.get("cause_of_error") + ", TARGET_HOST = " + logDetails.get("host") + ", TARGET_PORT = " + logDetails.get("port") + ", TARGET_CONTEXT = " + logDetails.get("url") + ", HTTP_METHOD = " + logDetails.get("method") + ", TRIGGER_TYPE = " + logDetails.get("trigger_type") + ", TRIGGER_NAME = " + logDetails.get("trigger_name") + ", REMOTE_ADDRESS = " + this.getBackEndConnectionInfo(conn) + ", CONNECTION = " + conn));
        } else if (state == ProtocolState.RESPONSE_HEAD || state == ProtocolState.RESPONSE_BODY) {
            this.informReaderError(conn);
            log.warn((Object)("ERROR_CODE = " + logDetails.get("error_code") + ", STATE_DESCRIPTION = Exception occurred " + logDetails.get("state_description") + ", INTERNAL_STATE = " + (Object)((Object)state) + ", DIRECTION = " + logDetails.get("direction") + ", CAUSE_OF_ERROR = " + logDetails.get("cause_of_error") + ", TARGET_HOST = " + logDetails.get("host") + ", TARGET_PORT = " + logDetails.get("port") + ", TARGET_CONTEXT = " + logDetails.get("url") + ", HTTP_METHOD = " + logDetails.get("method") + ", TRIGGER_TYPE = " + logDetails.get("trigger_type") + ", TRIGGER_NAME = " + logDetails.get("trigger_name") + ", REMOTE_ADDRESS = " + this.getBackEndConnectionInfo(conn) + ", CONNECTION = " + conn));
        } else if (state == ProtocolState.REQUEST_DONE) {
            log.warn((Object)("ERROR_CODE = " + logDetails.get("error_code") + ", STATE_DESCRIPTION = Exception occurred " + logDetails.get("state_description") + ", INTERNAL_STATE = " + (Object)((Object)state) + ", DIRECTION = " + logDetails.get("direction") + ", CAUSE_OF_ERROR = " + logDetails.get("cause_of_error") + ", TARGET_HOST = " + logDetails.get("host") + ", TARGET_PORT = " + logDetails.get("port") + ", TARGET_CONTEXT = " + logDetails.get("url") + ", HTTP_METHOD = " + logDetails.get("method") + ", TRIGGER_TYPE = " + logDetails.get("trigger_type") + ", TRIGGER_NAME = " + logDetails.get("trigger_name") + ", REMOTE_ADDRESS = " + this.getBackEndConnectionInfo(conn) + ", CONNECTION = " + conn));
        } else if (state == ProtocolState.REQUEST_READY) {
            log.warn((Object)("ERROR_CODE = " + logDetails.get("error_code") + ", STATE_DESCRIPTION = Exception occurred " + logDetails.get("state_description") + ", INTERNAL_STATE = " + (Object)((Object)state) + ", DIRECTION = " + logDetails.get("direction") + ", CAUSE_OF_ERROR = " + logDetails.get("cause_of_error") + ", TARGET_HOST = " + logDetails.get("host") + ", TARGET_PORT = " + logDetails.get("port") + ", TARGET_CONTEXT = " + logDetails.get("url") + ", HTTP_METHOD = " + logDetails.get("method") + ", TRIGGER_TYPE = " + logDetails.get("trigger_type") + ", TRIGGER_NAME = " + logDetails.get("trigger_name") + ", REMOTE_ADDRESS = " + this.getBackEndConnectionInfo(conn) + ", CONNECTION = " + conn));
        } else if (state == ProtocolState.RESPONSE_DONE) {
            return;
        }
        if (ex instanceof IOException) {
            this.logIOException(conn, (IOException)ex);
            if (this.targetConfiguration.isCorrelationLoggingEnabled().booleanValue()) {
                this.logHttpRequestErrorInCorrelationLog(conn, "IO Exception in " + state.name());
            }
            if (requestMsgCtx != null) {
                requestMsgCtx.setProperty("_INTERNAL_EXCEPTION_ORIGIN", (Object)"TARGET_ERROR_HANDLER");
                this.targetErrorHandler.handleError(requestMsgCtx, 101500, "Error in Sender", ex, state);
            }
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
        } else if (ex instanceof HttpException) {
            String message = this.getErrorMessage("HTTP protocol violation : " + ex.getMessage(), conn);
            log.error((Object)message, (Throwable)ex);
            if (this.targetConfiguration.isCorrelationLoggingEnabled().booleanValue()) {
                this.logHttpRequestErrorInCorrelationLog(conn, "HTTP Exception in " + state.name());
            }
            if (requestMsgCtx != null) {
                requestMsgCtx.setProperty("_INTERNAL_EXCEPTION_ORIGIN", (Object)"TARGET_ERROR_HANDLER");
                this.targetErrorHandler.handleError(requestMsgCtx, 101506, "Error in Sender", null, state);
            }
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
        } else {
            if (null != ex && null != ex.getMessage()) {
                log.error((Object)("Unexpected error: " + ex.getMessage()), (Throwable)ex);
            } else {
                log.error((Object)"Unexpected error.");
            }
            if (this.targetConfiguration.isCorrelationLoggingEnabled().booleanValue()) {
                this.logHttpRequestErrorInCorrelationLog(conn, "Unexpected error");
            }
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
        }
        this.targetConfiguration.getConnections().shutdownConnection(conn, true);
    }

    public void setConnFactory(ClientConnFactory connFactory) {
        this.connFactory = connFactory;
    }

    public TargetConfiguration getTargetConfiguration() {
        return this.targetConfiguration;
    }

    private String getConnectionLoggingInfo(NHttpClientConnection conn) {
        IOSession ioSession;
        if (conn instanceof LoggingNHttpClientConnection && (ioSession = ((LoggingNHttpClientConnection)conn).getIOSession()) != null) {
            return " Remote Address : " + ioSession.getRemoteAddress();
        }
        return "";
    }

    private String getBackEndConnectionInfo(NHttpClientConnection conn) {
        SocketAddress socketAddress;
        IOSession ioSession;
        if (conn instanceof LoggingNHttpClientConnection && (ioSession = ((LoggingNHttpClientConnection)conn).getIOSession()) != null && (socketAddress = ioSession.getRemoteAddress()) != null) {
            return socketAddress.toString();
        }
        return "";
    }

    private Map<String, String> getLoggingInfo(NHttpClientConnection conn, ProtocolState state, MessageContext requestMsgCtx) {
        return this.getLoggingInfo(conn, state, requestMsgCtx, null);
    }

    private Map<String, String> getLoggingInfo(NHttpClientConnection conn, ProtocolState state, MessageContext requestMsgCtx, Exception ex) {
        DefaultNHttpClientConnection connection;
        HashMap<String, String> logDetails = new HashMap<String, String>();
        TargetContext targetContext = TargetContext.get((NHttpConnection)conn);
        if (targetContext != null) {
            String url = "";
            String method = "";
            if (targetContext.getRequest() != null) {
                url = targetContext.getRequest().getUrl().toString();
                method = targetContext.getRequest().getMethod();
            } else {
                HttpRequest httpRequest = conn.getHttpRequest();
                if (httpRequest != null) {
                    url = httpRequest.getRequestLine().getUri();
                    method = httpRequest.getRequestLine().getMethod();
                }
            }
            logDetails.put("url", url);
            logDetails.put("method", method);
        }
        if (conn != null && conn instanceof DefaultNHttpClientConnection && (connection = (DefaultNHttpClientConnection)conn).getRemoteAddress() != null) {
            logDetails.put("host", connection.getRemoteAddress().getHostAddress());
            logDetails.put("port", Integer.toString(connection.getRemotePort()));
        }
        if (state != null) {
            if (state.compareTo(ProtocolState.REQUEST_DONE) <= 0) {
                logDetails.put("direction", "REQUEST");
            } else {
                logDetails.put("direction", "RESPONSE");
            }
            if (state == ProtocolState.REQUEST_BODY || state == ProtocolState.REQUEST_HEAD) {
                logDetails.put("state_description", "after Server written the request headers but prior to write the request body to the backend");
            } else if (state == ProtocolState.RESPONSE_BODY || state == ProtocolState.RESPONSE_HEAD) {
                logDetails.put("state_description", "after Server read the response headers but prior to reading the response body from the backend");
            } else if (state == ProtocolState.REQUEST_DONE) {
                logDetails.put("state_description", "after Server written the request headers and the request body to the backend");
            } else if (state == ProtocolState.REQUEST_READY) {
                logDetails.put("state_description", "when Server establishing a connection to the backend");
            }
        }
        if (requestMsgCtx != null) {
            Object triggerName = requestMsgCtx.getProperty("_INTERNAL_TRIGGER_NAME");
            Object triggerType = requestMsgCtx.getProperty("_INTERNAL_TRIGGER_TYPE");
            if (triggerType != null) {
                logDetails.put("trigger_type", triggerType.toString());
            }
            if (triggerName != null) {
                logDetails.put("trigger_name", triggerName.toString());
            }
        }
        if (ex != null) {
            if (ex instanceof IOException) {
                logDetails.put("error_code", Integer.toString(101500));
                logDetails.put("cause_of_error", "I/O exception : " + ex.getMessage());
            } else if (ex instanceof HttpException) {
                logDetails.put("error_code", Integer.toString(101506));
                logDetails.put("cause_of_error", "HTTP Protocol violation : " + ex.getMessage());
            } else {
                logDetails.put("cause_of_error", "Unexpected error : " + ex.getMessage());
            }
        }
        return logDetails;
    }

    private void logHttpRequestErrorInCorrelationLog(NHttpClientConnection conn, String state) {
        TargetContext targetContext = TargetContext.get((NHttpConnection)conn);
        if (targetContext != null && TargetContext.isCorrelationIdAvailable((NHttpConnection)conn).booleanValue()) {
            String url = "";
            String method = "";
            if (targetContext.getRequest() != null) {
                url = targetContext.getRequest().getUrl().toString();
                method = targetContext.getRequest().getMethod();
            } else {
                HttpRequest httpRequest = conn.getHttpRequest();
                if (httpRequest != null) {
                    url = httpRequest.getRequestLine().getUri();
                    method = httpRequest.getRequestLine().getMethod();
                }
            }
            if (method.length() != 0 && url.length() != 0) {
                Object requestStartTime = conn.getContext().getAttribute("REQ_TO_BACKEND_WRITE_START_TIME");
                long startTime = 0L;
                if (requestStartTime != null) {
                    startTime = (Long)requestStartTime;
                }
                ContextAwareLogger.getLogger((HttpContext)conn.getContext(), (Log)correlationLog, (boolean)false).info((Object)(System.currentTimeMillis() - startTime + "|HTTP|" + conn.getContext().getAttribute("http.connection") + "|" + method + "|" + url + "|" + state));
            }
        }
    }
}

