/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.MDC;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.config.TargetConfiguration;
import org.apache.synapse.transport.passthru.jmx.PassThroughTransportMetricsCollector;

public class TargetErrorHandler {
    private Log log = LogFactory.getLog(TargetErrorHandler.class);
    private TargetConfiguration targetConfiguration = null;

    public TargetErrorHandler(TargetConfiguration targetConfiguration) {
        this.targetConfiguration = targetConfiguration;
    }

    public void handleError(final MessageContext mc, final int errorCode, final String errorMessage, final Exception exceptionToRaise, final ProtocolState state) {
        if (errorCode == -1 && errorMessage == null && exceptionToRaise == null) {
            return;
        }
        if (mc.getAxisOperation() == null || mc.getAxisOperation().getMessageReceiver() == null) {
            return;
        }
        this.updateFaultInfo(errorCode, mc, this.targetConfiguration.getMetrics());
        this.targetConfiguration.getWorkerPool().execute(new Runnable(){

            @Override
            public void run() {
                MessageReceiver mr = mc.getAxisOperation().getMessageReceiver();
                MDC.remove((String)"Correlation-ID");
                Object correlationId = mc.getProperty("correlation_id");
                if (correlationId != null) {
                    MDC.put((String)"Correlation-ID", (Object)correlationId);
                }
                try {
                    AxisFault axisFault = exceptionToRaise != null ? new AxisFault(errorMessage, (Throwable)exceptionToRaise) : new AxisFault(errorMessage);
                    MessageContext faultMessageContext = MessageContextBuilder.createFaultMessageContext((MessageContext)mc, (Throwable)axisFault);
                    SOAPEnvelope envelope = faultMessageContext.getEnvelope();
                    if (TargetErrorHandler.this.log.isDebugEnabled()) {
                        TargetErrorHandler.this.log.debug((Object)("Sending Fault for Request with Message ID : " + mc.getMessageID()));
                    }
                    faultMessageContext.setTo(null);
                    faultMessageContext.removeProperty("pass-through.pipe");
                    faultMessageContext.setProperty("pass-through.Source-Connection", mc.getProperty("pass-through.Source-Connection"));
                    faultMessageContext.setProperty("PASS_THROUGH_SOURCE_CONFIGURATION", mc.getProperty("PASS_THROUGH_SOURCE_CONFIGURATION"));
                    faultMessageContext.setServerSide(true);
                    faultMessageContext.setDoingREST(mc.isDoingREST());
                    faultMessageContext.setProperty("TRANSPORT_IN", mc.getProperty("TRANSPORT_IN"));
                    faultMessageContext.setTransportIn(mc.getTransportIn());
                    faultMessageContext.setTransportOut(mc.getTransportOut());
                    if (!(mc.getOperationContext().getAxisOperation() instanceof OutOnlyAxisOperation)) {
                        faultMessageContext.setAxisMessage(mc.getOperationContext().getAxisOperation().getMessage("In"));
                    }
                    faultMessageContext.setOperationContext(mc.getOperationContext());
                    faultMessageContext.setConfigurationContext(mc.getConfigurationContext());
                    faultMessageContext.setTo(null);
                    faultMessageContext.setProperty("SENDING_FAULT", (Object)Boolean.TRUE);
                    faultMessageContext.setProperty("ERROR_MESSAGE", (Object)errorMessage);
                    if (errorCode != -1) {
                        faultMessageContext.setProperty("ERROR_CODE", (Object)TargetErrorHandler.this.getErrorCode(errorCode, state));
                    }
                    if (exceptionToRaise != null) {
                        faultMessageContext.setProperty("ERROR_DETAIL", (Object)TargetErrorHandler.this.getStackTrace(exceptionToRaise));
                        faultMessageContext.setProperty("ERROR_EXCEPTION", (Object)exceptionToRaise);
                        envelope.getBody().getFault().getDetail().setText(exceptionToRaise.toString());
                    } else {
                        faultMessageContext.setProperty("ERROR_DETAIL", (Object)errorMessage);
                        envelope.getBody().getFault().getDetail().setText(errorMessage);
                    }
                    faultMessageContext.setProperty("NO_ENTITY_BODY", (Object)true);
                    faultMessageContext.setProperty("correlation_id", mc.getProperty("correlation_id"));
                    faultMessageContext.setProperty("_INTERNAL_EXCEPTION_ORIGIN", mc.getProperty("_INTERNAL_EXCEPTION_ORIGIN"));
                    mr.receive(faultMessageContext);
                }
                catch (AxisFault af) {
                    TargetErrorHandler.this.log.error((Object)"Unable to report back failure to the message receiver", (Throwable)af);
                }
            }
        });
    }

    private int getErrorCode(int errorCode, ProtocolState state) {
        return errorCode + state.ordinal();
    }

    private String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    private void updateFaultInfo(int errorCode, MessageContext mc, PassThroughTransportMetricsCollector metrics) {
        if (mc.getAxisOperation() != null && mc.getAxisOperation().getMessageReceiver() != null && metrics != null) {
            if (metrics.getLevel() == 2) {
                if (errorCode == 101504) {
                    metrics.incrementTimeoutsReceiving(mc);
                } else {
                    metrics.incrementFaultsSending(errorCode, mc);
                }
            } else if (errorCode == 101504) {
                metrics.incrementTimeoutsReceiving();
            } else {
                metrics.incrementFaultsSending();
            }
        }
    }
}

