/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpRequest;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.protocol.HttpContext;
import org.apache.synapse.commons.logger.ContextAwareLogger;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.TargetRequest;
import org.apache.synapse.transport.passthru.TargetResponse;
import org.apache.synapse.transport.passthru.config.TargetConfiguration;
import org.apache.synapse.transport.passthru.util.ControlledByteBuffer;

public class TargetContext {
    private TargetConfiguration targetConfiguration = null;
    public static final String CONNECTION_INFORMATION = "CONNECTION_INFORMATION";
    private TargetRequest request;
    private TargetResponse response;
    private ProtocolState state;
    private MessageContext requestMsgCtx;
    private Pipe reader;
    private Pipe writer;
    private static final Log correlationLog = LogFactory.getLog((String)"correlation");
    private long lastStateUpdatedTime;

    public TargetContext(TargetConfiguration targetConfiguration) {
        this.targetConfiguration = targetConfiguration;
    }

    public ProtocolState getState() {
        return this.state;
    }

    public void setState(ProtocolState state) {
        this.state = state;
    }

    public TargetConfiguration getTargetConfiguration() {
        return this.targetConfiguration;
    }

    public TargetRequest getRequest() {
        return this.request;
    }

    public void setRequest(TargetRequest request) {
        this.request = request;
    }

    public TargetResponse getResponse() {
        return this.response;
    }

    public void setResponse(TargetResponse response) {
        this.response = response;
    }

    public MessageContext getRequestMsgCtx() {
        return this.requestMsgCtx;
    }

    public void setRequestMsgCtx(MessageContext requestMsgCtx) {
        this.requestMsgCtx = requestMsgCtx;
    }

    public Pipe getReader() {
        return this.reader;
    }

    public Pipe getWriter() {
        return this.writer;
    }

    public void setReader(Pipe reader) {
        this.reader = reader;
    }

    public void setWriter(Pipe writer) {
        this.writer = writer;
    }

    public void reset() {
        this.reset(false);
    }

    public void reset(boolean isError) {
        this.request = null;
        this.response = null;
        if (this.writer != null && !isError) {
            ControlledByteBuffer buffer = this.writer.getBuffer();
            this.targetConfiguration.getBufferFactory().release(buffer);
        }
        this.reader = null;
        this.writer = null;
    }

    public static void create(NHttpConnection conn, ProtocolState state, TargetConfiguration configuration) {
        TargetContext targetContext = new TargetContext(configuration);
        conn.getContext().setAttribute(CONNECTION_INFORMATION, (Object)targetContext);
        targetContext.setState(state);
        if (targetContext.getTargetConfiguration().isCorrelationLoggingEnabled().booleanValue()) {
            targetContext.updateLastStateUpdatedTime();
        }
    }

    public static void updateState(NHttpConnection conn, ProtocolState state) {
        TargetContext targetContext = (TargetContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        if (targetContext != null) {
            if (targetContext.getState() == state) {
                return;
            }
            targetContext.setState(state);
            if (targetContext.getTargetConfiguration().isCorrelationLoggingEnabled().booleanValue() && TargetContext.isCorrelationIdAvailable(conn).booleanValue()) {
                long lastStateUpdateTime = targetContext.getLastStateUpdatedTime();
                String url = "";
                String method = "";
                if (targetContext.getRequest() != null) {
                    url = targetContext.getRequest().getUrl().toString();
                    method = targetContext.getRequest().getMethod();
                } else {
                    HttpRequest httpRequest = conn.getHttpRequest();
                    if (httpRequest != null) {
                        url = httpRequest.getRequestLine().getUri();
                        method = httpRequest.getRequestLine().getMethod();
                    }
                }
                if (method.length() != 0 && url.length() != 0) {
                    ContextAwareLogger.getLogger((HttpContext)conn.getContext(), (Log)correlationLog, (boolean)false).info((Object)(targetContext.updateLastStateUpdatedTime() - lastStateUpdateTime + "|HTTP State Transition|" + conn.getContext().getAttribute("http.connection") + "|" + method + "|" + url + "|" + state.name()));
                }
            }
        } else {
            throw new IllegalStateException("Connection information should be present");
        }
    }

    public static boolean assertState(NHttpConnection conn, ProtocolState state) {
        TargetContext info = (TargetContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        return info != null && info.getState() == state;
    }

    public static ProtocolState getState(NHttpConnection conn) {
        TargetContext info = (TargetContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        return info != null ? info.getState() : null;
    }

    public static void setRequest(NHttpConnection conn, TargetRequest request) {
        TargetContext info = (TargetContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        if (info == null) {
            throw new IllegalStateException("Connection information should be present");
        }
        info.setRequest(request);
    }

    public static void setResponse(NHttpConnection conn, TargetResponse response) {
        TargetContext info = (TargetContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        if (info == null) {
            throw new IllegalStateException("Connection information should be present");
        }
        info.setResponse(response);
    }

    public static TargetRequest getRequest(NHttpConnection conn) {
        TargetContext info = (TargetContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        return info != null ? info.getRequest() : null;
    }

    public static TargetResponse getResponse(NHttpConnection conn) {
        TargetContext info = (TargetContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        return info != null ? info.getResponse() : null;
    }

    public static TargetContext get(NHttpConnection conn) {
        return (TargetContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
    }

    public long getLastStateUpdatedTime() {
        return this.lastStateUpdatedTime;
    }

    public long updateLastStateUpdatedTime() {
        this.lastStateUpdatedTime = System.currentTimeMillis();
        return this.lastStateUpdatedTime;
    }

    public static Boolean isCorrelationIdAvailable(NHttpConnection connection) {
        if (connection.getContext().getAttribute("correlation_id") != null) {
            return true;
        }
        return false;
    }
}

