/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.SourceContext;
import org.apache.synapse.transport.passthru.SourceRequest;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.apache.synapse.transport.passthru.util.PassThroughTransportUtils;
import org.apache.synapse.transport.passthru.util.RelayUtils;

public class SourceResponse {
    private Pipe pipe = null;
    private Map<String, TreeSet<String>> headers = new HashMap<String, TreeSet<String>>();
    private int status = 200;
    private String statusLine = null;
    private HttpResponse response = null;
    private SourceConfiguration sourceConfiguration;
    private ProtocolVersion version = HttpVersion.HTTP_1_1;
    private ConnectionReuseStrategy connStrategy = new DefaultConnectionReuseStrategy();
    private boolean hasEntity = true;
    private boolean keepAlive = true;
    private SourceRequest request = null;
    private boolean versionChangeRequired = false;

    public SourceResponse(SourceConfiguration config, int status, SourceRequest request) {
        this(config, status, null, request);
    }

    public SourceResponse(SourceConfiguration config, int status, String statusLine, SourceRequest request) {
        this.status = status;
        this.statusLine = statusLine;
        this.sourceConfiguration = config;
        this.request = request;
        if (request != null && request.getVersion() != null) {
            this.version = request.getVersion();
        }
    }

    public void connect(Pipe pipe) {
        this.pipe = pipe;
        if (this.request != null && pipe != null) {
            SourceContext.get((NHttpConnection)this.request.getConnection()).setWriter(pipe);
        }
    }

    public void start(NHttpServerConnection conn) throws IOException, HttpException {
        this.response = this.sourceConfiguration.getResponseFactory().newHttpResponse(this.request.getVersion(), this.status, this.request.getConnection().getContext());
        if (this.statusLine != null) {
            if (this.versionChangeRequired) {
                this.response.setStatusLine(this.version, this.status, this.statusLine);
            } else {
                this.response.setStatusLine(this.request.getVersion(), this.status, this.statusLine);
            }
        } else if (this.versionChangeRequired) {
            this.response.setStatusLine(this.version, this.status);
        } else {
            this.response.setStatusCode(this.status);
        }
        BasicHttpEntity entity = null;
        if (this.canResponseHaveBody(this.request.getRequest(), this.response)) {
            entity = new BasicHttpEntity();
            long contentLength = -1L;
            for (String header : this.headers.keySet()) {
                if (!"Content-Length".equalsIgnoreCase(header)) continue;
                String contentLengthHeader = this.headers.get(header).first();
                contentLength = Long.parseLong(contentLengthHeader);
                this.headers.remove(header);
                break;
            }
            if (contentLength != -1L) {
                entity.setChunked(false);
                entity.setContentLength(contentLength);
            } else {
                entity.setChunked(true);
            }
        }
        this.response.setEntity((HttpEntity)entity);
        Set<Map.Entry<String, TreeSet<String>>> entries = this.headers.entrySet();
        for (Map.Entry<String, TreeSet<String>> entry : entries) {
            if (entry.getKey() == null) continue;
            Iterator<String> i = entry.getValue().iterator();
            while (i.hasNext()) {
                this.response.addHeader(entry.getKey(), i.next());
            }
        }
        if (!this.keepAlive) {
            this.response.setHeader("Connection", "Close");
        }
        this.response.setParams((HttpParams)new DefaultedHttpParams(this.response.getParams(), this.sourceConfiguration.getHttpParams()));
        SourceContext.updateState((NHttpConnection)conn, ProtocolState.RESPONSE_HEAD);
        conn.getContext().setAttribute("http.connection", (Object)conn);
        conn.getContext().setAttribute("http.response", (Object)this.response);
        conn.getContext().setAttribute("http.request", (Object)SourceContext.getRequest((NHttpConnection)conn).getRequest());
        this.sourceConfiguration.getHttpProcessor().process(this.response, conn.getContext());
        if (entity == null && "HEAD".equalsIgnoreCase(this.request.getRequest().getRequestLine().getMethod())) {
            if (this.response.getFirstHeader("ORGINAL_CONTEN_LENGTH") == null && this.response.getFirstHeader("Content-Length") != null && this.response.getFirstHeader("Content-Length").getValue().equals("0")) {
                this.response.removeHeaders("Content-Length");
            } else if (this.response.getFirstHeader("ORGINAL_CONTEN_LENGTH") != null) {
                this.response.removeHeaders("Content-Length");
                this.response.addHeader("Content-Length", this.response.getFirstHeader("ORGINAL_CONTEN_LENGTH").getValue());
                this.response.removeHeaders("ORGINAL_CONTEN_LENGTH");
            }
        }
        conn.submitResponse(this.response);
        if (entity == null) {
            this.hasEntity = false;
            this.sourceConfiguration.getSourceConnections().releaseConnection(conn);
            conn.requestInput();
        }
    }

    public void checkResponseChunkDisable(MessageContext responseMsgContext) throws IOException {
        if (responseMsgContext.getProperty("HTTP_SC") != null) {
            if (this.canResponseHaveContentLength(responseMsgContext)) {
                this.calculateContentlengthForChunckDisabledResponse(responseMsgContext);
            }
        } else {
            this.calculateContentlengthForChunckDisabledResponse(responseMsgContext);
        }
    }

    private void calculateContentlengthForChunckDisabledResponse(MessageContext responseMsgContext) throws IOException {
        String forceHttp10 = (String)responseMsgContext.getProperty("FORCE_HTTP_1.0");
        boolean isChunkingDisabled = responseMsgContext.isPropertyTrue("DISABLE_CHUNKING", false);
        if ("true".equals(forceHttp10) || isChunkingDisabled) {
            Boolean noEntityBody;
            if (!responseMsgContext.isPropertyTrue("message.builder.invoked", false)) {
                try {
                    RelayUtils.buildMessage(responseMsgContext, false);
                    responseMsgContext.getEnvelope().buildWithAttachments();
                }
                catch (Exception e) {
                    throw new AxisFault(e.getMessage());
                }
            }
            if ("true".equals(forceHttp10)) {
                this.version = HttpVersion.HTTP_1_0;
                this.versionChangeRequired = true;
            }
            if ((noEntityBody = (Boolean)responseMsgContext.getProperty("NO_ENTITY_BODY")) != null && Boolean.TRUE == noEntityBody) {
                this.headers.remove("Content-Type");
                return;
            }
            String contentType = this.headers.get("Content-Type") != null ? this.headers.get("Content-Type").toString() : null;
            boolean preserveStream = isChunkingDisabled && this.isSOAPContentType(contentType) || "true".equals(forceHttp10);
            MessageFormatter formatter = MessageProcessorSelector.getMessageFormatter((MessageContext)responseMsgContext);
            OMOutputFormat format = PassThroughTransportUtils.getOMOutputFormat(responseMsgContext);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            formatter.writeTo(responseMsgContext, format, (OutputStream)out, preserveStream);
            TreeSet<String> header = new TreeSet<String>();
            header.add(String.valueOf(out.toByteArray().length));
            this.headers.put("Content-Length", header);
        }
    }

    public int write(NHttpServerConnection conn, ContentEncoder encoder) throws IOException {
        int bytes = 0;
        if (this.pipe != null) {
            bytes = this.pipe.consume(encoder);
        } else {
            encoder.complete();
        }
        this.writePostActions(conn, encoder);
        return bytes;
    }

    public ByteBuffer copyAndWrite(NHttpServerConnection conn, ContentEncoder encoder) throws IOException {
        ByteBuffer bytes = null;
        if (this.pipe != null) {
            bytes = this.pipe.copyAndConsume(encoder);
        } else {
            encoder.complete();
        }
        this.writePostActions(conn, encoder);
        return bytes;
    }

    private void writePostActions(NHttpServerConnection conn, ContentEncoder encoder) {
        if (encoder.isCompleted()) {
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.RESPONSE_DONE);
            this.sourceConfiguration.getMetrics().notifySentMessageSize(conn.getMetrics().getSentBytesCount());
            if (this.response != null && !this.connStrategy.keepAlive(this.response, conn.getContext())) {
                SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
                this.sourceConfiguration.getSourceConnections().closeConnection(conn);
            } else if (SourceContext.get((NHttpConnection)conn).isShutDown()) {
                SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
                this.sourceConfiguration.getSourceConnections().closeConnection(conn);
            } else {
                this.sourceConfiguration.getSourceConnections().releaseConnection(conn);
                conn.requestInput();
            }
        }
    }

    public void addHeader(String name, String value) {
        if (this.headers.get(name) == null) {
            TreeSet<String> values = new TreeSet<String>();
            values.add(value);
            this.headers.put(name, values);
        } else {
            TreeSet<String> values = this.headers.get(name);
            values.add(value);
        }
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void removeHeader(String name) {
        if (this.headers.get(name) != null) {
            this.headers.remove(name);
        }
    }

    public String getHeader(String name) {
        if (this.headers.containsKey(name)) {
            return this.headers.get(name).first();
        }
        return null;
    }

    private boolean canResponseHaveBody(HttpRequest request, HttpResponse response) {
        if (request != null && "HEAD".equalsIgnoreCase(request.getRequestLine().getMethod())) {
            return false;
        }
        int status = response.getStatusLine().getStatusCode();
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }

    private boolean canResponseHaveContentLength(MessageContext responseMsgContext) {
        Object httpStatus = responseMsgContext.getProperty("HTTP_SC");
        if (httpStatus == null || httpStatus.toString().equals("")) {
            return false;
        }
        int status = httpStatus instanceof String ? Integer.parseInt((String)httpStatus) : (Integer)httpStatus;
        if (this.request != null && "CONNECT".equals(this.request.getRequest().getRequestLine().getMethod())) {
            return status / 100 != 2;
        }
        return 204 != status && status / 100 != 1;
    }

    public boolean hasEntity() {
        return this.hasEntity;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    private boolean isSOAPContentType(String contentType) {
        return contentType != null && (contentType.indexOf("text/xml") != -1 || contentType.indexOf("application/soap+xml") != -1);
    }
}

