/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.http.Header;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.SourceContext;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;

public class SourceRequest {
    private Pipe pipe = null;
    private Map<String, String> headers = new TreeMap<String, String>(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    });
    private String url;
    private String method;
    private boolean entityEnclosing;
    private HttpRequest request = null;
    private SourceConfiguration sourceConfiguration;
    private ProtocolVersion version = null;
    private NHttpServerConnection connection = null;
    private Map excessHeaders = new MultiValueMap();

    public SourceRequest(SourceConfiguration sourceConfiguration, HttpRequest request, NHttpServerConnection conn) {
        Header[] headers;
        this.sourceConfiguration = sourceConfiguration;
        this.request = request;
        this.connection = conn;
        this.url = request.getRequestLine().getUri();
        this.method = request.getRequestLine().getMethod();
        this.entityEnclosing = request instanceof HttpEntityEnclosingRequest;
        this.version = request.getProtocolVersion();
        this.version = request.getRequestLine().getProtocolVersion();
        if (!this.version.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
            this.version = HttpVersion.HTTP_1_1;
        }
        if ((headers = request.getAllHeaders()) != null) {
            for (Header header : headers) {
                if (this.headers.containsKey(header.getName())) {
                    this.addExcessHeader(header);
                    continue;
                }
                this.headers.put(header.getName(), header.getValue());
            }
        }
    }

    public void start(NHttpServerConnection conn) throws IOException, HttpException {
        if (this.entityEnclosing) {
            this.pipe = new Pipe((IOControl)conn, this.sourceConfiguration.getBufferFactory().getBuffer(), "source", this.sourceConfiguration);
            SourceContext.get((NHttpConnection)conn).setReader(this.pipe);
            if (((HttpEntityEnclosingRequest)this.request).expectContinue()) {
                BasicHttpResponse ack = new BasicHttpResponse(this.version, 100, "Continue");
                conn.submitResponse((HttpResponse)ack);
            }
        } else {
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_DONE);
            conn.suspendInput();
        }
    }

    public int read(NHttpServerConnection conn, ContentDecoder decoder) throws IOException {
        if (this.pipe == null) {
            throw new IllegalStateException("A Pipe must be connected before calling read");
        }
        if (this.entityEnclosing) {
            int bytes = this.pipe.produce(decoder);
            this.readPostActions(conn, decoder);
            return bytes;
        }
        throw new IllegalStateException("Only Entity Enclosing Requests can read content in to the pipe");
    }

    public ByteBuffer copyAndRead(NHttpServerConnection conn, ContentDecoder decoder) throws IOException {
        if (this.pipe == null) {
            throw new IllegalStateException("A Pipe must be connected before calling read");
        }
        if (this.entityEnclosing) {
            ByteBuffer bufferCopy = this.pipe.copyAndProduce(decoder);
            this.readPostActions(conn, decoder);
            return bufferCopy;
        }
        throw new IllegalStateException("Only Entity Enclosing Requests can read content in to the pipe");
    }

    private void readPostActions(NHttpServerConnection conn, ContentDecoder decoder) {
        if (decoder.isCompleted()) {
            conn.getContext().setAttribute("REQ_FROM_CLIENT_READ_END_TIME", (Object)System.currentTimeMillis());
            this.sourceConfiguration.getMetrics().notifyReceivedMessageSize(conn.getMetrics().getReceivedBytesCount());
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_DONE);
            conn.suspendInput();
        }
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getUri() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public Map getExcessHeaders() {
        return this.excessHeaders;
    }

    public void addExcessHeader(Header h) {
        this.excessHeaders.put(h.getName(), h.getValue());
    }

    public Pipe getPipe() {
        return this.pipe;
    }

    public NHttpServerConnection getConnection() {
        return this.connection;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public boolean isEntityEnclosing() {
        return this.entityEnclosing;
    }
}

