/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.net.ssl.SSLException;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.entity.ContentOutputStream;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.ContentOutputBuffer;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.nio.util.SimpleOutputBuffer;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.synapse.commons.jmx.ThreadingView;
import org.apache.synapse.commons.logger.ContextAwareLogger;
import org.apache.synapse.commons.transaction.TranscationManger;
import org.apache.synapse.commons.util.MiscellaneousUtil;
import org.apache.synapse.transport.http.conn.LoggingNHttpServerConnection;
import org.apache.synapse.transport.http.conn.Scheme;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.ServerWorker;
import org.apache.synapse.transport.passthru.SourceContext;
import org.apache.synapse.transport.passthru.SourceRequest;
import org.apache.synapse.transport.passthru.SourceResponse;
import org.apache.synapse.transport.passthru.StreamInterceptor;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.apache.synapse.transport.passthru.jmx.LatencyCollector;
import org.apache.synapse.transport.passthru.jmx.LatencyView;
import org.apache.synapse.transport.passthru.jmx.PassThroughTransportMetricsCollector;

public class SourceHandler
implements NHttpServerEventHandler {
    private static Log log = LogFactory.getLog(SourceHandler.class);
    private static final Log correlationLog = LogFactory.getLog((String)"correlation");
    private final SourceConfiguration sourceConfiguration;
    private PassThroughTransportMetricsCollector metrics = null;
    private LatencyView latencyView = null;
    private LatencyView s2sLatencyView = null;
    private ThreadingView threadingView;
    private static boolean isMessageSizeValidationEnabled = false;
    private static int validMaxMessageSize = Integer.MAX_VALUE;
    public static final String PROPERTY_FILE = "passthru-http.properties";
    public static final String MESSAGE_SIZE_VALIDATION = "message.size.validation.enabled";
    public static final String VALID_MAX_MESSAGE_SIZE = "valid.max.message.size.in.bytes";
    private List<StreamInterceptor> streamInterceptors;
    private boolean interceptStream;
    private int noOfInterceptors;

    public SourceHandler(SourceConfiguration sourceConfiguration) {
        this(sourceConfiguration, new ArrayList<StreamInterceptor>());
    }

    public SourceHandler(SourceConfiguration sourceConfiguration, List<StreamInterceptor> streamInterceptors) {
        this.sourceConfiguration = sourceConfiguration;
        this.metrics = sourceConfiguration.getMetrics();
        this.streamInterceptors = streamInterceptors;
        this.interceptStream = !streamInterceptors.isEmpty();
        this.noOfInterceptors = streamInterceptors.size();
        String strNamePostfix = "";
        if (sourceConfiguration.getInDescription() != null && sourceConfiguration.getInDescription().getName() != null) {
            strNamePostfix = "-" + sourceConfiguration.getInDescription().getName();
            Scheme scheme = sourceConfiguration.getScheme();
            boolean enableAdvancedForLatencyView = sourceConfiguration.getBooleanValue("synapse.passthrough.latency_view.enable_advanced_view", false);
            boolean enableAdvancedForS2SView = sourceConfiguration.getBooleanValue("synapse.passthrough.s2slatency_view.enable_advanced_view", false);
            this.latencyView = new LatencyView("PassthroughLatencyView", scheme.isSSL(), strNamePostfix, enableAdvancedForLatencyView);
            this.s2sLatencyView = new LatencyView("PassthroughS2SLatencyView", scheme.isSSL(), strNamePostfix, enableAdvancedForS2SView);
            this.threadingView = new ThreadingView("PassthroughHttpServerWorker", true, 50.0);
        }
        Properties props = MiscellaneousUtil.loadProperties((String)PROPERTY_FILE);
        String validationProperty = MiscellaneousUtil.getProperty((Properties)props, (String)MESSAGE_SIZE_VALIDATION, (String)"false");
        String validMaxMessageSizeStr = MiscellaneousUtil.getProperty((Properties)props, (String)VALID_MAX_MESSAGE_SIZE, (String)String.valueOf(Integer.MAX_VALUE));
        isMessageSizeValidationEnabled = Boolean.valueOf(validationProperty);
        try {
            validMaxMessageSize = Integer.valueOf(validMaxMessageSizeStr);
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Invalid max message size configured for property \"valid.max.message.size.in.bytes\", setting the Integer MAX_VALUE as the valid maximum message size", (Throwable)e);
            validMaxMessageSize = Integer.MAX_VALUE;
        }
    }

    public void connected(NHttpServerConnection conn) {
        this.sourceConfiguration.getSourceConnections().addConnection(conn);
        SourceContext.create((NHttpConnection)conn, ProtocolState.REQUEST_READY, this.sourceConfiguration);
        this.metrics.connected();
    }

    public void requestReceived(NHttpServerConnection conn) {
        try {
            String method;
            SourceRequest request;
            HttpContext httpContext = conn.getContext();
            this.setCorrelationId(conn);
            if (this.sourceConfiguration.isCorrelationLoggingEnabled().booleanValue()) {
                SourceContext sourceContext = (SourceContext)conn.getContext().getAttribute("CONNECTION_INFORMATION");
                sourceContext.updateLastStateUpdatedTime();
            }
            httpContext.setAttribute("REQ_ARRIVAL_TIME", (Object)System.currentTimeMillis());
            httpContext.setAttribute("REQ_FROM_CLIENT_READ_START_TIME", (Object)System.currentTimeMillis());
            if (isMessageSizeValidationEnabled) {
                httpContext.setAttribute("MESSAGE_SIZE_VALIDATION_SUM", (Object)0);
            }
            if ((request = this.getSourceRequest(conn)) == null) {
                return;
            }
            String string = method = request.getRequest() != null ? request.getRequest().getRequestLine().getMethod().toUpperCase() : "";
            if (!request.isEntityEnclosing()) {
                conn.getContext().setAttribute("REQ_FROM_CLIENT_READ_END_TIME", (Object)System.currentTimeMillis());
            }
            OutputStream os = this.getOutputStream(method, request);
            Object correlationId = conn.getContext().getAttribute("correlation_id");
            if (correlationId != null) {
                this.sourceConfiguration.getWorkerPool().execute((Runnable)new ServerWorker(request, this.sourceConfiguration, os, System.currentTimeMillis(), correlationId.toString()));
            } else {
                this.sourceConfiguration.getWorkerPool().execute((Runnable)new ServerWorker(request, this.sourceConfiguration, os));
            }
            this.metrics.requestReceived();
        }
        catch (HttpException e) {
            log.error((Object)"HttpException occurred when request is processing probably when creating SourceRequest", (Throwable)e);
            this.informReaderError(conn);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        }
        catch (IOException e) {
            ProtocolState protocolState = SourceContext.getState((NHttpConnection)conn);
            Map<String, String> logDetails = this.getLoggingInfo(conn, protocolState);
            log.warn((Object)("STATE_DESCRIPTION = IO/Exception occurred when submitting response to request with header Expected: 100-receive, INTERNAL_STATE = " + (Object)((Object)protocolState) + ", DIRECTION = " + logDetails.get("direction") + ", CAUSE_OF_ERROR = " + e.getMessage() + ", HTTP_URL = " + logDetails.get("url") + ", HTTP_METHOD = " + logDetails.get("method") + ", CLIENT_ADDRESS = " + this.getClientConnectionInfo(conn) + ", CONNECTION " + conn));
            this.logIOException(conn, e);
            this.informReaderError(conn);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        }
    }

    public void setCorrelationId(NHttpServerConnection conn) {
        String correlationId;
        HttpContext httpContext = conn.getContext();
        String correlationHeaderName = PassThroughConfiguration.getInstance().getCorrelationHeaderName();
        Header[] correlationHeader = conn.getHttpRequest().getHeaders(correlationHeaderName);
        if (correlationHeader.length != 0) {
            correlationId = correlationHeader[0].getValue();
        } else {
            correlationId = UUID.randomUUID().toString();
            conn.getHttpRequest().setHeader(correlationHeaderName, correlationId);
            httpContext.setAttribute("systemGeneratedCorrelationId", (Object)true);
        }
        httpContext.setAttribute("correlation_id", (Object)correlationId);
    }

    public void inputReady(NHttpServerConnection conn, ContentDecoder decoder) {
        try {
            ProtocolState protocolState = SourceContext.getState((NHttpConnection)conn);
            if (protocolState != ProtocolState.REQUEST_HEAD && protocolState != ProtocolState.REQUEST_BODY) {
                this.handleInvalidState(conn, "Request message body data received");
                return;
            }
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_BODY);
            SourceRequest request = SourceContext.getRequest((NHttpConnection)conn);
            int readBytes = 0;
            boolean interceptionEnabled = false;
            Boolean[] interceptorResults = new Boolean[this.noOfInterceptors];
            if (this.interceptStream) {
                int index = 0;
                for (StreamInterceptor interceptor : this.streamInterceptors) {
                    interceptorResults[index] = interceptor.interceptSourceRequest((MessageContext)conn.getContext().getAttribute("REQUEST_MESSAGE_CONTEXT"));
                    if (!interceptionEnabled && interceptorResults[index].booleanValue()) {
                        interceptionEnabled = true;
                    }
                    ++index;
                }
                if (interceptionEnabled) {
                    ByteBuffer bytesSent = request.copyAndRead(conn, decoder);
                    if (bytesSent != null) {
                        readBytes = bytesSent.remaining();
                        index = 0;
                        for (StreamInterceptor interceptor : this.streamInterceptors) {
                            boolean proceed;
                            if (interceptorResults[index].booleanValue() && !(proceed = interceptor.sourceRequest(bytesSent.duplicate().asReadOnlyBuffer(), (MessageContext)conn.getContext().getAttribute("REQUEST_MESSAGE_CONTEXT")))) {
                                log.info((Object)("Dropping source connection since request is blocked by : " + interceptor.getClass().getName()));
                                this.dropSourceConnection(conn);
                                conn.getContext().setAttribute("SOURCE_CONNECTION_DROPPED", (Object)true);
                                request.getPipe().forceProducerComplete(decoder);
                                break;
                            }
                            ++index;
                        }
                    }
                } else {
                    readBytes = request.read(conn, decoder);
                }
            } else {
                readBytes = request.read(conn, decoder);
            }
            if (isMessageSizeValidationEnabled) {
                HttpContext httpContext = conn.getContext();
                if (httpContext.getAttribute("MESSAGE_SIZE_VALIDATION_SUM") == null) {
                    httpContext.setAttribute("MESSAGE_SIZE_VALIDATION_SUM", (Object)0);
                }
                int messageSizeSum = (Integer)httpContext.getAttribute("MESSAGE_SIZE_VALIDATION_SUM");
                if ((messageSizeSum += readBytes) > validMaxMessageSize) {
                    log.warn((Object)("Payload exceeds valid payload size range, hence discontinuing chunk stream at " + messageSizeSum + " bytes to prevent OOM."));
                    this.dropSourceConnection(conn);
                    this.metrics.exceptionOccured();
                    conn.getContext().setAttribute("SOURCE_CONNECTION_DROPPED", (Object)true);
                    request.getPipe().forceProducerComplete(decoder);
                }
                httpContext.setAttribute("MESSAGE_SIZE_VALIDATION_SUM", (Object)messageSizeSum);
            }
            if (readBytes > 0) {
                this.metrics.incrementBytesReceived(readBytes);
            }
        }
        catch (IOException e) {
            ProtocolState protocolState = SourceContext.getState((NHttpConnection)conn);
            Map<String, String> logDetails = this.getLoggingInfo(conn, protocolState);
            log.warn((Object)("STATE_DESCRIPTION = IO/Exception when reading bytes of request body from the underlying stream, INTERNAL_STATE = " + (Object)((Object)protocolState) + ", DIRECTION = " + logDetails.get("direction") + ", CAUSE_OF_ERROR = " + e.getMessage() + ", HTTP_URL = " + logDetails.get("url") + ", HTTP_METHOD = " + logDetails.get("method") + ", CLIENT_ADDRESS = " + this.getClientConnectionInfo(conn) + ", CONNECTION " + conn));
            this.logIOException(conn, e);
            this.informReaderError(conn);
            this.metrics.exceptionOccured();
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        }
    }

    private void dropSourceConnection(NHttpServerConnection conn) {
        try {
            HttpContext httpContext = conn.getContext();
            BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 413, "Payload Too Large");
            response.setParams((HttpParams)new DefaultedHttpParams(this.sourceConfiguration.getHttpParams(), response.getParams()));
            response.addHeader("Connection", "Close");
            httpContext.setAttribute("http.connection", (Object)conn);
            httpContext.setAttribute("http.request", null);
            httpContext.setAttribute("http.response", (Object)response);
            this.sourceConfiguration.getHttpProcessor().process((HttpResponse)response, httpContext);
            conn.submitResponse((HttpResponse)response);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            conn.close();
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        }
    }

    public void responseReady(NHttpServerConnection conn) {
        try {
            ProtocolState protocolState = SourceContext.getState((NHttpConnection)conn);
            if (protocolState.compareTo(ProtocolState.REQUEST_DONE) < 0) {
                return;
            }
            if (protocolState.compareTo(ProtocolState.CLOSING) >= 0) {
                this.informWriterError(conn);
                return;
            }
            if (protocolState != ProtocolState.REQUEST_DONE) {
                this.handleInvalidState(conn, "Writing a response");
                return;
            }
            SourceResponse response = SourceContext.getResponse((NHttpConnection)conn);
            SourceRequest request = SourceContext.getRequest((NHttpConnection)conn);
            if (response != null) {
                String eTagHeader;
                String ifNoneMatchHeader = SourceContext.getRequest((NHttpConnection)conn).getHeaders().get("If-None-Match");
                if (ifNoneMatchHeader != null && (eTagHeader = response.getHeader("ETag")) != null) {
                    for (String hashValue : ifNoneMatchHeader.split(",")) {
                        if (!hashValue.trim().equals(eTagHeader)) continue;
                        response.setStatus(304);
                        break;
                    }
                }
                response.start(conn);
                conn.getContext().setAttribute("RES_TO_CLIENT_WRITE_START_TIME", (Object)System.currentTimeMillis());
                this.metrics.incrementMessagesSent();
                if (!response.hasEntity()) {
                    HttpContext context = conn.getContext();
                    if (this.sourceConfiguration.isCorrelationLoggingEnabled().booleanValue()) {
                        this.logCorrelationRoundTrip(context, request);
                    }
                    this.updateMetricsView(context);
                }
            }
        }
        catch (IOException e) {
            this.logIOException(conn, e);
            this.informWriterError(conn);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        }
        catch (HttpException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.informWriterError(conn);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        }
    }

    public void outputReady(NHttpServerConnection conn, ContentEncoder encoder) {
        try {
            ProtocolState protocolState = SourceContext.getState((NHttpConnection)conn);
            if (protocolState == ProtocolState.WSDL_RESPONSE_DONE) {
                this.metrics.requestServed();
                HttpContext context = conn.getContext();
                ContentOutputBuffer outBuf = (ContentOutputBuffer)context.getAttribute("synapse.response-source-buffer");
                int bytesWritten = outBuf.produceContent(encoder);
                if (this.metrics != null && bytesWritten > 0) {
                    this.metrics.incrementBytesSent(bytesWritten);
                }
                conn.requestInput();
                if (outBuf instanceof SimpleOutputBuffer && !((SimpleOutputBuffer)outBuf).hasData()) {
                    this.sourceConfiguration.getSourceConnections().releaseConnection(conn);
                }
                this.endTransaction(conn);
                return;
            }
            if (protocolState != ProtocolState.RESPONSE_HEAD && protocolState != ProtocolState.RESPONSE_BODY) {
                log.warn((Object)("Illegal incoming connection state: " + (Object)((Object)protocolState) + " . Possibly two send backs are happening for the same request"));
                this.handleInvalidState(conn, "Trying to write response body");
                this.endTransaction(conn);
                return;
            }
            SourceRequest request = SourceContext.getRequest((NHttpConnection)conn);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.RESPONSE_BODY);
            SourceResponse response = SourceContext.getResponse((NHttpConnection)conn);
            int bytesSent = -1;
            boolean interceptionEnabled = false;
            Boolean[] interceptorResults = new Boolean[this.noOfInterceptors];
            if (this.interceptStream) {
                int index = 0;
                for (StreamInterceptor interceptor : this.streamInterceptors) {
                    interceptorResults[index] = interceptor.interceptSourceResponse((MessageContext)conn.getContext().getAttribute("RESPONSE_MESSAGE_CONTEXT"));
                    if (!interceptionEnabled && interceptorResults[index].booleanValue()) {
                        interceptionEnabled = true;
                    }
                    ++index;
                }
                if (interceptionEnabled) {
                    ByteBuffer bytesWritten = response.copyAndWrite(conn, encoder);
                    if (bytesWritten != null) {
                        bytesSent = bytesWritten.remaining();
                        index = 0;
                        for (StreamInterceptor interceptor : this.streamInterceptors) {
                            if (interceptorResults[index].booleanValue()) {
                                interceptor.sourceResponse(bytesWritten.duplicate().asReadOnlyBuffer(), (MessageContext)conn.getContext().getAttribute("RESPONSE_MESSAGE_CONTEXT"));
                            }
                            ++index;
                        }
                    }
                } else {
                    bytesSent = response.write(conn, encoder);
                }
            } else {
                bytesSent = response.write(conn, encoder);
            }
            if (encoder.isCompleted()) {
                HttpContext context = conn.getContext();
                long departure = System.currentTimeMillis();
                context.setAttribute("RES_TO_CLIENT_WRITE_END_TIME", (Object)departure);
                context.setAttribute("RES_DEPARTURE_TIME", (Object)departure);
                if (this.sourceConfiguration.isCorrelationLoggingEnabled().booleanValue()) {
                    this.logCorrelationRoundTrip(context, request);
                }
                this.updateMetricsView(context);
            }
            this.endTransaction(conn);
            this.metrics.incrementBytesSent(bytesSent);
        }
        catch (IOException e) {
            this.logIOException(conn, e);
            this.informWriterError(conn);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        }
    }

    private void logCorrelationRoundTrip(HttpContext context, SourceRequest request) {
        long startTime = (Long)context.getAttribute("REQ_ARRIVAL_TIME");
        ContextAwareLogger.getLogger((HttpContext)context, (Log)correlationLog, (boolean)false).info((Object)(System.currentTimeMillis() - startTime + "|HTTP|" + context.getAttribute("http.connection") + "|" + request.getMethod() + "|" + request.getUri() + "|ROUND-TRIP LATENCY "));
    }

    public void logIOException(NHttpServerConnection conn, IOException e) {
        if (e == null) {
            return;
        }
        if (e instanceof ConnectionClosedException || e.getMessage() != null && (e.getMessage().toLowerCase().contains("connection reset by peer") || e.getMessage().toLowerCase().contains("forcibly closed"))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(conn + ": I/O error (Probably the keepalive connection was closed):" + e.getMessage()));
            }
        } else if (e instanceof SSLException) {
            log.warn((Object)("I/O error: " + e.getMessage()));
        } else if (e.getMessage() != null) {
            String msg = e.getMessage().toLowerCase();
            if (msg.indexOf("broken") != -1) {
                log.warn((Object)("I/O error (Probably the connection was closed by the remote party):" + e.getMessage()));
            } else {
                log.error((Object)("I/O error: " + e.getMessage()), (Throwable)e);
            }
            this.metrics.incrementFaultsReceiving();
        } else {
            log.error((Object)("Unexpected I/O error: " + e.getClass().getName()), (Throwable)e);
            this.metrics.incrementFaultsReceiving();
        }
    }

    public void timeout(NHttpServerConnection conn) {
        boolean isTimeoutOccurred = false;
        ProtocolState state = SourceContext.getState((NHttpConnection)conn);
        Map<String, String> logDetails = this.getLoggingInfo(conn, state);
        if (state == ProtocolState.REQUEST_READY || state == ProtocolState.RESPONSE_DONE) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(conn + ": Keep-Alive connection was time out: "));
            }
        } else if (state == ProtocolState.REQUEST_BODY || state == ProtocolState.REQUEST_HEAD) {
            this.metrics.incrementTimeoutsReceiving();
            this.metrics.timeoutOccured();
            this.informReaderError(conn);
            isTimeoutOccurred = true;
            log.warn((Object)("STATE_DESCRIPTION = Socket Timeout occurred after reading the request headers but Server is still reading the request body, INTERNAL_STATE = " + (Object)((Object)state) + ", DIRECTION = " + logDetails.get("direction") + ", CAUSE_OF_ERROR = Connection between the client and the EI timeouts, HTTP_URL = " + logDetails.get("url") + ", HTTP_METHOD = " + logDetails.get("method") + ", SOCKET_TIMEOUT = " + conn.getSocketTimeout() + ", CLIENT_ADDRESS = " + this.getClientConnectionInfo(conn) + ", CONNECTION " + conn + " Correlation ID : " + conn.getContext().getAttribute("correlation_id").toString()));
            if (this.sourceConfiguration.isCorrelationLoggingEnabled().booleanValue()) {
                this.logHttpRequestErrorInCorrelationLog(conn, "TIMEOUT in " + state.name());
            }
        } else if (state == ProtocolState.RESPONSE_BODY || state == ProtocolState.RESPONSE_HEAD) {
            this.informWriterError(conn);
            isTimeoutOccurred = true;
            this.metrics.timeoutOccured();
            log.warn((Object)("STATE_DESCRIPTION = Socket Timeout occurred after server writing the response headers to the clientbut Server is still writing the response body, INTERNAL_STATE = " + (Object)((Object)state) + ", DIRECTION = " + logDetails.get("direction") + ", CAUSE_OF_ERROR = Connection between the client and the EI timeouts, HTTP_URL = " + logDetails.get("url") + ", HTTP_METHOD = " + logDetails.get("method") + ", SOCKET_TIMEOUT = " + conn.getSocketTimeout() + ", CLIENT_ADDRESS = " + this.getClientConnectionInfo(conn) + ", CONNECTION " + conn + " Correlation ID : " + conn.getContext().getAttribute("correlation_id").toString()));
            if (this.sourceConfiguration.isCorrelationLoggingEnabled().booleanValue()) {
                this.logHttpRequestErrorInCorrelationLog(conn, "TIMEOUT in " + state.name());
            }
        } else if (state == ProtocolState.REQUEST_DONE) {
            this.informWriterError(conn);
            isTimeoutOccurred = true;
            this.metrics.timeoutOccured();
            log.warn((Object)("STATE_DESCRIPTION = Socket Timeout occurred after accepting the request headers and the request body, INTERNAL_STATE = " + (Object)((Object)state) + ", DIRECTION = " + logDetails.get("direction") + ", CAUSE_OF_ERROR = Connection between the client and the EI timeouts, HTTP_URL = " + logDetails.get("url") + ", HTTP_METHOD = " + logDetails.get("method") + ", SOCKET_TIMEOUT = " + conn.getSocketTimeout() + ", CLIENT_ADDRESS = " + this.getClientConnectionInfo(conn) + ", CONNECTION " + conn + " Correlation ID : " + conn.getContext().getAttribute("correlation_id").toString()));
            if (this.sourceConfiguration.isCorrelationLoggingEnabled().booleanValue()) {
                this.logHttpRequestErrorInCorrelationLog(conn, "TIMEOUT in " + state.name());
            }
        }
        SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
        this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        if (isTimeoutOccurred) {
            this.rollbackTransaction(conn);
        }
    }

    public void closed(NHttpServerConnection conn) {
        ProtocolState state = SourceContext.getState((NHttpConnection)conn);
        Map<String, String> logDetails = this.getLoggingInfo(conn, state);
        boolean isFault = false;
        if (state == ProtocolState.REQUEST_READY || state == ProtocolState.RESPONSE_DONE) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(conn + ": Keep-Alive connection was closed: " + this.getConnectionLoggingInfo(conn)));
            }
        } else if (state == ProtocolState.REQUEST_BODY || state == ProtocolState.REQUEST_HEAD) {
            isFault = true;
            this.informReaderError(conn);
            log.warn((Object)("STATE_DESCRIPTION = Connection closed while server accepting request headers but prior to finish reading the request body, INTERNAL_STATE = " + (Object)((Object)state) + ", DIRECTION = " + logDetails.get("direction") + ", CAUSE_OF_ERROR = Connection between EI and the Client has been closed, HTTP_URL = " + logDetails.get("url") + ", HTTP_METHOD = " + logDetails.get("method") + ", CLIENT_ADDRESS = " + this.getClientConnectionInfo(conn) + ", CONNECTION " + conn));
            if (this.sourceConfiguration.isCorrelationLoggingEnabled().booleanValue()) {
                this.logHttpRequestErrorInCorrelationLog(conn, "Connection Closed in " + state.name());
            }
        } else if (state == ProtocolState.RESPONSE_BODY || state == ProtocolState.RESPONSE_HEAD) {
            isFault = true;
            this.informWriterError(conn);
            log.warn((Object)("STATE_DESCRIPTION = Connection closed while server writing the response headers or body, INTERNAL_STATE = " + (Object)((Object)state) + ", DIRECTION = " + logDetails.get("direction") + ", CAUSE_OF_ERROR = Connection between EI and the Client has been closed, HTTP_URL = " + logDetails.get("url") + ", HTTP_METHOD = " + logDetails.get("method") + ", CLIENT_ADDRESS = " + this.getClientConnectionInfo(conn) + ", CONNECTION " + conn));
            if (this.sourceConfiguration.isCorrelationLoggingEnabled().booleanValue()) {
                this.logHttpRequestErrorInCorrelationLog(conn, "Connection Closed in " + state.name());
            }
        } else if (state == ProtocolState.REQUEST_DONE) {
            isFault = true;
            this.informWriterError(conn);
            log.warn((Object)("STATE_DESCRIPTION = Connection closed after server accepting the request headers and the request body, INTERNAL_STATE = " + (Object)((Object)state) + ", DIRECTION = " + logDetails.get("direction") + ", CAUSE_OF_ERROR = Connection between EI and the Client has been closed, HTTP_URL = " + logDetails.get("url") + ", HTTP_METHOD = " + logDetails.get("method") + ", CLIENT_ADDRESS = " + this.getClientConnectionInfo(conn) + ", CONNECTION " + conn));
            if (this.sourceConfiguration.isCorrelationLoggingEnabled().booleanValue()) {
                this.logHttpRequestErrorInCorrelationLog(conn, "Connection Closed in " + state.name());
            }
        }
        this.metrics.disconnected();
        SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
        this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, isFault);
        if (isFault) {
            this.rollbackTransaction(conn);
        }
    }

    public void endOfInput(NHttpServerConnection conn) throws IOException {
        conn.close();
    }

    public void exception(NHttpServerConnection conn, Exception ex) {
        boolean isFault = false;
        if (ex instanceof IOException) {
            this.logIOException(conn, (IOException)ex);
            if (this.sourceConfiguration.isCorrelationLoggingEnabled().booleanValue()) {
                this.logHttpRequestErrorInCorrelationLog(conn, "IO Exception");
            }
            this.metrics.incrementFaultsReceiving();
            ProtocolState state = SourceContext.getState((NHttpConnection)conn);
            if (state == ProtocolState.REQUEST_BODY || state == ProtocolState.REQUEST_HEAD) {
                this.informReaderError(conn);
            } else if (state == ProtocolState.RESPONSE_BODY || state == ProtocolState.RESPONSE_HEAD) {
                this.informWriterError(conn);
            } else if (state == ProtocolState.REQUEST_DONE) {
                this.informWriterError(conn);
            } else if (state == ProtocolState.RESPONSE_DONE) {
                this.informWriterError(conn);
            }
            isFault = true;
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        } else if (ex instanceof HttpException) {
            log.error((Object)"HttpException occurred ", (Throwable)ex);
            if (this.sourceConfiguration.isCorrelationLoggingEnabled().booleanValue()) {
                this.logHttpRequestErrorInCorrelationLog(conn, "HTTP Exception");
            }
            try {
                if (conn.isResponseSubmitted()) {
                    this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
                    return;
                }
                HttpContext httpContext = conn.getContext();
                BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 400, "Bad request");
                response.setParams((HttpParams)new DefaultedHttpParams(this.sourceConfiguration.getHttpParams(), response.getParams()));
                response.addHeader("Connection", "Close");
                httpContext.setAttribute("http.connection", (Object)conn);
                httpContext.setAttribute("http.request", null);
                httpContext.setAttribute("http.response", (Object)response);
                this.sourceConfiguration.getHttpProcessor().process((HttpResponse)response, httpContext);
                conn.submitResponse((HttpResponse)response);
                SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
                this.informWriterError(conn);
                conn.close();
            }
            catch (Exception ex1) {
                log.error((Object)ex1.getMessage(), (Throwable)ex1);
                SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
                this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
                isFault = true;
            }
        } else {
            log.error((Object)("Unexpected error: " + ex.getMessage()), (Throwable)ex);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
            isFault = true;
        }
        if (isFault) {
            this.rollbackTransaction(conn);
        }
    }

    private Map<String, String> getLoggingInfo(NHttpServerConnection conn, ProtocolState state) {
        HashMap<String, String> logDetails = new HashMap<String, String>();
        SourceContext sourceContext = SourceContext.get((NHttpConnection)conn);
        if (sourceContext != null) {
            String url = "";
            String method = "";
            if (sourceContext.getRequest() != null) {
                url = sourceContext.getRequest().getUri();
                method = sourceContext.getRequest().getMethod();
            } else {
                HttpRequest httpRequest = conn.getHttpRequest();
                if (httpRequest != null) {
                    url = httpRequest.getRequestLine().getUri();
                    method = httpRequest.getRequestLine().getMethod();
                }
            }
            logDetails.put("url", url);
            logDetails.put("method", method);
        }
        if (state != null) {
            if (state.compareTo(ProtocolState.REQUEST_DONE) <= 0) {
                logDetails.put("direction", "REQUEST");
            } else {
                logDetails.put("direction", "RESPONSE");
            }
        }
        return logDetails;
    }

    private void handleInvalidState(NHttpServerConnection conn, String action) {
        log.warn((Object)(action + " while the handler is in an inconsistent state " + (Object)((Object)SourceContext.getState((NHttpConnection)conn))));
        SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
        this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
    }

    public void informReaderError(NHttpServerConnection conn) {
        Pipe reader = SourceContext.get((NHttpConnection)conn).getReader();
        this.metrics.incrementFaultsReceiving();
        if (reader != null) {
            reader.producerError();
        } else {
            log.info((Object)"Reader null when calling informReaderError");
        }
    }

    public void informWriterError(NHttpServerConnection conn) {
        Pipe writer = SourceContext.get((NHttpConnection)conn).getWriter();
        this.metrics.incrementFaultsSending();
        if (writer != null) {
            writer.consumerError();
        } else {
            log.info((Object)"Writer null when calling informWriterError");
        }
    }

    public void commitResponseHideExceptions(NHttpServerConnection conn, HttpResponse response) {
        try {
            conn.suspendInput();
            this.sourceConfiguration.getHttpProcessor().process(response, conn.getContext());
            conn.submitResponse(response);
        }
        catch (HttpException e) {
            this.handleException("Unexpected HTTP protocol error : " + e.getMessage(), (Exception)((Object)e), conn);
        }
        catch (IOException e) {
            this.handleException("IO error submiting response : " + e.getMessage(), e, conn);
        }
    }

    public void stop() {
        this.latencyView.destroy();
        this.s2sLatencyView.destroy();
        this.threadingView.destroy();
        try {
            if (this.sourceConfiguration.getWorkerPool() != null) {
                this.sourceConfiguration.getWorkerPool().shutdown(1000);
            }
        }
        catch (InterruptedException e) {
            log.warn((Object)("Error while shutting down worker thread pool. " + e.getMessage()));
        }
    }

    private void handleException(String msg, Exception e, NHttpServerConnection conn) {
        log.error((Object)msg, (Throwable)e);
        if (conn != null) {
            // empty if block
        }
    }

    private void updateMetricsView(HttpContext context) {
        this.metrics.requestServed();
        if (context == null) {
            return;
        }
        this.latencyView.notifyTimes(new LatencyCollector(context, false));
        this.s2sLatencyView.notifyTimes(new LatencyCollector(context, true));
        LatencyCollector.clearTimestamps(context);
    }

    public OutputStream getOutputStream(String method, SourceRequest request) {
        ContentOutputStream os = null;
        if ("GET".equals(method) || "HEAD".equals(method)) {
            HttpContext context = request.getConnection().getContext();
            SimpleOutputBuffer outputBuffer = new SimpleOutputBuffer(this.sourceConfiguration.getIOBufferSize(), (ByteBufferAllocator)new HeapByteBufferAllocator());
            context.setAttribute("synapse.response-source-buffer", (Object)outputBuffer);
            os = new ContentOutputStream((ContentOutputBuffer)outputBuffer);
        }
        return os;
    }

    public SourceRequest getSourceRequest(NHttpServerConnection conn) throws IOException, HttpException {
        HttpContext context = conn.getContext();
        context.setAttribute("REQ_ARRIVAL_TIME", (Object)System.currentTimeMillis());
        if (!SourceContext.assertState((NHttpConnection)conn, ProtocolState.REQUEST_READY) && !SourceContext.assertState((NHttpConnection)conn, ProtocolState.WSDL_RESPONSE_DONE)) {
            this.handleInvalidState(conn, "Request received");
            return null;
        }
        this.sourceConfiguration.getSourceConnections().useConnection(conn);
        SourceContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_HEAD);
        SourceRequest request = new SourceRequest(this.sourceConfiguration, conn.getHttpRequest(), conn);
        SourceContext.setRequest((NHttpConnection)conn, request);
        request.start(conn);
        this.metrics.incrementMessagesReceived();
        return request;
    }

    private void rollbackTransaction(NHttpServerConnection conn) {
        try {
            Long serverWorkerThreadId = (Long)conn.getContext().getAttribute("SERVER_WORKER_THREAD_ID");
            if (serverWorkerThreadId != null) {
                TranscationManger.rollbackTransaction((boolean)false, (long)serverWorkerThreadId);
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Transaction rollback error after Connection closed " + ex.getMessage() + conn));
        }
    }

    private void endTransaction(NHttpServerConnection conn) {
        try {
            Long serverWorkerThreadId = (Long)conn.getContext().getAttribute("SERVER_WORKER_THREAD_ID");
            if (serverWorkerThreadId != null) {
                TranscationManger.endTransaction((boolean)false, (long)serverWorkerThreadId);
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Transaction rollback error after Connection closed " + ex.getMessage() + conn));
        }
    }

    private String getConnectionLoggingInfo(NHttpServerConnection conn) {
        IOSession session;
        if (conn instanceof LoggingNHttpServerConnection && (session = ((LoggingNHttpServerConnection)conn).getIOSession()) != null) {
            return " Remote Address : " + session.getRemoteAddress();
        }
        return "";
    }

    private String getClientConnectionInfo(NHttpServerConnection conn) {
        IOSession session;
        if (conn instanceof LoggingNHttpServerConnection && (session = ((LoggingNHttpServerConnection)conn).getIOSession()) != null) {
            return session.getRemoteAddress().toString();
        }
        return "";
    }

    private void logHttpRequestErrorInCorrelationLog(NHttpServerConnection conn, String state) {
        SourceContext sourceContext = SourceContext.get((NHttpConnection)conn);
        if (sourceContext != null) {
            String url = "";
            String method = "";
            if (sourceContext.getRequest() != null) {
                url = sourceContext.getRequest().getUri();
                method = sourceContext.getRequest().getMethod();
            } else {
                HttpRequest httpRequest = conn.getHttpRequest();
                if (httpRequest != null) {
                    url = httpRequest.getRequestLine().getUri();
                    method = httpRequest.getRequestLine().getMethod();
                }
            }
            if (method.length() != 0 && url.length() != 0) {
                long startTime = (Long)conn.getContext().getAttribute("REQ_ARRIVAL_TIME");
                ContextAwareLogger.getLogger((HttpContext)conn.getContext(), (Log)correlationLog, (boolean)false).info((Object)(System.currentTimeMillis() - startTime + "|HTTP|" + conn.getContext().getAttribute("http.connection") + "|" + method + "|" + url + "|" + state));
            }
        }
    }
}

