/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpRequest;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.protocol.HttpContext;
import org.apache.synapse.commons.logger.ContextAwareLogger;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.SourceRequest;
import org.apache.synapse.transport.passthru.SourceResponse;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.apache.synapse.transport.passthru.util.ControlledByteBuffer;

public class SourceContext {
    public static final String CONNECTION_INFORMATION = "CONNECTION_INFORMATION";
    private static final Log correlationLog = LogFactory.getLog((String)"correlation");
    private SourceConfiguration sourceConfiguration;
    private ProtocolState state = ProtocolState.REQUEST_READY;
    private SourceRequest request;
    private SourceResponse response;
    private boolean shutDown = false;
    private Pipe reader;
    private Pipe writer;
    private Lock lock = new ReentrantLock();
    private long lastStateUpdatedTime;

    public SourceContext(SourceConfiguration sourceConfiguration) {
        this.sourceConfiguration = sourceConfiguration;
    }

    public SourceConfiguration getSourceConfiguration() {
        return this.sourceConfiguration;
    }

    public ProtocolState getState() {
        return this.state;
    }

    public void setState(ProtocolState state) {
        this.state = state;
    }

    public SourceRequest getRequest() {
        return this.request;
    }

    public void setRequest(SourceRequest request) {
        this.request = request;
    }

    public SourceResponse getResponse() {
        return this.response;
    }

    public void setResponse(SourceResponse response) {
        this.response = response;
    }

    public void reset() {
        this.reset(false);
    }

    public void reset(boolean isError) {
        this.request = null;
        this.response = null;
        this.state = ProtocolState.REQUEST_READY;
        if (this.writer != null && !isError) {
            ControlledByteBuffer buffer = this.writer.getBuffer();
            this.sourceConfiguration.getBufferFactory().release(buffer);
        }
        this.reader = null;
        this.writer = null;
    }

    public Lock getLock() {
        return this.lock;
    }

    public boolean isShutDown() {
        return this.shutDown;
    }

    public void setShutDown(boolean shutDown) {
        this.shutDown = shutDown;
    }

    public Pipe getReader() {
        return this.reader;
    }

    public void setReader(Pipe reader) {
        this.reader = reader;
    }

    public Pipe getWriter() {
        return this.writer;
    }

    public void setWriter(Pipe writer) {
        this.writer = writer;
    }

    public static void create(NHttpConnection conn, ProtocolState state, SourceConfiguration configuration) {
        SourceContext sourceContext = new SourceContext(configuration);
        conn.getContext().setAttribute(CONNECTION_INFORMATION, (Object)sourceContext);
        sourceContext.setState(state);
        if (sourceContext.getSourceConfiguration().isCorrelationLoggingEnabled().booleanValue()) {
            sourceContext.updateLastStateUpdatedTime();
        }
    }

    public static void updateState(NHttpConnection conn, ProtocolState state) {
        SourceContext sourceContext = (SourceContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        if (sourceContext != null) {
            if (sourceContext.getState() == state) {
                return;
            }
            if (sourceContext.getSourceConfiguration().isCorrelationLoggingEnabled().booleanValue()) {
                long lastStateUpdateTime = sourceContext.getLastStateUpdatedTime();
                String url = "";
                String method = "";
                if (sourceContext.getRequest() != null) {
                    url = sourceContext.getRequest().getUri();
                    method = sourceContext.getRequest().getMethod();
                } else {
                    HttpRequest httpRequest = conn.getHttpRequest();
                    if (httpRequest != null) {
                        url = httpRequest.getRequestLine().getUri();
                        method = httpRequest.getRequestLine().getMethod();
                    }
                }
                if (method.length() != 0 && url.length() != 0) {
                    ContextAwareLogger.getLogger((HttpContext)conn.getContext(), (Log)correlationLog, (boolean)false).info((Object)(sourceContext.updateLastStateUpdatedTime() - lastStateUpdateTime + "|HTTP State Transition|" + conn.getContext().getAttribute("http.connection") + "|" + method + "|" + url + "|" + state.name()));
                }
            }
        } else {
            throw new IllegalStateException("Connection information should be present");
        }
        sourceContext.setState(state);
    }

    public static boolean assertState(NHttpConnection conn, ProtocolState state) {
        SourceContext info = (SourceContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        return info != null && info.getState() == state;
    }

    public static ProtocolState getState(NHttpConnection conn) {
        SourceContext info = (SourceContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        return info != null ? info.getState() : null;
    }

    public static void setRequest(NHttpConnection conn, SourceRequest request) {
        SourceContext info = (SourceContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        if (info == null) {
            throw new IllegalStateException("Connection information should be present");
        }
        info.setRequest(request);
    }

    public static void setResponse(NHttpConnection conn, SourceResponse response) {
        SourceContext info = (SourceContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        if (info == null) {
            throw new IllegalStateException("Connection information should be present");
        }
        info.setResponse(response);
    }

    public static SourceRequest getRequest(NHttpConnection conn) {
        SourceContext info = (SourceContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        return info != null ? info.getRequest() : null;
    }

    public static SourceResponse getResponse(NHttpConnection conn) {
        SourceContext info = (SourceContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        return info != null ? info.getResponse() : null;
    }

    public static SourceContext get(NHttpConnection conn) {
        return (SourceContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
    }

    public static Lock getLock(NHttpConnection conn) {
        SourceContext info = (SourceContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        return info != null ? info.getLock() : null;
    }

    public long getLastStateUpdatedTime() {
        return this.lastStateUpdatedTime;
    }

    public long updateLastStateUpdatedTime() {
        this.lastStateUpdatedTime = System.currentTimeMillis();
        return this.lastStateUpdatedTime;
    }
}

