/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.dispatchers.RequestURIBasedDispatcher;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.reactor.ssl.SSLIOSession;
import org.apache.log4j.MDC;
import org.apache.synapse.commons.util.ext.TenantInfoInitiator;
import org.apache.synapse.commons.util.ext.TenantInfoInitiatorProvider;
import org.apache.synapse.transport.customlogsetter.CustomLogSetter;
import org.apache.synapse.transport.nhttp.HttpCoreRequestResponseTransport;
import org.apache.synapse.transport.nhttp.util.NhttpUtil;
import org.apache.synapse.transport.nhttp.util.RESTUtil;
import org.apache.synapse.transport.passthru.HttpGetRequestProcessor;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.SourceContext;
import org.apache.synapse.transport.passthru.SourceRequest;
import org.apache.synapse.transport.passthru.SourceResponse;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.apache.synapse.transport.passthru.util.SourceResponseFactory;

public class ServerWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(ServerWorker.class);
    private static final Log correlationLog = LogFactory.getLog((String)"correlation");
    private MessageContext msgContext = null;
    private SourceRequest request = null;
    private SourceConfiguration sourceConfiguration = null;
    private long initiationTimestamp = 0L;
    private String correlationId;
    private static final String SOAP_ACTION_HEADER = "SOAPAction";
    private static final String HTTP_METHOD = "HTTP_METHOD";
    private HttpGetRequestProcessor httpGetRequestProcessor = null;
    private boolean isRestDispatching = true;
    private OutputStream os;

    public ServerWorker(SourceRequest request, SourceConfiguration sourceConfiguration, OutputStream os) {
        this.request = request;
        this.sourceConfiguration = sourceConfiguration;
        this.msgContext = this.createMessageContext(null, request);
        this.httpGetRequestProcessor = sourceConfiguration.getHttpGetRequestProcessor();
        this.os = os;
        this.msgContext.setProperty("pass-through.Source-Request", (Object)request);
        this.msgContext.setProperty("PASS_THROUGH_SOURCE_CONFIGURATION", (Object)sourceConfiguration);
        this.msgContext.setProperty("pass-through.Source-Connection", (Object)request.getConnection());
        this.msgContext.setProperty("synapse.wire.log.holder", request.getConnection().getContext().getAttribute("synapse.wire.log.holder"));
        request.getConnection().getContext().setAttribute("SERVER_WORKER_INIT_TIME", (Object)System.currentTimeMillis());
        request.getConnection().getContext().setAttribute("REQUEST_MESSAGE_CONTEXT", (Object)this.msgContext);
    }

    public ServerWorker(SourceRequest request, SourceConfiguration sourceConfiguration, OutputStream os, long initiationTimestamp, String correlationId) {
        this(request, sourceConfiguration, os);
        this.initiationTimestamp = initiationTimestamp;
        this.correlationId = correlationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            MDC.remove((String)"Correlation-ID");
            if (this.sourceConfiguration.isCorrelationLoggingEnabled().booleanValue() && StringUtils.isNotEmpty((String)this.correlationId)) {
                MDC.put((String)"Correlation-ID", (Object)this.correlationId);
                if (this.initiationTimestamp != 0L) {
                    correlationLog.info((Object)(System.currentTimeMillis() - this.initiationTimestamp + "|Thread switch latency"));
                }
            }
            CustomLogSetter.getInstance().clearThreadLocalContent();
            TenantInfoInitiator tenantInfoInitiator = TenantInfoInitiatorProvider.getTenantInfoInitiator();
            if (tenantInfoInitiator != null) {
                tenantInfoInitiator.initTenantInfo(this.request.getUri());
            }
            this.request.getConnection().getContext().setAttribute("SERVER_WORKER_START_TIME", (Object)System.currentTimeMillis());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting a new Server Worker instance");
            }
            String method = this.request.getRequest() != null ? this.request.getRequest().getRequestLine().getMethod().toUpperCase() : "";
            this.processHttpRequestUri(this.msgContext, method);
            if (this.isRequestToFetchWSDL()) {
                return;
            }
            boolean isRest = this.isRESTRequest(this.msgContext, method);
            if (!isRest) {
                if (this.request.isEntityEnclosing()) {
                    this.processEntityEnclosingRequest(this.msgContext, true);
                } else {
                    this.processNonEntityEnclosingRESTHandler(null, this.msgContext, true);
                }
            } else {
                String contentTypeHeader = this.request.getHeaders().get("Content-Type");
                SOAPEnvelope soapEnvelope = this.handleRESTUrlPost(contentTypeHeader);
                this.processNonEntityEnclosingRESTHandler(soapEnvelope, this.msgContext, true);
            }
            this.sendAck(this.msgContext);
        }
        finally {
            this.cleanup();
        }
    }

    private boolean isRequestToFetchWSDL() {
        SourceContext info = (SourceContext)this.request.getConnection().getContext().getAttribute("CONNECTION_INFORMATION");
        return info != null && info.getState().equals((Object)ProtocolState.WSDL_RESPONSE_DONE) || this.msgContext.getProperty("WSDL_GEN_HANDLED") != null && Boolean.TRUE.equals(this.msgContext.getProperty("WSDL_GEN_HANDLED"));
    }

    public SOAPEnvelope handleRESTUrlPost(String contentTypeHdr) throws FactoryConfigurationError {
        String contentType;
        SOAPEnvelope soapEnvelope = null;
        String string = contentType = contentTypeHdr != null ? TransportUtils.getContentType((String)contentTypeHdr, (MessageContext)this.msgContext) : null;
        if (contentType == null || contentType.isEmpty()) {
            contentType = "application/octet-stream";
            if ("GET".equals(this.msgContext.getProperty(HTTP_METHOD)) || "DELETE".equals(this.msgContext.getProperty(HTTP_METHOD))) {
                contentType = "application/x-www-form-urlencoded";
            }
        }
        if ("application/x-www-form-urlencoded".equals(contentType) || "application/octet-stream".equals(contentType) && contentTypeHdr == null) {
            String charSetEncoding;
            this.msgContext.setTo(new EndpointReference(this.request.getRequest().getRequestLine().getUri()));
            if (contentTypeHdr != null) {
                this.msgContext.setProperty("ContentType", (Object)contentTypeHdr);
                charSetEncoding = BuilderUtil.getCharSetEncoding((String)contentTypeHdr);
            } else {
                this.msgContext.setProperty("ContentType", (Object)contentType);
                charSetEncoding = BuilderUtil.getCharSetEncoding((String)contentType);
            }
            this.msgContext.setProperty("CHARACTER_SET_ENCODING", (Object)charSetEncoding);
            try {
                RESTUtil.dispatchAndVerify(this.msgContext);
            }
            catch (AxisFault e1) {
                log.error((Object)"Error while building message for REST_URL request", (Throwable)e1);
            }
            try {
                boolean reverseProxyMode = PassThroughConfiguration.getInstance().isReverseProxyMode();
                AxisService axisService = null;
                if (!reverseProxyMode) {
                    RequestURIBasedDispatcher requestDispatcher = new RequestURIBasedDispatcher();
                    axisService = requestDispatcher.findService(this.msgContext);
                }
                boolean isCustomRESTDispatcher = false;
                String requestURI = this.request.getRequest().getRequestLine().getUri();
                if (requestURI.matches(PassThroughConfiguration.getInstance().getRestUriApiRegex()) || requestURI.matches(PassThroughConfiguration.getInstance().getRestUriProxyRegex())) {
                    isCustomRESTDispatcher = true;
                }
                if (!isCustomRESTDispatcher) {
                    if (axisService == null) {
                        String defaultSvcName = PassThroughConfiguration.getInstance().getPassThroughDefaultServiceName();
                        axisService = this.msgContext.getConfigurationContext().getAxisConfiguration().getService(defaultSvcName);
                        this.msgContext.setAxisService(axisService);
                    }
                } else {
                    String multiTenantDispatchService = PassThroughConfiguration.getInstance().getRESTDispatchService();
                    axisService = this.msgContext.getConfigurationContext().getAxisConfiguration().getService(multiTenantDispatchService);
                    this.msgContext.setAxisService(axisService);
                }
            }
            catch (AxisFault e) {
                this.handleException("Error processing " + this.request.getMethod() + " request for : " + this.request.getUri(), (Exception)((Object)e));
            }
            try {
                soapEnvelope = TransportUtils.createSOAPMessage((MessageContext)this.msgContext, null, (String)contentType);
            }
            catch (Exception e) {
                log.error((Object)"Error while building message for REST_URL request");
            }
            this.msgContext.setProperty("messageType", (Object)"application/xml");
        }
        return soapEnvelope;
    }

    public void sendAck(MessageContext msgContext) {
        String respWritten = "";
        if (msgContext.getOperationContext() != null) {
            respWritten = (String)msgContext.getOperationContext().getProperty("RESPONSE_WRITTEN");
        }
        if (msgContext.getProperty("FORCE_SOAP_FAULT") != null) {
            respWritten = "SKIP";
        }
        boolean respWillFollow = !"true".equals(respWritten) && !"SKIP".equals(respWritten);
        boolean ack = ((RequestResponseTransport)msgContext.getProperty("RequestResponseTransportControl")).getStatus() == RequestResponseTransport.RequestResponseTransportStatus.ACKED;
        boolean forced = msgContext.isPropertyTrue("FORCE_SC_ACCEPTED");
        boolean nioAck = msgContext.isPropertyTrue("NIO-ACK-Requested", false);
        if (respWillFollow || ack || forced || nioAck) {
            SourceResponse sourceResponse;
            NHttpServerConnection conn = this.request.getConnection();
            if (!nioAck) {
                msgContext.removeProperty("TRANSPORT_HEADERS");
                sourceResponse = SourceResponseFactory.create(msgContext, this.request, this.sourceConfiguration);
                sourceResponse.setStatus(202);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending ACK response with status " + msgContext.getProperty("HTTP_SC") + ", for MessageID : " + msgContext.getMessageID()));
                }
                sourceResponse = SourceResponseFactory.create(msgContext, this.request, this.sourceConfiguration);
                sourceResponse.setStatus(Integer.parseInt(msgContext.getProperty("HTTP_SC").toString()));
            }
            SourceContext.setResponse((NHttpConnection)conn, sourceResponse);
            ProtocolState state = SourceContext.getState((NHttpConnection)conn);
            if (state != null && state.compareTo(ProtocolState.REQUEST_DONE) <= 0) {
                conn.requestOutput();
            } else {
                SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
                this.sourceConfiguration.getSourceConnections().shutDownConnection(conn);
            }
        }
    }

    public void processNonEntityEnclosingRESTHandler(SOAPEnvelope soapEnvelope, MessageContext msgContext, boolean injectToAxis2Engine) {
        String soapAction = this.request.getHeaders().get(SOAP_ACTION_HEADER);
        if (soapAction != null && soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
            soapAction = soapAction.substring(1, soapAction.length() - 1);
        }
        msgContext.setSoapAction(soapAction);
        msgContext.setTo(new EndpointReference(this.request.getUri()));
        msgContext.setServerSide(true);
        msgContext.setDoingREST(true);
        if (!this.request.isEntityEnclosing()) {
            msgContext.setProperty("NO_ENTITY_BODY", (Object)Boolean.TRUE);
        }
        try {
            if (soapEnvelope == null) {
                msgContext.setEnvelope(new SOAP11Factory().getDefaultEnvelope());
            } else {
                msgContext.setEnvelope(soapEnvelope);
            }
            if (injectToAxis2Engine) {
                AxisEngine.receive((MessageContext)msgContext);
            }
        }
        catch (AxisFault axisFault) {
            this.handleException("Error processing " + this.request.getMethod() + " request for : " + this.request.getUri(), (Exception)((Object)axisFault));
        }
        catch (Exception e) {
            String encodedURL = StringEscapeUtils.escapeHtml((String)this.request.getUri());
            this.handleException("Error processing " + this.request.getMethod() + " request for : " + encodedURL + ". ", e);
        }
    }

    private void consumeInputOnException(MessageContext msgContext) {
        try {
            RelayUtils.discardRequestMessage(msgContext);
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Exception while consuming the input stream on Axis Fault", (Throwable)axisFault);
        }
    }

    public void processEntityEnclosingRequest(MessageContext msgContext, boolean injectToAxis2Engine) {
        try {
            SOAPEnvelope envelope;
            String contentTypeHeader = this.request.getHeaders().get("Content-Type");
            contentTypeHeader = contentTypeHeader != null ? contentTypeHeader : this.inferContentType();
            String charSetEncoding = null;
            String contentType = null;
            if (contentTypeHeader != null) {
                charSetEncoding = BuilderUtil.getCharSetEncoding((String)contentTypeHeader);
                contentType = TransportUtils.getContentType((String)contentTypeHeader, (MessageContext)msgContext);
            }
            if (charSetEncoding == null) {
                charSetEncoding = "UTF-8";
            }
            String method = this.request.getRequest() != null ? this.request.getRequest().getRequestLine().getMethod().toUpperCase() : "";
            msgContext.setTo(new EndpointReference(this.request.getUri()));
            msgContext.setProperty("HTTP_METHOD_OBJECT", (Object)method);
            msgContext.setProperty("CHARACTER_SET_ENCODING", (Object)charSetEncoding);
            msgContext.setServerSide(true);
            msgContext.setProperty("ContentType", (Object)contentTypeHeader);
            msgContext.setProperty("messageType", (Object)contentType);
            if (contentTypeHeader == null || HTTPTransportUtils.isRESTRequest((String)contentTypeHeader) || this.isRest(contentTypeHeader)) {
                msgContext.setProperty("synapse.internal.rest.contentType", (Object)contentType);
                msgContext.setDoingREST(true);
                SOAPEnvelope soapEnvelope = this.handleRESTUrlPost(contentTypeHeader);
                msgContext.setProperty("pass-through.pipe", (Object)this.request.getPipe());
                this.processNonEntityEnclosingRESTHandler(soapEnvelope, msgContext, injectToAxis2Engine);
                return;
            }
            String soapAction = this.request.getHeaders().get(SOAP_ACTION_HEADER);
            int soapVersion = HTTPTransportUtils.initializeMessageContext((MessageContext)msgContext, (String)soapAction, (String)this.request.getUri(), (String)contentTypeHeader);
            if (soapVersion == 1) {
                SOAPFactory fac = OMAbstractFactory.getSOAP11Factory();
                envelope = fac.getDefaultEnvelope();
            } else if (soapVersion == 2) {
                SOAPFactory fac = OMAbstractFactory.getSOAP12Factory();
                envelope = fac.getDefaultEnvelope();
            } else {
                SOAPFactory fac = OMAbstractFactory.getSOAP12Factory();
                envelope = fac.getDefaultEnvelope();
            }
            if (soapAction != null && soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
                soapAction = soapAction.substring(1, soapAction.length() - 1);
                msgContext.setSoapAction(soapAction);
            }
            msgContext.setEnvelope(envelope);
            msgContext.setProperty("pass-through.pipe", (Object)this.request.getPipe());
            if (injectToAxis2Engine) {
                AxisEngine.receive((MessageContext)msgContext);
            }
        }
        catch (AxisFault axisFault) {
            this.handleException("Error processing " + this.request.getMethod() + " request for : " + this.request.getUri(), (Exception)((Object)axisFault));
        }
        catch (Exception e) {
            this.handleException("Error processing " + this.request.getMethod() + " request for : " + this.request.getUri() + ". Error detail: " + e.getMessage() + ". ", e);
        }
    }

    private boolean isRest(String contentType) {
        return contentType != null && contentType.indexOf("text/xml") == -1 && contentType.indexOf("application/soap+xml") == -1;
    }

    public MessageContext createMessageContext(MessageContext msgContext, SourceRequest request) {
        HttpInetConnection netConn;
        InetAddress remoteAddress;
        Map excessHeaders = request.getExcessHeaders();
        ConfigurationContext cfgCtx = this.sourceConfiguration.getConfigurationContext();
        NHttpServerConnection conn = request.getConnection();
        Object systemGeneratedCorrelationLog = conn.getContext().getAttribute("systemGeneratedCorrelationId");
        Object correlationId = conn.getContext().getAttribute("correlation_id");
        if (msgContext == null) {
            msgContext = new MessageContext();
        }
        String messageId = null;
        if (systemGeneratedCorrelationLog instanceof Boolean && ((Boolean)systemGeneratedCorrelationLog).booleanValue() && correlationId instanceof String && StringUtils.isNotEmpty((String)((String)correlationId))) {
            messageId = "urn:uuid:" + correlationId;
        }
        if (StringUtils.isEmpty(messageId)) {
            messageId = UIDGenerator.generateURNString();
        }
        msgContext.setMessageID(messageId);
        msgContext.setProperty("ClientApiNonBlocking", (Object)Boolean.FALSE);
        msgContext.setConfigurationContext(cfgCtx);
        msgContext.setProperty("correlation_id", correlationId);
        msgContext.setProperty("INTERNAL_TRANSACTION_COUNTED", conn.getContext().getAttribute("INTERNAL_TRANSACTION_COUNTED"));
        if (this.sourceConfiguration.getScheme().isSSL()) {
            msgContext.setTransportOut(cfgCtx.getAxisConfiguration().getTransportOut("https"));
            msgContext.setTransportIn(cfgCtx.getAxisConfiguration().getTransportIn("https"));
            msgContext.setIncomingTransportName(this.sourceConfiguration.getInDescription() != null ? this.sourceConfiguration.getInDescription().getName() : "https");
            SSLIOSession ssliosession = (SSLIOSession)conn.getContext().getAttribute("http.session.ssl");
            if (ssliosession != null && msgContext.getTransportIn() != null && msgContext.getTransportIn().getParameter("SSLVerifyClient") != null) {
                try {
                    msgContext.setProperty("ssl.client.auth.cert.X509", (Object)ssliosession.getSSLSession().getPeerCertificateChain());
                }
                catch (SSLPeerUnverifiedException e) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Peer certificate chain is not available for MsgContext " + msgContext.getMessageID()));
                    }
                }
            }
        } else {
            msgContext.setTransportOut(cfgCtx.getAxisConfiguration().getTransportOut("http"));
            msgContext.setTransportIn(cfgCtx.getAxisConfiguration().getTransportIn("http"));
            msgContext.setIncomingTransportName(this.sourceConfiguration.getInDescription() != null ? this.sourceConfiguration.getInDescription().getName() : "http");
        }
        msgContext.setProperty("OutTransportInfo", (Object)this);
        msgContext.setServerSide(true);
        msgContext.setProperty("TransportInURL", (Object)request.getUri());
        TreeMap<String, String> headers = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        Set<Map.Entry<String, String>> entries = request.getHeaders().entrySet();
        for (Map.Entry<String, String> entry : entries) {
            headers.put(entry.getKey(), entry.getValue());
        }
        msgContext.setProperty("TRANSPORT_HEADERS", headers);
        msgContext.setProperty("EXCESS_TRANSPORT_HEADERS", (Object)excessHeaders);
        if (conn instanceof HttpInetConnection && (remoteAddress = (netConn = (HttpInetConnection)conn).getRemoteAddress()) != null) {
            msgContext.setProperty("REMOTE_ADDR", (Object)remoteAddress.getHostAddress());
            msgContext.setProperty("REMOTE_HOST", (Object)NhttpUtil.getHostName(remoteAddress));
        }
        msgContext.setProperty("RequestResponseTransportControl", (Object)new HttpCoreRequestResponseTransport(msgContext));
        return msgContext;
    }

    private void handleException(String msg, Exception e) {
        if (e == null) {
            log.error((Object)msg);
        } else {
            log.error((Object)msg, (Throwable)e);
        }
        if (e == null) {
            e = new Exception(msg);
        }
        this.consumeInputOnException(this.msgContext);
        try {
            MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)this.msgContext, (Throwable)e);
            this.msgContext.setProperty("FORCE_SOAP_FAULT", (Object)Boolean.TRUE);
            AxisEngine.sendFault((MessageContext)faultContext);
        }
        catch (Exception ex) {
            NHttpServerConnection conn = this.request.getConnection();
            this.msgContext.removeProperty("TRANSPORT_HEADERS");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending ACK response with status " + this.msgContext.getProperty("HTTP_SC") + ", for MessageID : " + this.msgContext.getMessageID()));
            }
            SourceResponse sourceResponse = SourceResponseFactory.create(this.msgContext, this.request, this.sourceConfiguration);
            sourceResponse.addHeader("Content-Type", "text/html");
            sourceResponse.setStatus(500);
            Pipe pipe = new Pipe(this.sourceConfiguration.getBufferFactory().getBuffer(), "Test", this.sourceConfiguration);
            this.msgContext.setProperty("pass-through.pipe", (Object)pipe);
            this.msgContext.setProperty("message.builder.invoked", (Object)Boolean.TRUE);
            pipe.attachConsumer((IOControl)conn);
            sourceResponse.connect(pipe);
            OutputStream os = pipe.getOutputStream();
            try {
                String body = "<html><body><h1>Failed to process the request</h1><p>" + msg + "</p>";
                if (e != null) {
                    body = body + "<p>" + msg + "</p></body></html>";
                }
                if (ex != null) {
                    body = body + "<p>" + ex.getMessage() + "</p></body></html>";
                }
                os.write(body.getBytes());
                os.flush();
                os.close();
            }
            catch (Exception body) {
                // empty catch block
            }
            pipe.setSerializationComplete(true);
            SourceContext.setResponse((NHttpConnection)conn, sourceResponse);
            ProtocolState state = SourceContext.getState((NHttpConnection)conn);
            if (state != null && state.compareTo(ProtocolState.REQUEST_DONE) <= 0) {
                conn.requestOutput();
            }
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        }
    }

    private String inferContentType() {
        Map<String, String> headers = this.request.getHeaders();
        for (String header : headers.keySet()) {
            if (!"Content-Type".equalsIgnoreCase(header)) continue;
            return headers.get(header);
        }
        Parameter param = this.sourceConfiguration.getConfigurationContext().getAxisConfiguration().getParameter("DEFAULT_REQUEST_CONTENT_TYPE");
        if (param != null) {
            return param.getValue().toString();
        }
        return null;
    }

    public MessageContext getRequestContext() {
        return this.msgContext;
    }

    public SourceRequest getSourceRequest() {
        return this.request;
    }

    public void setSourceRequest(SourceRequest request) {
        this.request = request;
    }

    public boolean isRESTRequest(MessageContext msgContext, String method) {
        if (msgContext.getProperty("rest_get_delete_invoke") != null && ((Boolean)msgContext.getProperty("rest_get_delete_invoke")).booleanValue()) {
            msgContext.setProperty("HTTP_METHOD_OBJECT", (Object)method);
            msgContext.setServerSide(true);
            msgContext.setDoingREST(true);
            return true;
        }
        return false;
    }

    public void processHttpRequestUri(MessageContext msgContext, String method) {
        HttpInetConnection inetConn;
        InetAddress localAddr;
        String servicePrefixIndex = "://";
        ConfigurationContext cfgCtx = this.sourceConfiguration.getConfigurationContext();
        msgContext.setProperty(HTTP_METHOD, (Object)this.request.getMethod());
        String oriUri = this.request.getUri();
        String restUrlPostfix = NhttpUtil.getRestUrlPostfix(oriUri, cfgCtx.getServicePath());
        String servicePrefix = oriUri.substring(0, oriUri.indexOf(restUrlPostfix));
        if (servicePrefix.indexOf(servicePrefixIndex) == -1 && (localAddr = (inetConn = (HttpInetConnection)this.request.getConnection()).getLocalAddress()) != null) {
            servicePrefix = this.sourceConfiguration.getScheme().getName() + servicePrefixIndex + localAddr.getHostAddress() + ":" + inetConn.getLocalPort() + servicePrefix;
        }
        msgContext.setProperty("SERVICE_PREFIX", (Object)servicePrefix);
        msgContext.setTo(new EndpointReference(restUrlPostfix));
        msgContext.setProperty("REST_URL_POSTFIX", (Object)restUrlPostfix);
        if ("GET".equals(method) || "HEAD".equals(method) || "OPTIONS".equals(method)) {
            HttpResponse response = this.sourceConfiguration.getResponseFactory().newHttpResponse(this.request.getVersion(), 200, this.request.getConnection().getContext());
            BasicHttpEntity entity = new BasicHttpEntity();
            if (this.request.getVersion().greaterEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
                entity.setChunked(true);
            }
            response.setEntity((HttpEntity)entity);
            this.httpGetRequestProcessor.process(this.request.getRequest(), response, msgContext, this.request.getConnection(), this.os, this.isRestDispatching);
        }
    }

    public SourceConfiguration getSourceConfiguration() {
        return this.sourceConfiguration;
    }

    private void cleanup() {
        MessageContext.destroyCurrentMessageContext();
        TenantInfoInitiator tenantInfoInitiator = TenantInfoInitiatorProvider.getTenantInfoInitiator();
        if (tenantInfoInitiator != null) {
            tenantInfoInitiator.cleanTenantInfo();
        }
    }
}

