/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.IOException;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.impl.nio.reactor.AbstractIODispatch;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.reactor.IOSession;
import org.apache.synapse.transport.http.conn.LoggingUtils;
import org.apache.synapse.transport.http.conn.ServerConnFactory;

public class ServerIODispatch
extends AbstractIODispatch<DefaultNHttpServerConnection> {
    private final NHttpServerEventHandler handler;
    private volatile ServerConnFactory connFactory;

    public ServerIODispatch(NHttpServerEventHandler handler, ServerConnFactory connFactory) {
        this.handler = LoggingUtils.decorate(handler);
        this.connFactory = connFactory;
    }

    public void update(ServerConnFactory connFactory) {
        this.connFactory = connFactory;
    }

    protected DefaultNHttpServerConnection createConnection(IOSession session) {
        return this.connFactory.createConnection(session);
    }

    protected void onConnected(DefaultNHttpServerConnection conn) {
        try {
            this.handler.connected((NHttpServerConnection)conn);
        }
        catch (Exception ex) {
            this.handler.exception((NHttpServerConnection)conn, ex);
        }
    }

    protected void onClosed(DefaultNHttpServerConnection conn) {
        this.handler.closed((NHttpServerConnection)conn);
    }

    protected void onException(DefaultNHttpServerConnection conn, IOException ex) {
        this.handler.exception((NHttpServerConnection)conn, (Exception)ex);
    }

    protected void onInputReady(DefaultNHttpServerConnection conn) {
        conn.consumeInput(this.handler);
    }

    protected void onOutputReady(DefaultNHttpServerConnection conn) {
        conn.produceOutput(this.handler);
    }

    protected void onTimeout(DefaultNHttpServerConnection conn) {
        try {
            this.handler.timeout((NHttpServerConnection)conn);
        }
        catch (Exception ex) {
            this.handler.exception((NHttpServerConnection)conn, ex);
        }
    }
}

